package com.locnavi.location.xunjimap;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;


import org.apache.cordova.CordovaActivity;
import org.apache.cordova.CordovaWebView;

/**
 * author:chen
 * time:2020-06-29
 * desc:
 */
public class XJWebMapActivity extends CordovaActivity {

    public static String REQUEST_ID = "id";
    public static String REQUEST_APP_KEY = "appKey";
    public static String REQUEST_USER_ID = "userId";
    public static String REQUEST_POI = "poi";
    private String url = "https://ma.locnavi.com";

    public static void start(Context context, String id, String appKey, String userId, String poi){
        Intent intent = new Intent(context, XJWebMapActivity.class);
        intent.putExtra(REQUEST_ID, id);
        intent.putExtra(REQUEST_APP_KEY, appKey);
        intent.putExtra(REQUEST_USER_ID, userId);
        intent.putExtra(REQUEST_POI, poi);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        // enable Cordova apps to be started in the background
        Bundle extras = getIntent().getExtras();
        if (extras != null && extras.getBoolean("cdvStartInBackground", false)) {
            moveTaskToBack(true);
        }

        // Set by <content src="index.html" /> in config.xml
        loadUrl(launchUrl);

        String id = getIntent().getStringExtra(REQUEST_ID);
        String appKey = getIntent().getStringExtra(REQUEST_APP_KEY);
        String userId = getIntent().getStringExtra(REQUEST_USER_ID);
        String poi = getIntent().getStringExtra(REQUEST_POI);
        if(!TextUtils.isEmpty(id) && !TextUtils.isEmpty(id) && !TextUtils.isEmpty(id)){
            url += "?id=" + id;
            url += "&appKey=" + appKey;
            url += "&userId=" + userId;
        }
        if(!TextUtils.isEmpty(poi)){
            url += "&poi=" + poi;
        }
        new Handler().postDelayed(() -> {
            loadUrl("javascript:showMap(\"" + url + "\")");
        }, 1000);
    }

}
