package com.locnavi.location.xunjimap;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.locnavi.location.BuildConfig;
import com.locnavi.location.R;
import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.PrettyFormatStrategy;
import com.parse.Parse;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseQuery;

//import com.xunji.xunjilocation.BuildConfig;
//import com.locnavi.location.R;
import com.locnavi.location.uploadlocation.DaemonEnv;
import com.locnavi.location.uploadlocation.impl.TraceServiceImpl;
import com.locnavi.location.xunjimap.model.bean.DataHolder;
import com.locnavi.location.xunjimap.model.parse.AndroidLSR;
import com.locnavi.location.xunjimap.model.parse.App;
import com.locnavi.location.xunjimap.model.parse.Background;
import com.locnavi.location.xunjimap.model.parse.BaiduKey;
import com.locnavi.location.xunjimap.model.parse.BeaconMap;
import com.locnavi.location.xunjimap.model.parse.District;
import com.locnavi.location.xunjimap.model.parse.FeedBack;
import com.locnavi.location.xunjimap.model.parse.IpsUser;
import com.locnavi.location.xunjimap.model.parse.LocationShare;
import com.locnavi.location.xunjimap.model.parse.MapData;
import com.locnavi.location.xunjimap.model.parse.NavigationPhoto;
import com.locnavi.location.xunjimap.model.parse.POI;
import com.locnavi.location.xunjimap.model.parse.POIGenre;
import com.locnavi.location.xunjimap.model.parse.Partner;
import com.locnavi.location.xunjimap.model.parse.Project;
import com.locnavi.location.xunjimap.model.parse.Punch;
import com.locnavi.location.xunjimap.model.parse.Synonym;
import com.locnavi.location.xunjimap.utils.Constants;
import com.locnavi.location.xunjimap.utils.L;
import com.locnavi.location.xunjimap.utils.MixpanelEvent;
import com.locnavi.location.xunjimap.utils.T;
import com.tencent.bugly.test.crashreport.CrashReport;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Locale;


/**
 * author:chen
 * time:2017/4/24
 * desc:
 */
public class XJLocationSDK {
    protected static final Object monitor = new Object();
    public static Context context;
    private static Configuration configuration;
    public static App app;
    public static boolean showSignalStrengthTip = true;
    private static String packageNameBD;
    public static String appNameBD;
    public static String appIdBD;
    public static String secretKeyBD;
    public static String apiKeyBD;
    public static boolean hasShareListener;
    public static boolean debug;

    public static void init(Context context, String appKey) {
        init(new Configuration.Builder(context)
                .appKey(appKey)
                .build());
    }

    public static void init(Configuration c) {
        synchronized (monitor) {
            if (c.context == null) {
                throw new RuntimeException("context is null");
            }
            if (c.appKey == null) {
                throw new RuntimeException("appKey is null");
            }
            debug = c.debug;
            hasShareListener = c.hasShareListener;
            context = c.context;
            configuration = c;
            initBugly();
            initParseServer();
            initLogger();
            initMixPanel();
            if (c.isOpenBackGroundLocation){
                initServer();
            }

        }
    }

    private static void initServer() {
        DaemonEnv.initialize(context, TraceServiceImpl.class, DaemonEnv.DEFAULT_WAKE_UP_INTERVAL);
    }

    private static void initMixPanel() {
        MixpanelEvent.init();
    }

    private static void initLogger() {
        Logger.clearLogAdapters();
        FormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder()
                .showThreadInfo(false)
                .methodCount(0)
                .tag(BuildConfig.VERSION_CODE+"")
                .build();
        Logger.addLogAdapter(new AndroidLogAdapter(formatStrategy));
    }

    private static void initParseServer() {
        ParseObject.registerSubclass(Project.class);
        ParseObject.registerSubclass(Partner.class);
        ParseObject.registerSubclass(IpsUser.class);
        ParseObject.registerSubclass(NavigationPhoto.class);
        ParseObject.registerSubclass(POI.class);
        ParseObject.registerSubclass(POIGenre.class);
        ParseObject.registerSubclass(FeedBack.class);
        ParseObject.registerSubclass(Background.class);
        ParseObject.registerSubclass(LocationShare.class);
        ParseObject.registerSubclass(BaiduKey.class);
        ParseObject.registerSubclass(AndroidLSR.class);
        ParseObject.registerSubclass(BeaconMap.class);
        ParseObject.registerSubclass(App.class);
        ParseObject.registerSubclass(Punch.class);
        ParseObject.registerSubclass(District.class);
        ParseObject.registerSubclass(Synonym.class);
        Parse.initialize(new Parse.Configuration.Builder(context)
                .applicationId(Constants.PARSE_APPLICATION_ID)
                .server(Constants.PARSE_SERVER_URL)
                .build());
        ParseQuery.getQuery(App.class)
                .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                .getInBackground(configuration.appKey, (object, e) -> {
                    MixpanelEvent.initSDK();
                    if (e != null) {
                        if (e.getCode() == ParseException.OBJECT_NOT_FOUND) {
                            T.showShort(R.string.ips_location_wrong_app_key);
                        }
                        e.printStackTrace();
                        return;
                    }
//                    if (!object.getPackageName().equals(context.getPackageName()) || !object.getType().equals("Android")) {
//                        T.showShort(R.string.ips_location_wrong_app_key);
//                        return;
//                    }
                    app = object;
                });

        ParseQuery.getQuery(BaiduKey.class)
                .whereStartsWith(BaiduKey.PACKAGE_NAME, context.getPackageName())
                .setCachePolicy(ParseQuery.CachePolicy.CACHE_ELSE_NETWORK)
                .getFirstInBackground((object, e) -> {
                    if (e != null) {
                        e.printStackTrace();
                        return;
                    }
                    if (object == null) {
                        L.e(context.getPackageName(), "no voice permission");
                        return;
                    }
                    BaiduKey baiduKey1 = object;
                    packageNameBD = baiduKey1.getPackageName();
                    appNameBD = baiduKey1.getAppName();
                    appIdBD = baiduKey1.getAppId();
                    secretKeyBD = baiduKey1.getSecretKey();
                    apiKeyBD = baiduKey1.getApiKey();
                    L.d("baiduKey1---pageNameBD", packageNameBD);
                    L.d("baiduKey1---appNameBD", appNameBD);
                    L.d("baiduKey1---appIdBD", appIdBD);
                    L.d("baiduKey1---secretKeyBD", secretKeyBD);
                    L.d("baiduKey1---apiKeyBD", apiKeyBD);

                });
    }


    private static void initBugly() {
        CrashReport.setSdkExtraData(context, Constants.BUGLY_ID, context.getResources().getString(R.string.sdk_version_name));
        CrashReport.initCrashReport(context, Constants.BUGLY_ID, BuildConfig.DEBUG);
    }

    public static void getMapList(GetCallBack getCallBack) {
        if (app == null) {
            ParseQuery.getQuery(App.class)
                    .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                    .whereEqualTo("pkgName", context.getPackageName())
                    .whereEqualTo("type", "Android")
                    .getInBackground(configuration.appKey, (object, e) -> {
                        MixpanelEvent.initSDK();
                        if (e != null) {
                            if (e.getCode() == ParseException.OBJECT_NOT_FOUND) {
                                T.showShort(R.string.ips_location_wrong_app_key);
                            }
                            e.printStackTrace();
                            getCallBack.onError(e);
                            return;
                        }
                        if (!object.getPackageName().equals(context.getPackageName()) || !object.getType().equals("Android")) {
                            T.showShort(R.string.ips_location_wrong_app_key);
                            getCallBack.onError(new Exception(context.getString(R.string.ips_location_wrong_app_key)));
                            return;
                        }
                        app = object;
                        getProjects(getCallBack);
                    });
            return;
        }
        getProjects(getCallBack);
    }

    private static void getProjects(GetCallBack getCallBack) {
        ParseQuery<Project> query = app.getProjects().getQuery();
        query.whereEqualTo("visible", true);
        query.orderByAscending("order");
        query.include("district");
        query.setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK);
        if (!debug) {
            query.whereEqualTo("isDebug", false);
        }
        query.findInBackground((objects, e) -> {
            if (e != null) {
                e.printStackTrace();
                if (e.getCode() != ParseException.CACHE_MISS) {
                    getCallBack.onError(e);
                }
                return;
            }
            try {
                JSONArray jsonArray = new JSONArray();
                ArrayList<MapData> mapDatas = new ArrayList<>();
                for (Project project : objects) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("objectId", project.getObjectId());
                    jsonObject.put("name", project.getName());
                    jsonObject.put("picture", project.getPicture());
                    jsonObject.put("buildingId", project.getBuildingId());
                    jsonObject.put("token", project.getToken());
                    jsonObject.put("floorNumber", project.getFloorNumber());
                    jsonObject.put("floorName", project.getFloorName());
                    jsonObject.put("zoom", project.getZoom());
                    jsonObject.put("angle", project.getAngle());
                    jsonObject.put("powerThreshold", project.getPowerThreshold());
                    jsonObject.put("inToOut", project.getInToOut());
                    jsonObject.put("outToIn", project.getOutToIn());
                    jsonObject.put("gpsFloorlayer", project.getGpsFloorlayer());
                    jsonObject.put("navigationZoom", project.getNavigationZoom());
                    if (project.getCenterPoint() != null) {
                        jsonObject.put("lat", project.getCenterPoint().getLatitude());
                        jsonObject.put("lng", project.getCenterPoint().getLongitude());
                    }
                    if (project.getDistrict() != null) {
                        jsonObject.put("districtName", project.getDistrict().getString(District.NAME));
                    }
                    jsonArray.put(jsonObject);

                    MapData mapData = new MapData();
                    mapData.setObjectId(project.getObjectId());
                    mapData.setName(project.getName());
                    mapData.setPicture(project.getPicture());
                    mapData.setBuildingId(project.getBuildingId());
                    mapData.setToken(project.getToken());
                    mapData.setFloorNumber(project.getFloorNumber());
                    mapData.setFloorName(project.getFloorName());
                    mapData.setZoom(project.getZoom());
                    mapData.setAngle((float) project.getAngle());
                    mapData.setPowerThreshold(project.getPowerThreshold());
                    mapData.setInToOut(project.getInToOut());
                    mapData.setOutToIn(project.getOutToIn());
                    mapData.setGpsFloorlayer(project.getGpsFloorlayer());
                    mapData.setNavigationZoom(project.getNavigationZoom());
                    mapData.setTitle(project.getTitle());
                    if (project.getCenterPoint() != null) {
                        mapData.setLat(project.getCenterPoint().getLatitude());
                        mapData.setLng(project.getCenterPoint().getLongitude());
                    }
                    if (project.getDistrict() != null) {
                        mapData.setDistrictName(project.getDistrict().getString(District.NAME));
                    }
                    mapDatas.add(mapData);
                }
                DataHolder instance = DataHolder.getInstance();
                instance.setMapDataList(mapDatas);
                getCallBack.onSuccess(jsonArray.toString());
            } catch (JSONException e1) {
                e1.printStackTrace();
                getCallBack.onError(e1);
            }

        });
    }

    public static void openMap(Context context, String id, String userId, String poi){
        if(configuration == null || TextUtils.isEmpty(configuration.appKey)){
            Log.e("locanvi openMap", "appKey is null");
            return;
        }
        XJWebMapActivity.start(context, id, configuration.appKey, userId, poi);
    }

    public static class Configuration {
        private Context context;
        private String appKey;
        private boolean debug;
        private boolean hasShareListener;
        private boolean isOpenBackGroundLocation = false;
        public static final class Builder {
            private Context context;
            private String appKey;
            private boolean debug;
            private boolean hasShareListener;
            private boolean isOpenBackGroundLocation = false;

            public Builder appKey(String appKey) {
                this.appKey = appKey;
                return this;
            }

            public Builder debug(boolean debug) {
                this.debug = debug;
                L.setIsDebug(debug);
                return this;
            }

            public Builder hasShareListener(boolean hasShareListener) {
                this.hasShareListener = hasShareListener;
                return this;
            }
            public Builder openBackGroundLocationServerce(boolean isOpen){
                this.isOpenBackGroundLocation = isOpen;
                return this;
            }

            public Builder(Context context) {
                this.context = context;
            }

            public Configuration build() {
                return new Configuration(this);
            }
        }

        private Configuration(Builder builder) {
            this.context = builder.context;
            this.appKey = builder.appKey;
            this.debug = builder.debug;
            this.hasShareListener = builder.hasShareListener;
            this.isOpenBackGroundLocation = builder.isOpenBackGroundLocation;
        }
    }


}