/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.location.xunjimap.utils;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;

public class DensityUtils {
    public static final int DENSITY_LOW = 120;
    public static final int DENSITY_MEDIUM = 160;
    public static final int DENSITY_TV = 213;
    public static final int DENSITY_HIGH = 240;
    public static final int DENSITY_XHIGH = 320;
    public static final int DENSITY_400 = 400;
    public static final int DENSITY_XXHIGH = 480;
    public static final int DENSITY_XXXHIGH = 640;

    private DensityUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int dp2px(Context context, float f2) {
        context = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)context);
    }

    public static int sp2px(Context context, float f2) {
        context = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)context);
    }

    public static float px2dp(Context context, float f2) {
        return f2 / context.getResources().getDisplayMetrics().density;
    }

    public static float px2sp(Context context, float f2) {
        return f2 / context.getResources().getDisplayMetrics().scaledDensity;
    }

    public static int getViewMeasuredHeight(View view) {
        View view2 = view;
        DensityUtils.calcViewMeasure(view2);
        return view2.getMeasuredHeight();
    }

    public static int getViewMeasuredWidth(View view) {
        View view2 = view;
        DensityUtils.calcViewMeasure(view2);
        return view2.getMeasuredWidth();
    }

    public static void calcViewMeasure(View view) {
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE));
    }

    public static int getScreenWidth(Context context) {
        return ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getWidth();
    }

    public static int getScreenHeight(Context context) {
        return ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getHeight();
    }

    public static int getStatusBarHeight(Context context) {
        Context context2 = context;
        int n2 = context2.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context2.getResources().getDimensionPixelSize(n2);
    }

    public static int getNavigationBarHeight(Context context) {
        Context context2 = context;
        int n2 = context2.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        return context2.getResources().getDimensionPixelSize(n2);
    }

    public static boolean checkDeviceHasNavigationBar(Context context) {
        boolean bl;
        block9: {
            Object object;
            block8: {
                bl = false;
                object = context.getResources();
                int n2 = object.getIdentifier("config_showNavigationBar", "bool", "android");
                if (n2 > 0) {
                    bl = object.getBoolean(n2);
                }
                try {
                    object = Class.forName("android.os.SystemProperties");
                }
                catch (Exception exception) {}
                Class[] classArray = new Class[1];
                classArray[0] = String.class;
                object = (String)object.getMethod("get", classArray).invoke(object, "qemu.hw.mainkeys");
                if (!"1".equals(object)) break block8;
                bl = false;
                break block9;
            }
            if ("0".equals(object)) {
                bl = true;
            }
        }
        return bl;
    }

    public static int getDensity(Context context) {
        return context.getResources().getDisplayMetrics().densityDpi;
    }
}

