/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.location.xunjimap.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.Call;
import okhttp3.Response;

public abstract class CallBackUtil<T> {
    public static Handler mMainHandler = new Handler(Looper.getMainLooper());

    public void onProgress(float f2, long l2) {
    }

    public void onError(final Call call, final Exception exception) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                CallBackUtil.this.onFailure(call, exception);
            }
        });
    }

    public void onSeccess(final Call object, Response response) {
        object = this.onParseResponse((Call)object, response);
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                CallBackUtil.this.onResponse(object);
            }
        });
    }

    public abstract T onParseResponse(Call var1, Response var2);

    public abstract void onFailure(Call var1, Exception var2);

    public abstract void onResponse(T var1);

    public static abstract class CallBackFile
    extends CallBackUtil<File> {
        private final String mDestFileDir;
        private final String mdestFileName;

        public CallBackFile(String string2, String string3) {
            this.mDestFileDir = string2;
            this.mdestFileName = string3;
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        @Override
        public File onParseResponse(Call object, Response response) {
            void var0_3;
            Object object2;
            block38: {
                block36: {
                    block37: {
                        Exception exception2;
                        block35: {
                            File file3;
                            FileOutputStream fileOutputStream2;
                            block39: {
                                FileOutputStream fileOutputStream2;
                                File file2;
                                long l2;
                                long l3;
                                byte[] byArray;
                                block34: {
                                    File file3;
                                    Response response2 = response;
                                    object = null;
                                    byArray = new byte[8192];
                                    fileOutputStream2 = null;
                                    object = response2.body().byteStream();
                                    l3 = response2.body().contentLength();
                                    l2 = 0L;
                                    object2 = file3;
                                    if (new File(this.mDestFileDir).exists()) break block34;
                                    ((File)object2).mkdirs();
                                }
                                file3 = file2;
                                file2 = new File((File)object2, this.mdestFileName);
                                object2 = fileOutputStream2;
                                fileOutputStream2 = new FileOutputStream(file3);
                                while (true) {
                                    int n2 = ((InputStream)object).read(byArray);
                                    if (n2 == -1) break;
                                    l2 += (long)n2;
                                    ((FileOutputStream)object2).write(byArray, 0, n2);
                                    mMainHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            long l22 = l3;
                                            this.onProgress((float)l2 * 100.0f / (float)l22, l22);
                                        }
                                    });
                                }
                                Object object3 = object;
                                Response response3 = response;
                                ((OutputStream)object2).flush();
                                try {
                                    response3.body().close();
                                }
                                catch (IOException iOException) {}
                                if (object3 == null) break block39;
                                ((InputStream)object).close();
                            }
                            try {
                                ((FileOutputStream)object2).close();
                            }
                            catch (IOException iOException) {}
                            return file3;
                            catch (Exception exception2) {
                                break block35;
                            }
                            catch (Throwable throwable) {
                                object2 = fileOutputStream2;
                                break block36;
                            }
                            catch (Exception exception2) {
                                object2 = fileOutputStream2;
                            }
                        }
                        exception2.printStackTrace();
                        try {
                            response.body().close();
                            if (object == null) break block37;
                        }
                        catch (IOException iOException) {}
                        ((InputStream)object).close();
                    }
                    if (object2 != null) {
                        try {
                            ((FileOutputStream)object2).close();
                        }
                        catch (IOException iOException) {}
                    }
                    return null;
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    response.body().close();
                    if (object == null) break block38;
                }
                catch (IOException iOException) {}
                ((InputStream)object).close();
            }
            if (object2 != null) {
                try {
                    ((FileOutputStream)object2).close();
                }
                catch (IOException iOException) {}
            }
            throw var0_3;
        }
    }

    public static abstract class CallBackBitmap
    extends CallBackUtil<Bitmap> {
        private int mTargetWidth;
        private int mTargetHeight;

        public CallBackBitmap() {
        }

        public CallBackBitmap(int n2, int n3) {
            this.mTargetWidth = n2;
            this.mTargetHeight = n3;
        }

        public CallBackBitmap(ImageView imageView) {
            int n2 = imageView.getWidth();
            int n3 = imageView.getHeight();
            if (n2 > 0 && n3 > 0) {
                this.mTargetWidth = n2;
                this.mTargetHeight = n3;
                return;
            }
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6ImageView\u7684width\u6216height");
        }

        private Bitmap getZoomBitmap(Response object) {
            BitmapFactory.Options options;
            Response response = object;
            object = null;
            try {
                object = response.body().bytes();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            BitmapFactory.Options options2 = options;
            Object object2 = object;
            options2();
            options2.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])object2, (int)0, (int)((Response)object2).length, (BitmapFactory.Options)options2);
            int n2 = options.outWidth;
            int n3 = options.outHeight;
            int n4 = n2;
            n2 = 1;
            int n5 = (int)Math.floor((float)n4 / (float)this.mTargetWidth);
            int n6 = (int)Math.floor((float)n3 / (float)this.mTargetHeight);
            if (n5 > 1 || n6 > 1) {
                n2 = Math.max(n5, n6);
            }
            Object object3 = object;
            BitmapFactory.Options options3 = options2;
            options3.inSampleSize = n2;
            options3.inJustDecodeBounds = false;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])object3, (int)0, (int)((Response)object3).length, (BitmapFactory.Options)options2);
            if (bitmap != null) {
                return bitmap;
            }
            throw new RuntimeException("Failed to decode stream.");
        }

        @Override
        public Bitmap onParseResponse(Call call, Response response) {
            if (this.mTargetWidth != 0 && this.mTargetHeight != 0) {
                return this.getZoomBitmap(response);
            }
            return BitmapFactory.decodeStream((InputStream)response.body().byteStream());
        }
    }

    public static abstract class CallBackString
    extends CallBackUtil<String> {
        @Override
        public String onParseResponse(Call call, Response response) {
            try {
                return response.body().string();
            }
            catch (IOException iOException) {
                new RuntimeException("failure");
                return "";
            }
        }
    }

    public static abstract class CallBackDefault
    extends CallBackUtil<Response> {
        @Override
        public Response onParseResponse(Call call, Response response) {
            return response;
        }
    }
}

