/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;

public class OrientationMarker
implements OverlayItem {
    private float a;
    public GeoPoint geoPoint;
    private Bitmap b = null;
    private final Paint c;
    private Rect d = new Rect();

    public OrientationMarker(GeoPoint geoPoint, Bitmap bitmap) {
        this.geoPoint = geoPoint;
        this.b = bitmap;
        this.c = new Paint(1);
        this.c.setFilterBitmap(true);
    }

    public void setTransparency(int n2) {
        this.c.setAlpha(n2);
    }

    public void setBitmap(Bitmap bitmap) {
        this.b = bitmap;
    }

    @Override
    public boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.b == null) {
            return true;
        }
        OrientationMarker orientationMarker = this;
        int n4 = (int)(MercatorProjection.longitudeToPixelX(orientationMarker.geoPoint.longitude, f2) - point.x);
        float f4 = ScreenDensity.density;
        double d2 = (float)(n4 - n2) * f4;
        double d3 = (float)((int)(MercatorProjection.latitudeToPixelY(orientationMarker.geoPoint.latitude, f2) - point.y) - n3) * f4;
        double d4 = d3;
        double d5 = (double)(-f3) / 180.0 * Math.PI;
        d4 = d2 * Math.cos(d5) + d4 * Math.sin(d5);
        d2 = d3 * Math.cos(d5) - d2 * Math.sin(d5);
        d5 = (double)n3 + d2;
        n3 = (int)((double)n2 + d4);
        int n5 = (int)d5;
        int n6 = (int)d4;
        this.d.left = n6 - this.b.getWidth() / 2;
        int n7 = (int)d2;
        this.d.top = n7 - this.b.getHeight() / 2;
        this.d.right = n6 + this.b.getWidth() / 2;
        this.d.bottom = n7 + this.b.getHeight() / 2;
        if (n3 + this.b.getWidth() > 0 && n3 - this.b.getWidth() / 2 < canvas.getWidth() && n5 + this.b.getHeight() > 0 && n5 - this.b.getHeight() / 2 < canvas.getHeight()) {
            Matrix matrix;
            Matrix matrix2 = matrix;
            matrix2();
            matrix2.setRotate(this.a + f3, (float)(this.b.getWidth() / 2), (float)(this.b.getHeight() / 2));
            matrix.postTranslate((float)(n3 - this.b.getWidth() / 2), (float)(n5 - this.b.getHeight() / 2));
            canvas.drawBitmap(this.b, matrix2, this.c);
        }
        return true;
    }

    public boolean isInMarker(int n2, int n3) {
        OrientationMarker orientationMarker = orientationMarker.d;
        return n2 > ((Rect)orientationMarker).left && n2 < ((Rect)orientationMarker).right && n3 > ((Rect)orientationMarker).top && n3 < ((Rect)orientationMarker).bottom;
    }

    public void setRotation(float f2) {
        this.a = f2;
    }

    public float getRotation() {
        return this.a;
    }

    public synchronized void setGeoPoint(GeoPoint geoPoint) {
        this.geoPoint = geoPoint;
    }

    public synchronized GeoPoint getGeoPoint() {
        return this.geoPoint;
    }
}

