/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.support.annotation.NonNull;
import com.sails.engine.Beacon;
import com.sails.engine.SAILS;
import com.sails.engine.c;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.f;
import com.sails.engine.g;
import com.sails.engine.n;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class LocationRegion {
    public static final int NORMAL = 0;
    public static final int ENGLISH = 1;
    public static final int CHINESE_BIG5 = 2;
    public static final int CHINESE_SM = 3;
    public static final int JAPANESE = 4;
    public static int FONT_LANGUAGE = 2;
    public long id;
    public List<SAILS.GeoNode> mBoundaryVertexList = new ArrayList<SAILS.GeoNode>();
    public String label;
    n a;
    public Beacon beacon = null;
    public int level;
    public int order;
    public int stack;
    public String chinese_t = null;
    public String chinese_s = null;
    public String english = null;
    public String japanese = null;
    public String type = null;
    public String subtype = null;
    public String url = null;
    public String uuid = null;
    public String renderName = null;
    public String show_3d_height = null;
    public boolean navi = false;
    public boolean show_label = false;
    public boolean show_region = false;
    public boolean reverse_enable = false;
    public String icon_sails = null;
    public String title = null;
    public String panorama = null;
    public double angle = 0.0;
    public int self = Integer.MAX_VALUE;
    public List<Integer> goToList = new ArrayList<Integer>();
    public double fusionCoefficient = 0.0;
    boolean b = false;
    boolean c = false;
    double d;
    double e;
    public double updatedLength = -1.0;
    public int changeFloorCount = 0;
    boolean f = false;
    g.a g = null;
    List<f.a> h = null;

    public LocationRegion() {
    }

    public LocationRegion(String string2, double d2, double d3, String string3, @NonNull SAILS sAILS) {
        this.a(sAILS, string3);
        this.e = d3;
        this.d = d2;
        this.label = string2;
        this.a(sAILS);
    }

    private double a(a[] aArray) {
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < aArray.length - 1) {
            double d3;
            int n3 = n2 + 1;
            d2 = d3 = d2 + aArray[n2].a * aArray[n3].b - aArray[n2].b * aArray[n3].a;
            n2 = n3;
        }
        return d2 * 0.5;
    }

    private a b(a[] aArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < aArray.length - 1) {
            double d5;
            int n3 = n2 + 1;
            double d6 = -(aArray[n2].b * aArray[n3].a - aArray[n2].a * aArray[n3].b);
            d2 += (aArray[n2].a + aArray[n3].a) * d6;
            d3 += (aArray[n2].b + aArray[n3].b) * d6;
            d4 = d5 = d4 + d6;
            n2 = n3;
        }
        double d7 = d3;
        d3 = d4 * 3.0;
        d2 /= d3;
        d3 = d7 / d3;
        return new a(d2, d3);
    }

    void a(SAILS object) {
        n n2;
        if (!this.hasPathNode() && !this.f && (n2 = this.a) != null && object != null && (object = ((SAILS)object).j.C) != null && ((c)object).p != null) {
            this.g = ((c)object).a(this.d, this.e, n2.b);
            object = this.g;
            if (object != null && (object = ((g.a)object).f) != null) {
                LocationRegion locationRegion = this;
                locationRegion.g = object;
                locationRegion.f = true;
            }
            return;
        }
    }

    void a(SAILS object, String string2) {
        for (n n2 : ((SAILS)object).j.C.f) {
            if (!n2.a.equals(string2)) continue;
            this.a = n2;
        }
    }

    public String getFloorName() {
        n n2 = ((LocationRegion)((Object)n2)).a;
        if (n2 != null) {
            return n2.a;
        }
        return null;
    }

    public String getFloorDescription() {
        return this.a.c;
    }

    public int getFloorNumber() {
        n n2 = ((LocationRegion)((Object)n2)).a;
        if (n2 != null) {
            return n2.b;
        }
        return 0;
    }

    public String getName() {
        switch (FONT_LANGUAGE) {
            default: {
                return ((LocationRegion)((Object)string2)).label;
            }
            case 4: {
                return ((LocationRegion)((Object)string2)).japanese;
            }
            case 3: {
                return ((LocationRegion)((Object)string2)).chinese_s;
            }
            case 2: {
                return ((LocationRegion)((Object)string2)).chinese_t;
            }
            case 1: {
                return ((LocationRegion)((Object)string2)).english;
            }
            case 0: 
        }
        String string2 = ((LocationRegion)((Object)string2)).label;
        return string2 == null ? null : string2.replace(" - ", "");
    }

    public boolean isInRegion(double d2, double d3) {
        if (d2 != Double.NaN && d3 != Double.NaN) {
            if (this.mBoundaryVertexList.size() < 3) {
                return false;
            }
            boolean bl = false;
            int n2 = 0;
            int n3 = this.mBoundaryVertexList.size() - 1;
            int n4 = n2;
            n2 = n3;
            n3 = n4;
            while (n3 < this.mBoundaryVertexList.size()) {
                boolean bl2;
                boolean bl3 = this.mBoundaryVertexList.get((int)n3).latitude > d3;
                if (bl3 != (bl2 = this.mBoundaryVertexList.get((int)n2).latitude > d3) && d2 < (this.mBoundaryVertexList.get((int)n2).longitude - this.mBoundaryVertexList.get((int)n3).longitude) * (d3 - this.mBoundaryVertexList.get((int)n3).latitude) / (this.mBoundaryVertexList.get((int)n2).latitude - this.mBoundaryVertexList.get((int)n3).latitude) + this.mBoundaryVertexList.get((int)n3).longitude) {
                    bl ^= true;
                }
                int n5 = n2 = n3 + 1;
                n2 = n3;
                n3 = n5;
            }
            return bl;
        }
        return false;
    }

    public boolean hasPathNode() {
        List<f.a> list = ((LocationRegion)((Object)list)).h;
        return list != null && list.size() != 0;
        {
        }
    }

    public double getCenterLongitude() {
        return this.d;
    }

    public double getCenterLatitude() {
        return this.e;
    }

    public void setVertexList(List<SAILS.GeoNode> object) {
        if (object.size() == 1) {
            this.e = object.get((int)0).latitude;
            this.d = object.get((int)0).longitude;
            return;
        }
        this.mBoundaryVertexList = object;
        List<SAILS.GeoNode> list = this.mBoundaryVertexList;
        a[] aArray = new a[list.size() + 1];
        int n2 = 0;
        a a2 = null;
        for (SAILS.GeoNode geoNode : list) {
            a a3;
            double d2 = MercatorProjection.longitudeToPixelX(geoNode.longitude, 22.0f);
            double d3 = MercatorProjection.latitudeToPixelY(geoNode.latitude, 22.0f);
            double[] dArray = new double[2];
            double[] dArray2 = dArray;
            dArray[0] = d2;
            dArray[1] = d3;
            if (n2 == 0) {
                a a4;
                a2 = a4;
                a4 = new a(d2, d3);
            }
            a a5 = a3;
            a3 = new a(dArray2[0] - a2.a, dArray2[1] - a2.b);
            if (n2 == 0) {
                aArray[object.size()] = a5;
            }
            aArray[n2] = a5;
            ++n2;
        }
        object = this.b(aArray);
        if (object != null) {
            this.e = MercatorProjection.pixelYToLatitude(((a)object).b + a2.b, 22.0f);
            this.d = MercatorProjection.pixelXToLongitude(((a)object).a + a2.a, 22.0f);
        }
    }

    public double getArea() {
        LocationRegion locationRegion = this;
        a[] aArray = new a[locationRegion.mBoundaryVertexList.size() + 1];
        int n2 = 0;
        a a2 = null;
        for (SAILS.GeoNode geoNode : locationRegion.mBoundaryVertexList) {
            a a3;
            double d2 = MercatorProjection.longitudeToPixelX(geoNode.longitude, 22.0f);
            double d3 = MercatorProjection.latitudeToPixelY(geoNode.latitude, 22.0f);
            double[] dArray = new double[2];
            double[] dArray2 = dArray;
            dArray[0] = d2;
            dArray[1] = d3;
            if (n2 == 0) {
                a a4;
                a2 = a4;
                a4 = new a(d2, d3);
            }
            a a5 = a3;
            a3 = new a(dArray2[0] - a2.a, dArray2[1] - a2.b);
            if (n2 == 0) {
                aArray[this.mBoundaryVertexList.size()] = a5;
            }
            aArray[n2] = a5;
            ++n2;
        }
        return Math.abs(this.a(aArray));
    }

    public static class RegionByStackComparator
    implements Comparator<LocationRegion> {
        @Override
        public int compare(LocationRegion locationRegion, LocationRegion locationRegion2) {
            return locationRegion2.stack - locationRegion.stack;
        }
    }

    public static class RegionByAreaComparator
    implements Comparator<LocationRegion> {
        @Override
        public int compare(LocationRegion locationRegion, LocationRegion locationRegion2) {
            return new Double(locationRegion.getArea()).compareTo(new Double(locationRegion2.getArea()));
        }
    }

    public static class RegionByLevelComparator
    implements Comparator<LocationRegion> {
        @Override
        public int compare(LocationRegion locationRegion, LocationRegion locationRegion2) {
            int n2 = locationRegion.level;
            int n3 = locationRegion2.level;
            if (n2 < n3) {
                return 1;
            }
            if (n2 == n3) {
                return 0;
            }
            return -1;
        }
    }

    class a {
        final double a;
        final double b;

        a(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }
    }

    static class b {
        final double a;
        final double b;

        b(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }
    }
}

