/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.location.xunjimap.utils;

import android.text.TextUtils;
import com.locnavi.location.xunjimap.utils.CallBackUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class RequestUtil {
    private String mMetyodType;
    private String mUrl;
    private Map<String, String> mParamsMap;
    private String mJsonStr;
    private File mFile;
    private List<File> mfileList;
    private String mfileKey;
    private Map<String, File> mfileMap;
    private String mFileType;
    private Map<String, String> mHeaderMap;
    private CallBackUtil mCallBack;
    private OkHttpClient mOkHttpClient;
    private Request mOkHttpRequest;
    private Request.Builder mRequestBuilder;

    RequestUtil(String string2, String string3, Map<String, String> map, Map<String, String> map2, CallBackUtil callBackUtil) {
        this(string2, string3, null, null, null, null, null, null, map, map2, callBackUtil);
    }

    RequestUtil(String string2, String string3, String string4, Map<String, String> map, CallBackUtil callBackUtil) {
        this(string2, string3, string4, null, null, null, null, null, null, map, callBackUtil);
    }

    RequestUtil(String string2, String string3, Map<String, String> map, File file, String string4, String string5, Map<String, String> map2, CallBackUtil callBackUtil) {
        this(string2, string3, null, file, null, string4, null, string5, map, map2, callBackUtil);
    }

    RequestUtil(String string2, String string3, Map<String, String> map, List<File> list, String string4, String string5, Map<String, String> map2, CallBackUtil callBackUtil) {
        this(string2, string3, null, null, list, string4, null, string5, map, map2, callBackUtil);
    }

    RequestUtil(String string2, String string3, Map<String, String> map, Map<String, File> map2, String string4, Map<String, String> map3, CallBackUtil callBackUtil) {
        this(string2, string3, null, null, null, null, map2, string4, map, map3, callBackUtil);
    }

    private RequestUtil(String string2, String string3, String string4, File file, List<File> list, String string5, Map<String, File> map, String string6, Map<String, String> map2, Map<String, String> map3, CallBackUtil callBackUtil) {
        this.mMetyodType = string2;
        this.mUrl = string3;
        this.mJsonStr = string4;
        this.mFile = file;
        this.mfileList = list;
        this.mfileKey = string5;
        this.mfileMap = map;
        this.mFileType = string6;
        this.mParamsMap = map2;
        this.mHeaderMap = map3;
        this.mCallBack = callBackUtil;
        this.getInstance();
    }

    private void getInstance() {
        this.mOkHttpClient = new OkHttpClient();
        this.mRequestBuilder = new Request.Builder();
        if (this.mFile == null && this.mfileList == null && this.mfileMap == null) {
            String string2 = this.mMetyodType;
            int n2 = -1;
            int n3 = string2.hashCode();
            if (n3 != 70454) {
                if (n3 != 79599) {
                    if (n3 != 2461856) {
                        if (n3 == 2012838315 && string2.equals("DELETE")) {
                            n2 = 3;
                        }
                    } else if (string2.equals("POST")) {
                        n2 = 1;
                    }
                } else if (string2.equals("PUT")) {
                    n2 = 2;
                }
            } else if (string2.equals("GET")) {
                n2 = 0;
            }
            switch (n2) {
                default: {
                    break;
                }
                case 3: {
                    this.mRequestBuilder.delete(this.getRequestBody());
                    break;
                }
                case 2: {
                    this.mRequestBuilder.put(this.getRequestBody());
                    break;
                }
                case 1: {
                    this.mRequestBuilder.post(this.getRequestBody());
                    break;
                }
                case 0: {
                    this.setGetParams();
                    break;
                }
            }
        } else {
            this.setFile();
        }
        RequestUtil requestUtil = this;
        requestUtil.mRequestBuilder.url(this.mUrl);
        if (requestUtil.mHeaderMap != null) {
            this.setHeader();
        }
        this.mOkHttpRequest = this.mRequestBuilder.build();
    }

    private RequestBody getRequestBody() {
        FormBody.Builder builder;
        if (!TextUtils.isEmpty((CharSequence)this.mJsonStr)) {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.mJsonStr);
        }
        FormBody.Builder builder2 = builder;
        builder = new FormBody.Builder();
        Map<String, String> map = this.mParamsMap;
        if (map != null) {
            for (String string2 : map.keySet()) {
                builder2.add(string2, this.mParamsMap.get(string2));
            }
        }
        return builder2.build();
    }

    private void setGetParams() {
        if (this.mParamsMap != null) {
            this.mUrl = this.mUrl + "?";
            for (String string2 : this.mParamsMap.keySet()) {
                this.mUrl = this.mUrl + string2 + "=" + this.mParamsMap.get(string2) + "&";
            }
            String string3 = this.mUrl;
            this.mUrl = string3.substring(0, string3.length() - 1);
        }
    }

    private void setFile() {
        if (this.mFile != null) {
            if (this.mParamsMap == null) {
                this.setPostFile();
            } else {
                this.setPostParameAndFile();
            }
        } else if (this.mfileList != null) {
            this.setPostParameAndListFile();
        } else if (this.mfileMap != null) {
            this.setPostParameAndMapFile();
        }
    }

    private void setPostFile() {
        File file = this.mFile;
        if (file != null && file.exists()) {
            RequestUtil requestUtil = this;
            file = RequestBody.create((MediaType)MediaType.parse((String)requestUtil.mFileType), (File)this.mFile);
            requestUtil.mRequestBuilder.post((RequestBody)new ProgressRequestBody((RequestBody)file, this.mCallBack));
        }
    }

    private void setPostParameAndFile() {
        if (this.mParamsMap != null && this.mFile != null) {
            MultipartBody.Builder builder;
            MultipartBody.Builder builder2 = builder;
            new MultipartBody.Builder().setType(MultipartBody.FORM);
            for (String string2 : this.mParamsMap.keySet()) {
                builder2.addFormDataPart(string2, this.mParamsMap.get(string2));
            }
            builder2.addFormDataPart(this.mfileKey, this.mFile.getName(), RequestBody.create((MediaType)MediaType.parse((String)this.mFileType), (File)this.mFile));
            this.mRequestBuilder.post((RequestBody)new ProgressRequestBody((RequestBody)builder2.build(), this.mCallBack));
        }
    }

    private void setPostParameAndListFile() {
        if (this.mfileList != null) {
            MultipartBody.Builder builder;
            MultipartBody.Builder builder2 = builder;
            new MultipartBody.Builder().setType(MultipartBody.FORM);
            Iterator<File> iterator = this.mParamsMap;
            if (iterator != null) {
                for (String string2 : iterator.keySet()) {
                    builder2.addFormDataPart(string2, this.mParamsMap.get(string2));
                }
            }
            for (File file : this.mfileList) {
                builder2.addFormDataPart(this.mfileKey, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)this.mFileType), (File)file));
            }
            this.mRequestBuilder.post((RequestBody)builder2.build());
        }
    }

    private void setPostParameAndMapFile() {
        if (this.mfileMap != null) {
            MultipartBody.Builder builder;
            MultipartBody.Builder builder2 = builder;
            new MultipartBody.Builder().setType(MultipartBody.FORM);
            Iterator<String> iterator = this.mParamsMap;
            if (iterator != null) {
                for (String string2 : iterator.keySet()) {
                    builder2.addFormDataPart(string2, this.mParamsMap.get(string2));
                }
            }
            for (String string3 : this.mfileMap.keySet()) {
                builder2.addFormDataPart(string3, this.mfileMap.get(string3).getName(), RequestBody.create((MediaType)MediaType.parse((String)this.mFileType), (File)this.mfileMap.get(string3)));
            }
            this.mRequestBuilder.post((RequestBody)builder2.build());
        }
    }

    private void setHeader() {
        Map<String, String> map = this.mHeaderMap;
        if (map != null) {
            for (String string2 : map.keySet()) {
                this.mRequestBuilder.addHeader(string2, this.mHeaderMap.get(string2));
            }
        }
    }

    void execute() {
        this.mOkHttpClient.newCall(this.mOkHttpRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException iOException) {
                if (RequestUtil.this.mCallBack != null) {
                    RequestUtil.this.mCallBack.onError(call, iOException);
                }
            }

            public void onResponse(Call call, Response response) {
                if (RequestUtil.this.mCallBack != null) {
                    RequestUtil.this.mCallBack.onSeccess(call, response);
                }
            }
        });
    }

    private static class ProgressRequestBody
    extends RequestBody {
        private final RequestBody requestBody;
        private BufferedSink bufferedSink;
        private CallBackUtil callBack;

        ProgressRequestBody(RequestBody requestBody, CallBackUtil callBackUtil) {
            this.requestBody = requestBody;
            this.callBack = callBackUtil;
        }

        private Sink sink(BufferedSink bufferedSink) {
            return new ForwardingSink((Sink)bufferedSink){
                long bytesWritten;
                long contentLength;
                {
                    super(sink);
                    this.bytesWritten = 0L;
                    this.contentLength = 0L;
                }

                public void write(Buffer buffer, long l2) {
                    1 v0 = this;
                    super.write(buffer, l2);
                    if (v0.contentLength == 0L) {
                        this.contentLength = this.contentLength();
                    }
                    1 v1 = this;
                    v1.bytesWritten += l2;
                    final float f2 = (float)v1.bytesWritten * 1.0f / (float)this.contentLength;
                    CallBackUtil.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callBack.onProgress(f2, contentLength);
                        }
                    });
                }
            };
        }

        public MediaType contentType() {
            return this.requestBody.contentType();
        }

        public long contentLength() {
            return this.requestBody.contentLength();
        }

        public void writeTo(BufferedSink bufferedSink) {
            if (this.bufferedSink == null) {
                this.bufferedSink = Okio.buffer((Sink)this.sink(bufferedSink));
            }
            ProgressRequestBody progressRequestBody = this;
            progressRequestBody.requestBody.writeTo(this.bufferedSink);
            progressRequestBody.bufferedSink.flush();
        }
    }
}

