/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.location.xunjimap.utils;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.text.TextUtils;
import com.locnavi.location.R;
import com.locnavi.location.xunjimap.XJLocationSDK;
import com.locnavi.location.xunjimap.model.bean.BackgroundData;
import com.locnavi.location.xunjimap.model.parse.Project;
import com.locnavi.location.xunjimap.utils.Constants;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class MixpanelEvent {
    private static LinkedHashMap<String, Object> params;

    public static void init() {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("App Name", Constants.getAppName(XJLocationSDK.context));
        params.put("SDK Version Code", XJLocationSDK.context.getString(R.string.ips_location_sdk_version_code));
        params.put("SDK Version Name", XJLocationSDK.context.getString(R.string.ips_location_sdk_version_name));
        if (BluetoothAdapter.getDefaultAdapter() != null) {
            params.put("Bluetooth Open", BluetoothAdapter.getDefaultAdapter().isEnabled());
        } else {
            params.put("Bluetooth Open", false);
        }
        params.put("Integration Share Module", XJLocationSDK.hasShareListener);
        mixpanelAPI.registerSuperPropertiesMap(params);
    }

    public static void setProject(Project project) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        if (project != null) {
            params.put("Building Id", project.getBuildingId());
            params.put("Building Name", project.getName());
        }
        mixpanelAPI.registerSuperPropertiesMap(params);
    }

    public static void isInThisMap(boolean bl) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("In This Map", bl);
        mixpanelAPI.registerSuperPropertiesMap(params);
    }

    public static MixpanelAPI Mixpanel() {
        return MixpanelAPI.getInstance((Context)XJLocationSDK.context, (String)"e7f959fb19dcd567c2d3236829576efe");
    }

    public static void initSDK() {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        mixpanelAPI.track("SDK Init");
        mixpanelAPI.flush();
    }

    public static void enterSDKMode(String string2, String string3, String string4) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Mode", string2);
        params.put("Target Location", string3);
        params.put("Target LocationId", string4);
        mixpanelAPI.trackMap("Enter SDK Mode", params);
    }

    public static void updateFeedBack(int n2, ArrayList<String> arrayList, String string2, boolean bl, String string3, String string4, int n3, String string5, boolean bl2) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Star", n2);
        params.put("Comments", arrayList);
        params.put("Content", string2);
        if (bl) {
            params.put("Navigation Mode", "Simulation");
        } else {
            params.put("Navigation Mode", "Real");
        }
        params.put("Start Location", string3);
        params.put("Target Location", string4);
        params.put("Distance", n3);
        params.put("Time", string5);
        if (bl2) {
            params.put("Click Button", "Exit Button");
        } else {
            params.put("Click Button", "Submit Button");
        }
        mixpanelAPI.trackMap("Feedback", params);
    }

    public static void timeKeepSDK() {
        MixpanelEvent.Mixpanel().timeEvent("Timing Keep SDK");
    }

    public static void timeKeepSDKTrack() {
        MixpanelEvent.Mixpanel().track("Timing Keep SDK");
    }

    public static void timeLocationFix() {
        MixpanelEvent.Mixpanel().timeEvent("Timing Location Fix");
    }

    public static void timeLocationFixTrack() {
        MixpanelEvent.Mixpanel().track("Timing Location Fix");
    }

    public static void timeLoadMap() {
        MixpanelEvent.Mixpanel().timeEvent("Timing Load Map");
    }

    public static void timeLoadMapTrack(boolean bl) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        if (bl) {
            params.put("Result", "Success");
        } else {
            params.put("Result", "Fail");
        }
        mixpanelAPI.trackMap("Timing Load Map", params);
    }

    public static void clickRegion(String string2, String string3) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Region Name", string2);
        params.put("Page Status", string3);
        mixpanelAPI.trackMap("Region OnClick", params);
    }

    public static void navigation(boolean bl, String string2, String string3, int n2, String string4, double d2, String string5) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        if (bl) {
            params.put("Navigation Mode", "Simulation");
        } else {
            params.put("Navigation Mode", "Real");
        }
        params.put("Start Location", string2);
        params.put("Target Location", string3);
        params.put("Distance", n2);
        params.put("Time", string4);
        params.put("Navigation Percent", d2);
        params.put("Target Location From", string5);
        mixpanelAPI.trackMap("Navigation", params);
    }

    public static void backGroudUploadData(BackgroundData backgroundData) {
        Object object = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        ArrayList arrayList = backgroundData.getLocationRegions();
        String string2 = "{";
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            string2 = string2 + "'" + (String)arrayList.get(i2) + "'";
        }
        MixpanelAPI mixpanelAPI = object;
        object = string2 + "}";
        params.put("LocationRegions", object);
        params.put("LocationRegion", backgroundData.getLocationRegion());
        params.put("DeviceId", backgroundData.getDeviceId());
        params.put("PhoneNumber", backgroundData.getPhoneNumber());
        params.put("FloorName", backgroundData.getFloorName());
        params.put("DurationTime", backgroundData.getDurationTime());
        mixpanelAPI.trackMap("Background Upload Data", params);
    }

    public static void search(String string2, int n2, String string3) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Content", string2);
        params.put("Result Size", n2);
        params.put("Search From", string3);
        mixpanelAPI.trackMap("Search", params);
    }

    public static void locShareClick() {
        MixpanelEvent.Mixpanel().track("Location Share OnClick");
    }

    public static void locShareCreate(String string2, String string3) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Result", string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            params.put("Fail Page", string3);
        }
        mixpanelAPI.trackMap("Location Share Create", params);
    }

    public static void locShare(String string2, String string3) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Click", string2);
        params.put("Type", string3);
        mixpanelAPI.trackMap("Location Share", params);
    }

    public static void locShareJoin(String string2, String string3) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Join From", string2);
        params.put("Type", string3);
        mixpanelAPI.trackMap("Location Share Join", params);
    }

    public static void locShareJoinDialog(String string2) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Click", string2);
        mixpanelAPI.trackMap("Location Share Join Dialog", params);
    }

    public static void locShareMyLocation() {
        MixpanelEvent.Mixpanel().track("Location Share My Location");
    }

    public static void locShareLocRegion(String string2) {
        MixpanelAPI mixpanelAPI = MixpanelEvent.Mixpanel();
        params = new LinkedHashMap();
        params.put("Name", string2);
        mixpanelAPI.trackMap("Location Share Location Region", params);
    }
}

