/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.core.util;

public final class MercatorProjection {
    public static final double EARTH_CIRCUMFERENCE = 4.0075016686E7;
    public static final double LATITUDE_MAX = 85.05112877980659;
    public static final double LATITUDE_MIN = -85.05112877980659;

    public static double calculateGroundResolution(double d2, float f2) {
        long l2 = MercatorProjection.getMapSize(f2);
        return Math.cos(d2 * (Math.PI / 180)) * 4.0075016686E7 / (double)l2;
    }

    public static double deltaLat(double d2, double d3, float f2) {
        return Math.abs(MercatorProjection.pixelYToLatitude(MercatorProjection.latitudeToPixelY(d3, f2) + d2, f2) - d3);
    }

    public static long getMapSize(float f2) {
        if (!(f2 < 0.0f)) {
            double d2 = f2;
            return (long)(Math.pow(2.0, d2) * 256.0);
        }
        throw new IllegalArgumentException("zoom level must not be negative: " + f2);
    }

    public static double latitudeToPixelY(double d2, float f2) {
        d2 = Math.sin(d2 * (Math.PI / 180));
        long l2 = MercatorProjection.getMapSize(f2);
        d2 = Math.log((d2 + 1.0) / (1.0 - d2)) / (Math.PI * 4);
        double d3 = 0.5 - d2;
        d2 = l2;
        double d4 = d3 * d2;
        return Math.min(Math.max(0.0, d4), d2);
    }

    public static long latitudeToTileY(double d2, float f2) {
        return MercatorProjection.pixelYToTileY(MercatorProjection.latitudeToPixelY(d2, f2), f2);
    }

    public static double longitudeToPixelX(double d2, float f2) {
        long l2 = MercatorProjection.getMapSize(f2);
        return (d2 + 180.0) / 360.0 * (double)l2;
    }

    public static long longitudeToTileX(double d2, float f2) {
        return MercatorProjection.pixelXToTileX(MercatorProjection.longitudeToPixelX(d2, f2), f2);
    }

    public static double pixelXToLongitude(double d2, float f2) {
        double d3;
        long l2 = MercatorProjection.getMapSize(f2);
        if (!(d2 < 0.0) && !(d2 > (d3 = (double)l2))) {
            return (d2 / d3 - 0.5) * 360.0;
        }
        throw new IllegalArgumentException("invalid pixelX coordinate at zoom level " + f2 + ": " + d2);
    }

    public static long pixelXToTileX(double d2, float f2) {
        double d3 = Math.max(d2 / 256.0, 0.0);
        d2 = f2;
        return (long)Math.min(d3, Math.pow(2.0, d2) - 1.0);
    }

    public static double pixelYToLatitude(double d2, float f2) {
        double d3;
        long l2 = MercatorProjection.getMapSize(f2);
        if (!(d2 < 0.0) && !(d2 > (d3 = (double)l2))) {
            d2 /= d3;
            d2 = Math.atan(Math.exp(-(0.5 - d2) * (Math.PI * 2))) * 360.0 / Math.PI;
            return 90.0 - d2;
        }
        throw new IllegalArgumentException("invalid pixelY coordinate at zoom level " + f2 + ": " + d2);
    }

    public static long pixelYToTileY(double d2, float f2) {
        double d3 = Math.max(d2 / 256.0, 0.0);
        d2 = f2;
        return (long)Math.min(d3, Math.pow(2.0, d2) - 1.0);
    }

    public static double tileXToLongitude(long l2, float f2) {
        return MercatorProjection.pixelXToLongitude(l2 * 256L, f2);
    }

    public static double tileYToLatitude(long l2, float f2) {
        return MercatorProjection.pixelYToLatitude(l2 * 256L, f2);
    }

    static double[] a(double d2, double d3) {
        d2 = d2 * 2.003750834E7 / 180.0;
        d3 = Math.log(Math.tan((d3 + 90.0) * Math.PI / 360.0)) / (Math.PI / 180) * 2.003750834E7 / 180.0;
        return new double[]{d2, d3};
    }

    static double[] b(double d2, double d3) {
        d2 = d2 / 2.003750834E7 * 180.0;
        d3 = (Math.atan(Math.exp(d3 / 2.003750834E7 * 180.0 * Math.PI / 180.0)) * 2.0 - 1.5707963267948966) * 57.29577951308232;
        return new double[]{d2, d3};
    }

    private MercatorProjection() {
        throw new IllegalStateException();
    }
}

