/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.support.annotation.NonNull;
import com.sails.engine.Beacon;
import com.sails.engine.SAILS;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.f;
import com.sails.engine.g;
import com.sails.engine.n;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class LocationRegion {
    public static final int NORMAL = 0;
    public static final int ENGLISH = 1;
    public static final int CHINESE_BIG5 = 2;
    public static final int CHINESE_SM = 3;
    public static final int JAPANESE = 4;
    public static int FONT_LANGUAGE = 2;
    public long id;
    public List<SAILS.GeoNode> mBoundaryVertexList = new ArrayList<SAILS.GeoNode>();
    public String label;
    n a;
    public Beacon beacon = null;
    public int level;
    public int order;
    public int stack;
    public String chinese_t = null;
    public String chinese_s = null;
    public String english = null;
    public String japanese = null;
    public String type = null;
    public String subtype = null;
    public String url = null;
    public String uuid = null;
    public String renderName = null;
    public String show_3d_height = null;
    public boolean navi = false;
    public boolean show_label = false;
    public boolean show_region = false;
    public boolean reverse_enable = false;
    public String icon_sails = null;
    public String title = null;
    public String panorama = null;
    public double angle = 0.0;
    public int self = Integer.MAX_VALUE;
    public List<Integer> goToList = new ArrayList<Integer>();
    public double fusionCoefficient = 0.0;
    boolean b = false;
    boolean c = false;
    double d;
    double e;
    public double updatedLength = -1.0;
    public int changeFloorCount = 0;
    boolean f = false;
    g.a g = null;
    List<f.a> h = null;

    public LocationRegion() {
    }

    public LocationRegion(String string, double d2, double d3, String string2, @NonNull SAILS sAILS) {
        this.a(sAILS, string2);
        this.e = d3;
        this.d = d2;
        this.label = string;
        this.a(sAILS);
    }

    void a(SAILS sAILS) {
        if (this.hasPathNode() || this.f || this.a == null || sAILS == null || sAILS.j.C == null || sAILS.j.C.p == null) {
            return;
        }
        this.g = sAILS.j.C.a(this.d, this.e, this.a.b);
        if (this.g != null && this.g.f != null) {
            this.g = this.g.f;
            this.f = true;
        }
    }

    void a(SAILS sAILS, String string) {
        for (n n2 : sAILS.j.C.f) {
            if (!n2.a.equals(string)) continue;
            this.a = n2;
        }
    }

    public String getFloorName() {
        if (this.a != null) {
            return this.a.a;
        }
        return null;
    }

    public String getFloorDescription() {
        return this.a.c;
    }

    public int getFloorNumber() {
        if (this.a != null) {
            return this.a.b;
        }
        return 0;
    }

    public String getName() {
        switch (FONT_LANGUAGE) {
            case 0: {
                return this.label == null ? null : this.label.replace(" - ", "");
            }
            case 2: {
                return this.chinese_t;
            }
            case 3: {
                return this.chinese_s;
            }
            case 1: {
                return this.english;
            }
            case 4: {
                return this.japanese;
            }
        }
        return this.label;
    }

    public boolean isInRegion(double d2, double d3) {
        if (d2 == Double.NaN || d3 == Double.NaN) {
            return false;
        }
        if (this.mBoundaryVertexList.size() < 3) {
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = this.mBoundaryVertexList.size() - 1;
        while (n2 < this.mBoundaryVertexList.size()) {
            if (this.mBoundaryVertexList.get((int)n2).latitude > d3 != this.mBoundaryVertexList.get((int)n3).latitude > d3 && d2 < (this.mBoundaryVertexList.get((int)n3).longitude - this.mBoundaryVertexList.get((int)n2).longitude) * (d3 - this.mBoundaryVertexList.get((int)n2).latitude) / (this.mBoundaryVertexList.get((int)n3).latitude - this.mBoundaryVertexList.get((int)n2).latitude) + this.mBoundaryVertexList.get((int)n2).longitude) {
                bl = !bl;
            }
            n3 = n2++;
        }
        return bl;
    }

    public boolean hasPathNode() {
        return this.h != null && this.h.size() != 0;
    }

    public double getCenterLongitude() {
        return this.d;
    }

    public double getCenterLatitude() {
        return this.e;
    }

    public void setVertexList(List<SAILS.GeoNode> list) {
        if (list.size() == 1) {
            this.e = list.get((int)0).latitude;
            this.d = list.get((int)0).longitude;
            return;
        }
        this.mBoundaryVertexList = list;
        a[] aArray = new a[list.size() + 1];
        boolean bl = false;
        int n2 = 0;
        a a2 = null;
        for (SAILS.GeoNode geoNode : list) {
            double d2 = MercatorProjection.longitudeToPixelX(geoNode.longitude, 22.0f);
            double d3 = MercatorProjection.latitudeToPixelY(geoNode.latitude, 22.0f);
            double[] dArray = new double[]{d2, d3};
            if (n2 == 0) {
                a2 = new a(d2, d3);
            }
            a a3 = new a(dArray[0] - a2.a, dArray[1] - a2.b);
            if (n2 == 0) {
                aArray[list.size()] = a3;
            }
            aArray[n2] = a3;
            ++n2;
        }
        a a4 = this.b(aArray);
        if (a4 != null) {
            double d4;
            double d5 = MercatorProjection.pixelXToLongitude(a4.a + a2.a, 22.0f);
            this.e = d4 = MercatorProjection.pixelYToLatitude(a4.b + a2.b, 22.0f);
            this.d = d5;
        }
    }

    public double getArea() {
        a[] aArray = new a[this.mBoundaryVertexList.size() + 1];
        boolean bl = false;
        int n2 = 0;
        a a2 = null;
        for (SAILS.GeoNode geoNode : this.mBoundaryVertexList) {
            double d2 = MercatorProjection.longitudeToPixelX(geoNode.longitude, 22.0f);
            double d3 = MercatorProjection.latitudeToPixelY(geoNode.latitude, 22.0f);
            double[] dArray = new double[]{d2, d3};
            if (n2 == 0) {
                a2 = new a(d2, d3);
            }
            a a3 = new a(dArray[0] - a2.a, dArray[1] - a2.b);
            if (n2 == 0) {
                aArray[this.mBoundaryVertexList.size()] = a3;
            }
            aArray[n2] = a3;
            ++n2;
        }
        return Math.abs(this.a(aArray));
    }

    private double a(a[] aArray) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < aArray.length - 1; ++i2) {
            d2 = d2 + aArray[i2].a * aArray[i2 + 1].b - aArray[i2].b * aArray[i2 + 1].a;
        }
        return 0.5 * d2;
    }

    private a b(a[] aArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < aArray.length - 1; ++i2) {
            double d5 = -(aArray[i2].b * aArray[i2 + 1].a - aArray[i2].a * aArray[i2 + 1].b);
            d2 += (aArray[i2].a + aArray[i2 + 1].a) * d5;
            d3 += (aArray[i2].b + aArray[i2 + 1].b) * d5;
            d4 += d5;
        }
        return new a(d2 /= 3.0 * d4, d3 /= 3.0 * d4);
    }

    public static class RegionByStackComparator
    implements Comparator<LocationRegion> {
        @Override
        public int compare(LocationRegion locationRegion, LocationRegion locationRegion2) {
            return locationRegion2.stack - locationRegion.stack;
        }
    }

    public static class RegionByAreaComparator
    implements Comparator<LocationRegion> {
        @Override
        public int compare(LocationRegion locationRegion, LocationRegion locationRegion2) {
            return new Double(locationRegion.getArea()).compareTo(new Double(locationRegion2.getArea()));
        }
    }

    public static class RegionByLevelComparator
    implements Comparator<LocationRegion> {
        @Override
        public int compare(LocationRegion locationRegion, LocationRegion locationRegion2) {
            if (locationRegion.level < locationRegion2.level) {
                return 1;
            }
            if (locationRegion.level == locationRegion2.level) {
                return 0;
            }
            return -1;
        }
    }

    class a {
        final double a;
        final double b;

        a(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }
    }

    static class b {
        final double a;
        final double b;

        b(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }
    }
}

