package com.locnavi.location.xunjimap.utils;



import com.locnavi.location.R;
import com.locnavi.location.xunjimap.XJLocationSDK;


import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * author:chen
 * time:2017/6/21
 * desc:
 */
public class DateUtils {

    public static int daysBetween(Date d1, Date d2) {
        return (int) ((d1.getTime() - d2.getTime()) / 86400000);
    }

    public static int minutesBetween(Date d1, Date d2) {
        return (int) ((d1.getTime() - d2.getTime()) / (60 * 1000));
    }

    public static Date dateDiff(Date d1, int day) {
        return new Date(d1.getTime() + 24 * 60 * 60 * 1000 * day);
    }

    public static Date dateDiff2(Date d1, int minute) {
        return new Date(d1.getTime() + 60 * 1000 * minute);
    }

    public static String getTimeBeforeNow(long timeL) {

        long timeDiff = new Date().getTime() - timeL;
        if(timeDiff < 0){
            return XJLocationSDK.context.getString(R.string.ipsmap_just_now);
        }
        long time = timeDiff / 1000;
        StringBuffer sb = new StringBuffer();
        long day = time / (24 * 60 * 60);
        time = time - day * (24 * 60 * 60);
        long hour = time / (60 * 60);
        time = time - hour * (60 * 60);
        long minute = time / 60;
        time = time - minute * 60;
        long second = time;

        if (hour >= 1) {
            sb.append(hour + XJLocationSDK.context.getString(R.string.ipsmap_hour_before));
        } else if (minute >= 1 && minute < 60) {
            sb.append(minute + XJLocationSDK.context.getString(R.string.ipsmap_hour_before));
        } else if (second >= 0 && second < 60) {
            sb.append(XJLocationSDK.context.getString(R.string.ipsmap_just_now));
        }
        return sb.toString();
    }

    public static String getSimpleDate(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public static String getSimpleDate2(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

}
