/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.annotation.TargetApi;
import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.widget.Toast;
import com.sails.engine.Beacon;
import com.sails.engine.GPSLocation;
import com.sails.engine.LocationData;
import com.sails.engine.LocationRegion;
import com.sails.engine.LocationSignalPlayer;
import com.sails.engine.LocationSignalPlayerListener;
import com.sails.engine.PathRoutingManager;
import com.sails.engine.PurePathRoutingManager;
import com.sails.engine.SAILSLocationManager;
import com.sails.engine.SAILSMapView;
import com.sails.engine.SensorElement;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.h;
import com.sails.engine.i;
import com.sails.engine.n;
import com.sails.engine.overlay.ScreenDensity;
import com.sails.engine.q;
import com.sails.engine.u;
import com.sails.engine.v;
import com.sails.engine.w;
import com.sails.engine.z;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xmlpull.v1.XmlPullParserException;

public class SAILS
implements Serializable {
    static final int a = 0;
    static final int b = 1;
    public static final int WIFI_GFP_IMU = 2;
    static final int c = 4;
    static final int d = 8;
    static final int e = 16;
    public static final int BLE_GFP_IMU = 32;
    static final int f = 64;
    static final int g = 128;
    public static final int BLE_ADVERTISING = 256;
    public static final int WITHOUT_FOLLOW_HEADING = 512;
    public static final int BACKGROUND = 1024;
    public static final int WITH_GPS = 2048;
    public static final int BEACON_PATROLLING = 4096;
    public static final int SIMULATION = 8192;
    public static final int IOT_MODE = 16384;
    String h = "";
    private double s;
    private double t;
    private double u = 0.0;
    private double v = 0.0;
    private double w = 0.0;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 1.0;
    private boolean A = false;
    private long B = 0L;
    private boolean C = false;
    private com.sails.engine.b D;
    private SignalStatus E = SignalStatus.STRONG_BEACON_SIGNAL;
    PurePathRoutingManager i = null;
    private GPSLocation F = null;
    SAILSLocationManager j;
    static final String k = Environment.getExternalStorageDirectory().getAbsolutePath() + "/SAILSMap";
    private static Context G;
    private boolean H = false;
    private boolean I = false;
    private boolean J = false;
    public boolean showAccuracy = false;
    private final u K;
    static final String l;
    private String L = "sails_cloud";
    SAILSMapView m = null;
    private LocationRegion M = null;
    private int N = 0;
    boolean n = false;
    int o = 0;
    private OnBTDisableAlertCallback O = null;
    private LocationSignalPlayer.SensorEventListener P = new LocationSignalPlayer.SensorEventListener(){

        @Override
        public void onStep() {
            SAILS.this.j.X.k();
        }

        @Override
        public void onHeading(double d2) {
            SAILS.this.j.aa.a(d2);
        }

        @Override
        public void onBLEScan(List<v> list) {
            SAILS.this.j.h(list);
        }

        @Override
        public void onGPS(Location location) {
            if (SAILS.this.j.i != null) {
                SAILS.this.F.a(location);
            }
        }
    };
    boolean p = false;
    LocationSignalPlayer q = new LocationSignalPlayer();
    d r = new d(this);

    public void setPurePathRoutingManager(PurePathRoutingManager purePathRoutingManager) {
        this.i = purePathRoutingManager;
    }

    public void setSignalStatusChangeCallback(SignalStatusChangeCallback signalStatusChangeCallback) {
        this.j.Q = signalStatusChangeCallback;
    }

    public void setMode(int n2) {
        if ((n2 & 0x800) == 2048) {
            this.setSpeedFactor(1.0);
            this.j.aa.h.p = 2000.0;
        } else {
            this.j.aa.h.p = 200.0;
            this.F = null;
            this.j.i = null;
            this.I = false;
            this.j.c = false;
        }
        this.j.b(n2);
    }

    public void useNewFloorDetermineAlgorithm(boolean bl) {
        com.sails.engine.b.p = bl;
    }

    public void setSpeedFactor(double d2) {
        this.z = d2;
        if (this.j.C != null) {
            for (n n2 : this.j.C.f) {
                n2.B = this.z;
            }
        }
        this.j.O = this.z;
    }

    public boolean isGPSAvailable() {
        if (this.F == null) {
            return false;
        }
        return this.F.isAvaliable();
    }

    public int getMode() {
        return this.j.a;
    }

    public boolean checkMode(int n2) {
        return (this.j.a & n2) == n2;
    }

    public void setPathRoutingNodeList(List<GeoNode> list) {
        this.j.d = list != null ? Collections.synchronizedList(list) : null;
    }

    public SAILS(Context context) {
        G = context;
        this.D = new com.sails.engine.b(this);
        this.j = new SAILSLocationManager(context);
        this.j.a(this.D);
        this.K = new u(context);
        ScreenDensity.density = context.getResources().getDisplayMetrics().density;
    }

    public void destroy() {
        this.j.b();
        this.D.b(null);
    }

    public Context getAppContext() {
        return G;
    }

    public void clear() {
        if (this.isLocationEngineStarted()) {
            this.stopLocatingEngine();
        }
        this.j = new SAILSLocationManager((Context)((Activity)G));
    }

    public void lockFloor(String string) {
        n n2 = null;
        for (n n3 : this.j.C.f) {
            if (!n3.a.equals(string)) continue;
            n2 = n3;
            break;
        }
        if (n2 == null) {
            return;
        }
        this.j.C.a(n2);
    }

    public void unlockFloor() {
        this.j.C.c();
    }

    RoutingInfo a(LocationRegion locationRegion, LocationRegion locationRegion2) {
        if (locationRegion == null || locationRegion2 == null || !locationRegion.getFloorName().equals(locationRegion2.getFloorName())) {
            return new RoutingInfo(false, 0);
        }
        List<GeoNode> list = locationRegion.a.a(locationRegion.getCenterLongitude(), locationRegion.getCenterLatitude(), locationRegion2);
        if (list == null) {
            return new RoutingInfo(false, 0);
        }
        double d2 = locationRegion.a.d(list);
        RoutingInfo routingInfo = new RoutingInfo(true, (int)d2);
        routingInfo.c = list;
        return routingInfo;
    }

    RoutingInfo a(LocationRegion locationRegion) {
        if (locationRegion.a != this.j.N) {
            RoutingInfo routingInfo = new RoutingInfo(false, 0);
            return routingInfo;
        }
        List<GeoNode> list = this.j.N.a(this.getLongitude(), this.getLatitude(), locationRegion);
        if (list == null) {
            return new RoutingInfo(false, 0);
        }
        double d2 = this.j.N.d(list);
        RoutingInfo routingInfo = new RoutingInfo(true, Math.round((float)d2));
        routingInfo.c = list;
        return routingInfo;
    }

    public RoutingInfo route3D(LocationRegion locationRegion, LocationRegion locationRegion2) {
        return this.route3DQuick(locationRegion, locationRegion2, false);
    }

    public RoutingInfo route3DQuick(LocationRegion locationRegion, LocationRegion locationRegion2, boolean bl) {
        if (locationRegion == null || locationRegion2 == null) {
            return new RoutingInfo(false, 0);
        }
        List<GeoNode> list = this.j.C.a(locationRegion.getCenterLongitude(), locationRegion.getCenterLatitude(), locationRegion.a, locationRegion2, bl);
        if (list == null) {
            return new RoutingInfo(false, 0);
        }
        double d2 = this.j.C.a(list);
        RoutingInfo routingInfo = new RoutingInfo(true, (int)d2);
        routingInfo.c = list;
        return routingInfo;
    }

    public RoutingInfo route3D(LocationRegion locationRegion) {
        return this.route3DQuick(locationRegion, false);
    }

    public RoutingInfo route3DwithSavedRoutedPath(List<GeoNode> list, List<GeoNode> list2, LocationRegion locationRegion) {
        RoutingInfo routingInfo = this.route3DwithSavedRoutedPath(list2, locationRegion);
        if (list == null || list.size() == 0) {
            return routingInfo;
        }
        ArrayList<GeoNode> arrayList = new ArrayList<GeoNode>();
        if (routingInfo.d != null && routingInfo.d.size() > 1) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                GeoNode geoNode = list.get(i2);
                arrayList.add(geoNode);
                if (geoNode.latitude == routingInfo.d.get((int)1).latitude && geoNode.longitude == routingInfo.d.get((int)1).longitude && geoNode.floornumber == routingInfo.d.get((int)1).floornumber) break;
            }
            routingInfo.d = arrayList;
        }
        return routingInfo;
    }

    public RoutingInfo route3DwithSavedRoutedPath(List<GeoNode> list, LocationRegion locationRegion) {
        int n2;
        GeoNode geoNode2;
        if (this.M != locationRegion || PathRoutingManager.f != this.N) {
            this.N = PathRoutingManager.f;
            this.M = locationRegion;
            list = null;
        }
        if (list == null || list.size() == 0) {
            return this.route3D(locationRegion);
        }
        n n3 = this.checkMode(8192) ? com.sails.engine.b.m : (this.isUseGPS() ? this.j.x : this.j.N);
        if (n3 == null) {
            return new RoutingInfo(false, 0);
        }
        double d2 = this.getLongitude();
        double d3 = this.getLatitude();
        double d4 = d2;
        double d5 = d3;
        double d6 = Double.MAX_VALUE;
        int n4 = 0;
        if (list != null && list.size() > 1) {
            boolean bl = true;
            for (GeoNode geoNode2 : list) {
                if (geoNode2.floornumber != n3.b) continue;
                bl = false;
                break;
            }
            for (int i2 = 0; i2 < list.size() - 1; ++i2) {
                double d7;
                double d8;
                double d9;
                double d10;
                double d11;
                geoNode2 = list.get(i2);
                GeoNode geoNode3 = list.get(i2 + 1);
                if ((!bl || i2 > 1) && n3.b != geoNode2.floornumber) continue;
                double d12 = geoNode2.latitude;
                double d13 = geoNode3.latitude;
                double d14 = geoNode2.longitude;
                double d15 = geoNode3.longitude;
                double d16 = d3;
                double d17 = d2;
                double d18 = -(d13 - d12) / (d15 - d14) * d14 + d12;
                double d19 = (d13 - d12) / (d15 - d14);
                double d20 = d16 + 1.0 / d19 * d17;
                double d21 = d18 / (d19 * d19 + 1.0) + d19 * d19 * d20 / (d19 * d19 + 1.0);
                double d22 = -(d21 - d20) * d19;
                if (geoNode2.floornumber != geoNode3.floornumber) {
                    d15 = d14;
                    d13 = d12;
                }
                if ((d11 = (double)SAILSLocationManager.c(d2, d3, d14, d12)) > (d10 = (double)SAILSLocationManager.c(d2, d3, d15, d13))) {
                    d9 = d10;
                    d8 = d15;
                    d7 = d13;
                } else {
                    d9 = d11;
                    d8 = d14;
                    d7 = d12;
                }
                if (!(d22 > d14 && d22 > d15 || d22 < d14 && d22 < d15 || d21 < d12 && d21 < d13 || d21 < d12 && d21 < d13)) {
                    d9 = SAILSLocationManager.c(d2, d3, d22, d21);
                    d8 = d22;
                    d7 = d21;
                }
                if (!(d9 < d6)) continue;
                d6 = d9;
                d4 = d8;
                d5 = d7;
                n4 = i2 + 1;
            }
            d2 = d4;
            d3 = d5;
        } else {
            d6 = 0.0;
        }
        ArrayList<GeoNode> arrayList = new ArrayList<GeoNode>();
        ArrayList<GeoNode> arrayList2 = new ArrayList<GeoNode>();
        geoNode2 = new GeoNode(d2, d3);
        geoNode2.floornumber = n3.b;
        geoNode2.floorname = n3.a;
        geoNode2.floorDesc = n3.c;
        arrayList.add(geoNode2);
        for (n2 = n4; n2 < list.size(); ++n2) {
            arrayList.add(list.get(n2));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            arrayList2.add(list.get(n2));
        }
        arrayList2.add(geoNode2);
        double d23 = this.j.C.a(arrayList);
        RoutingInfo routingInfo = new RoutingInfo(true, (int)d23);
        routingInfo.c = arrayList;
        routingInfo.d = arrayList2;
        routingInfo.offset = (int)d6;
        ArrayList<GeoNode> arrayList3 = new ArrayList<GeoNode>(arrayList);
        routingInfo.b = (int)this.j.C.b(arrayList3);
        return routingInfo;
    }

    public RoutingInfo route3DQuick(LocationRegion locationRegion, boolean bl) {
        List<GeoNode> list = this.checkMode(8192) ? this.j.C.a(this.getLongitude(), this.getLatitude(), com.sails.engine.b.m, locationRegion, bl) : (this.isUseGPS() ? this.j.C.a(this.getLongitude(), this.getLatitude(), this.j.x, locationRegion, bl, true) : this.j.C.a(this.getLongitude(), this.getLatitude(), this.j.N, locationRegion, bl));
        if (list == null) {
            return new RoutingInfo(false, 0);
        }
        double d2 = this.j.C.a(list);
        RoutingInfo routingInfo = new RoutingInfo(true, (int)d2);
        routingInfo.c = list;
        routingInfo.b = (int)this.j.C.b(list);
        return routingInfo;
    }

    public List<LocationRegion> sortLocationRegionsByPathLength(List<LocationRegion> list) {
        if (!this.isLocationFix()) {
            return null;
        }
        this.clearRouteCache();
        for (LocationRegion locationRegion : list) {
            List<GeoNode> list2 = this.checkMode(8192) ? this.j.C.a(this.getLongitude(), this.getLatitude(), com.sails.engine.b.m, locationRegion) : (this.isUseGPS() ? this.j.C.a(this.getLongitude(), this.getLatitude(), this.j.x, locationRegion) : this.j.C.a(this.getLongitude(), this.getLatitude(), this.j.N, locationRegion));
            if (list2 == null) {
                locationRegion.updatedLength = -1.0;
                locationRegion.changeFloorCount = 0;
                continue;
            }
            locationRegion.updatedLength = this.j.C.a(list2);
            int n2 = 0;
            String string = null;
            for (GeoNode geoNode : list2) {
                if (string == null) {
                    string = geoNode.floorname;
                    continue;
                }
                if (geoNode.floorname == null || geoNode.floorname.equals(string)) continue;
                ++n2;
                string = geoNode.floorname;
            }
            locationRegion.changeFloorCount = n2;
        }
        ArrayList<LocationRegion> arrayList = new ArrayList<LocationRegion>(list);
        Collections.sort(arrayList, new Comparator<LocationRegion>(){

            public int a(LocationRegion locationRegion, LocationRegion locationRegion2) {
                if (locationRegion.updatedLength == -1.0 || locationRegion2.updatedLength == -1.0) {
                    if (locationRegion.updatedLength == -1.0 && locationRegion2.updatedLength == -1.0) {
                        return 0;
                    }
                    if (locationRegion.updatedLength == -1.0) {
                        return 1;
                    }
                    return -1;
                }
                if (locationRegion.updatedLength + (double)(locationRegion.changeFloorCount * 15) == locationRegion2.updatedLength + (double)(locationRegion2.changeFloorCount * 15)) {
                    return 0;
                }
                if (locationRegion.updatedLength + (double)(locationRegion.changeFloorCount * 15) > locationRegion2.updatedLength + (double)(locationRegion2.changeFloorCount * 15)) {
                    return 1;
                }
                return -1;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((LocationRegion)object, (LocationRegion)object2);
            }
        });
        return arrayList;
    }

    public double getMapDistanceByLngLat(double d2, double d3, double d4, double d5) {
        return this.j.d(d2, d3, d4, d5);
    }

    public int getLinearDistance(LocationRegion locationRegion) {
        if (!(this.isInThisBuilding() && this.isLocationFix() && locationRegion.getFloorName().equals(this.getFloor()))) {
            return Integer.MAX_VALUE;
        }
        return (int)this.getMapDistanceByLngLat(this.getLongitude(), this.getLatitude(), locationRegion.d, locationRegion.e);
    }

    public int getLinearDistance(LocationRegion locationRegion, LocationRegion locationRegion2) {
        if (!locationRegion.getFloorName().equals(locationRegion2.getFloorName())) {
            return Integer.MAX_VALUE;
        }
        return (int)this.getMapDistanceByLngLat(locationRegion.d, locationRegion.e, locationRegion2.d, locationRegion2.e);
    }

    public int getSingleRouteDistance(LocationRegion locationRegion) {
        if (!this.isInThisBuilding() || !this.isLocationFix()) {
            return Integer.MAX_VALUE;
        }
        RoutingInfo routingInfo = this.route3DQuick(locationRegion, true);
        if (!routingInfo.success) {
            return Integer.MAX_VALUE;
        }
        return routingInfo.getDistance();
    }

    public int getSingleRouteDistance(LocationRegion locationRegion, LocationRegion locationRegion2) {
        RoutingInfo routingInfo = this.route3DQuick(locationRegion, locationRegion2, true);
        if (!routingInfo.success) {
            return Integer.MAX_VALUE;
        }
        return routingInfo.getDistance();
    }

    public void clearRouteCache() {
        this.j.C.q = null;
        this.j.C.r = null;
    }

    public void setSmoothChangeFloor(boolean bl) {
        this.j.y = bl;
    }

    public boolean isHeadingStable() {
        if (this.checkMode(2048)) {
            return true;
        }
        return !this.j.aa.u;
    }

    public String getBuildingName() {
        if (this.j.C != null) {
            return this.j.C.b;
        }
        return null;
    }

    public List<LocationRegion> getCurrentInRegions() {
        List<LocationRegion> list = new ArrayList<LocationRegion>();
        if (this.isInThisBuilding() && this.j.N != null) {
            list = this.j.N.a(this.getLongitude(), this.getLatitude());
        }
        return list;
    }

    public List<String> getFloorNameList() {
        if (this.j == null || this.j.C == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n n2 : this.j.C.f) {
            if (n2.a.equals("-20")) continue;
            arrayList.add(n2.a);
        }
        if (this.J) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    public List<Integer> getFloorNumberList() {
        if (this.j == null || this.j.C == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n n2 : this.j.C.f) {
            if (n2.a.equals("-20")) continue;
            arrayList.add(n2.b);
        }
        if (this.J) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    public List<String> getFloorDescList() {
        if (this.j == null || this.j.C == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n n2 : this.j.C.f) {
            if (n2.a.equals("-20")) continue;
            arrayList.add(n2.c);
        }
        if (this.J) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    public List<String> getFloorEntireNameList() {
        if (this.j == null || this.j.C == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n n2 : this.j.C.f) {
            if (n2.a.equals("-20")) continue;
            arrayList.add(com.sails.engine.c.a(n2.b) + " " + n2.c);
        }
        if (this.J) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    private n c(String string) {
        if (this.j == null || this.j.C == null) {
            return null;
        }
        for (n n2 : this.j.C.f) {
            if (!n2.a.equals(string)) continue;
            return n2;
        }
        return null;
    }

    private n a(int n2) {
        if (this.j == null || this.j.C == null) {
            return null;
        }
        for (n n3 : this.j.C.f) {
            if (n3.b != n2) continue;
            return n3;
        }
        return null;
    }

    public void setReverseFloorList(boolean bl) {
        this.J = bl;
    }

    public SAILSMapView.SAILSMapFormat getMapFormat(String string) {
        if (this.j == null || this.j.C == null) {
            return SAILSMapView.SAILSMapFormat.VOID;
        }
        n n2 = null;
        for (n n3 : this.j.C.f) {
            if (!n3.a.equals(string)) continue;
            n2 = n3;
            break;
        }
        if (n2 == null) {
            return SAILSMapView.SAILSMapFormat.VOID;
        }
        if (n2.D != null) {
            return SAILSMapView.SAILSMapFormat.Vector;
        }
        if (n2.E != null) {
            return SAILSMapView.SAILSMapFormat.JPG;
        }
        return SAILSMapView.SAILSMapFormat.VOID;
    }

    File a(String string) {
        if (this.j == null || this.j.C == null) {
            return null;
        }
        n n2 = null;
        for (n n3 : this.j.C.f) {
            if (!n3.a.equals(string)) continue;
            n2 = n3;
            break;
        }
        if (n2 == null) {
            return null;
        }
        return n2.D;
    }

    File b(String string) {
        if (this.j == null || this.j.C == null) {
            return null;
        }
        n n2 = null;
        for (n n3 : this.j.C.f) {
            if (!n3.a.equals(string)) continue;
            n2 = n3;
            break;
        }
        if (n2 == null) {
            return null;
        }
        return n2.E;
    }

    public List<LocationRegion> findRegionByLabel(String string) {
        ArrayList<LocationRegion> arrayList = new ArrayList<LocationRegion>();
        for (n n2 : this.j.C.f) {
            arrayList.addAll(n2.b(string));
        }
        return arrayList;
    }

    public void setNoWalkAwayPushRepeatDuration(long l2) {
        SAILSLocationManager.b = l2;
    }

    public double getUserHeading() {
        if (this.checkMode(8192)) {
            return this.y;
        }
        return this.j.aa.h.i;
    }

    public double getMapViewRotation() {
        if (this.checkMode(8192)) {
            return this.y;
        }
        if ((this.i != null && this.i.isRoutingEnable() || this.m != null && this.m.getRoutingManager().isRoutingEnable()) && this.j.g != Float.MAX_VALUE) {
            if (!this.A && Math.cos((this.j.aa.h.h - (double)this.j.g) * Math.PI / 180.0) > Math.cos(0.4363323129985824)) {
                this.A = true;
                return this.j.g;
            }
            if (this.A && Math.cos((this.j.aa.h.h - (double)this.j.g) * Math.PI / 180.0) > Math.cos(0.8726646259971648)) {
                return this.j.g;
            }
            this.A = false;
        }
        return this.getUserHeading();
    }

    public double getMapScale() {
        return this.j.O;
    }

    public static double GetBearDegree(double d2, double d3, double d4, double d5) {
        return Math.toDegrees(Math.atan2((d4 - d2) * Math.cos(Math.toRadians(d5)), d5 - d3));
    }

    public boolean isWiFiTurnOn() {
        WifiManager wifiManager = (WifiManager)G.getSystemService("wifi");
        return wifiManager.isWifiEnabled();
    }

    @TargetApi(value=18)
    public boolean isBluetoothTurnOn() {
        BluetoothManager bluetoothManager = (BluetoothManager)G.getSystemService("bluetooth");
        return bluetoothManager.getAdapter().isEnabled();
    }

    public void forceTurnOnBluetooth(boolean bl) {
        if (this.j.ac != null) {
            this.j.ac.c = bl;
        }
    }

    @TargetApi(value=18)
    public boolean isBLEAvailable() {
        boolean bl = false;
        if (this.j.s.getPackageManager() != null) {
            bl = this.j.s.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
        }
        return bl;
    }

    public void forceCancelMagneticCalibration() {
        this.j.e = true;
        this.j.f = System.currentTimeMillis();
        this.j.aa.d();
    }

    public void setMagneticCalibrationCallback(NeedMagneticCalibrationCallback needMagneticCalibrationCallback) {
        this.j.aK = needMagneticCalibrationCallback;
    }

    private void a(final InputStream inputStream, final String string, final OnFinishCallback onFinishCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SharedPreferences sharedPreferences = G.getSharedPreferences("sails", 0);
                String string2 = sharedPreferences.getString("map_ver", "");
                boolean bl = true;
                if (string2.equals(string)) {
                    bl = false;
                }
                SAILS.this.H = false;
                try {
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    File file = new File(G.getFilesDir(), "SAILSMap");
                    if (bl) {
                        new b().a(zipInputStream, file, true);
                    }
                    SAILS.this.a(file);
                    sharedPreferences.edit().putString("map_ver", string).apply();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    onFinishCallback.onFailed(exception.getMessage());
                    return;
                }
                SAILS.this.H = true;
                onFinishCallback.onSuccess("");
            }
        }).start();
    }

    private void a(int n2, String string, OnFinishCallback onFinishCallback) {
        this.a(G.getResources().openRawResource(n2), string, onFinishCallback);
    }

    private void a(File file, String string, OnFinishCallback onFinishCallback) {
        try {
            this.a(new FileInputStream(file), string, onFinishCallback);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            onFinishCallback.onFailed(fileNotFoundException.getMessage());
        }
    }

    private void b(int n2, String string, OnFinishCallback onFinishCallback) {
        SharedPreferences sharedPreferences = G.getSharedPreferences("sails", 0);
        String string2 = sharedPreferences.getString("map_ver", "");
        if (string2.length() == 0) {
            this.a(n2, string, onFinishCallback);
            return;
        }
        if (Float.parseFloat(string) <= Float.parseFloat(string2)) {
            this.a(onFinishCallback);
        } else {
            this.a(n2, string, onFinishCallback);
        }
    }

    private boolean d(String string) {
        SharedPreferences sharedPreferences = G.getSharedPreferences("sails", 0);
        String string2 = sharedPreferences.getString("map_ver", "");
        return Float.parseFloat(string) > Float.parseFloat(string2);
    }

    private void a(final OnFinishCallback onFinishCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(G.getFilesDir(), "SAILSMap");
                    SAILS.this.a(file);
                    onFinishCallback.onSuccess("");
                }
                catch (IOException | XmlPullParserException throwable) {
                    throwable.printStackTrace();
                    onFinishCallback.onFailed(throwable.getMessage());
                }
            }
        }).start();
    }

    private void a(String string, final String string2, final OnFinishCallback onFinishCallback) {
        this.K.b(string, new OnFinishCallback(){

            @Override
            public void onSuccess(String string) {
                SAILS.this.a(new File(G.getFilesDir(), "/map.zip"), string2, new OnFinishCallback(){

                    @Override
                    public void onSuccess(String string) {
                        onFinishCallback.onSuccess(string);
                    }

                    @Override
                    public void onFailed(String string) {
                        onFinishCallback.onFailed(string);
                    }
                });
            }

            @Override
            public void onFailed(String string) {
                onFinishCallback.onFailed(string);
            }
        });
    }

    private void a(int n2, boolean bl) {
        this.H = false;
        ZipInputStream zipInputStream = new ZipInputStream(G.getResources().openRawResource(n2));
        File file = new File(G.getFilesDir(), "SAILSMap");
        try {
            new b().a(zipInputStream, file, bl);
            this.a(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.H = true;
    }

    static void a(File file, String string) {
        File file2 = new File(G.getFilesDir(), "SAILSMap/" + string);
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            String string2 = new b().a(zipInputStream, file2, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setGPSFloorLayer(String string) {
        if (string != null) {
            this.h = string;
            for (n n2 : this.j.C.f) {
                if (!n2.a.equals(string)) continue;
                this.j.x = n2;
                break;
            }
        }
    }

    public void setGPSFloorLayerInternal(String string) {
        if (string != null) {
            for (n n2 : this.j.C.f) {
                if (!n2.a.equals(string)) continue;
                this.j.x = n2;
                break;
            }
        }
    }

    private void a(final String string, final OnFinishCallback onFinishCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(G.getFilesDir(), "SAILSMap/" + string);
                    if (!file.exists()) {
                        if (onFinishCallback != null) {
                            onFinishCallback.onFailed("no internet and no cache file!");
                        }
                        return;
                    }
                    SAILS.this.a(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (onFinishCallback != null) {
                        onFinishCallback.onFailed(exception.toString());
                    }
                    return;
                }
                if (onFinishCallback != null) {
                    onFinishCallback.onSuccess("cache file loaded");
                }
            }
        }).start();
    }

    private static String a(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append("\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    private static String c(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            String string = SAILS.a(fileInputStream);
            fileInputStream.close();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean b(String string, File file) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public void loadCloudBuilding(String string, final String string2, final OnFinishCallback onFinishCallback) {
        this.clearFloorDetermineData();
        this.b();
        if (!this.e()) {
            this.a(string2, onFinishCallback);
            return;
        }
        final SharedPreferences sharedPreferences = G.getSharedPreferences(this.L, 0);
        this.K.a(string);
        final boolean bl = sharedPreferences.getBoolean(string2, false);
        if (bl) {
            this.K.a(5000, 5000);
        }
        this.K.a(string2, new OnFinishCallback(){

            @Override
            public void onSuccess(String string) {
                String string22 = SAILS.c(new File(G.getFilesDir(), "SAILSMap/" + string2 + ".ver"));
                if (string22.equals(((SAILS)SAILS.this).K.b.j + "\n")) {
                    SAILS.this.a(string2, onFinishCallback);
                    return;
                }
                SAILS.this.K.b(new OnFinishCallback(){

                    @Override
                    public void onSuccess(String string) {
                        SAILS.a(((SAILS)SAILS.this).K.c, string2);
                        try {
                            SAILS.this.a(new File(G.getFilesDir(), "SAILSMap/" + string2 + "/"));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            if (onFinishCallback != null) {
                                onFinishCallback.onFailed(iOException.toString());
                            }
                            return;
                        }
                        catch (XmlPullParserException xmlPullParserException) {
                            xmlPullParserException.printStackTrace();
                            if (onFinishCallback != null) {
                                onFinishCallback.onFailed(xmlPullParserException.toString());
                            }
                            return;
                        }
                        SAILS.b(((SAILS)SAILS.this).K.b.j, new File(G.getFilesDir(), "SAILSMap/" + string2 + ".ver"));
                        sharedPreferences.edit().putBoolean(string2, true).commit();
                        if (onFinishCallback != null) {
                            onFinishCallback.onSuccess("");
                        }
                    }

                    @Override
                    public void onFailed(String string) {
                        if (onFinishCallback != null) {
                            onFinishCallback.onFailed(string);
                        }
                    }
                });
            }

            @Override
            public void onFailed(String string) {
                if (bl) {
                    SAILS.this.a(string2, onFinishCallback);
                    return;
                }
                if (onFinishCallback != null) {
                    onFinishCallback.onFailed(string);
                }
            }
        });
    }

    public boolean hasCached(String string) {
        try {
            File file = new File(G.getFilesDir(), "SAILSMap/" + string);
            return file.exists();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void refreshCloudBuilding(final String string, final OnFinishCallback onFinishCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SAILS.a(((SAILS)SAILS.this).K.c, string);
                try {
                    SAILS.this.a(new File(G.getFilesDir(), "SAILSMap/" + string + "/"));
                }
                catch (IOException | XmlPullParserException throwable) {
                    throwable.printStackTrace();
                    onFinishCallback.onFailed(throwable.toString());
                    return;
                }
                SAILS.b(((SAILS)SAILS.this).K.b.j, new File(G.getFilesDir(), "SAILSMap/" + string + ".ver"));
                SharedPreferences sharedPreferences = G.getSharedPreferences(SAILS.this.L, 0);
                sharedPreferences.edit().putBoolean(string, true).apply();
                onFinishCallback.onSuccess("");
            }
        }).start();
    }

    public void clearFloorDetermineData() {
        com.sails.engine.b.a(this);
    }

    public void cancelLoadingBuilding() {
        this.K.d = true;
    }

    public void loadCloudBuilding(final String string, final String string2, final @NonNull OnLoadStatusCallback onLoadStatusCallback) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                SharedPreferences sharedPreferences;
                block8: {
                    block9: {
                        Object object;
                        while (SAILS.this.C) {
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        SAILS.this.C = true;
                        SAILS.this.clearFloorDetermineData();
                        SAILS.this.b();
                        ((SAILS)SAILS.this).K.d = false;
                        sharedPreferences = G.getSharedPreferences(SAILS.this.L, 0);
                        bl = false;
                        boolean bl2 = false;
                        if (sharedPreferences.getBoolean(string2 + " downloaded", false)) {
                            object = sharedPreferences.getString(string2 + " mapzipfile", "");
                            SAILS.a(new File((String)object), string2);
                            sharedPreferences.edit().putBoolean(string2 + " downloaded", false).apply();
                            bl2 = true;
                        }
                        try {
                            object = new File(G.getFilesDir(), "SAILSMap/" + string2);
                            if (!((File)object).exists()) break block8;
                            SAILS.this.a((File)object);
                            if (!bl2) break block9;
                            SAILS.b(sharedPreferences.getString(string2 + " mapTimestamp", ((SAILS)SAILS.this).K.b.j), new File(G.getFilesDir(), "SAILSMap/" + string2 + ".ver"));
                            sharedPreferences.edit().putBoolean(string2, true).apply();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break block8;
                        }
                    }
                    SAILS.this.C = false;
                    onLoadStatusCallback.onCacheLoaded();
                    bl = true;
                }
                if (!SAILS.this.e() && !bl) {
                    onLoadStatusCallback.onNetworkLoadingFailed("no network!");
                    SAILS.this.C = false;
                    return;
                }
                SAILS.this.K.a(string);
                boolean bl3 = sharedPreferences.getBoolean(string2, false);
                final boolean bl4 = bl;
                if (bl3) {
                    SAILS.this.K.a(5000, 5000);
                }
                SAILS.this.K.a(string2, new OnFinishCallback(){

                    @Override
                    public void onSuccess(String string) {
                        String string2 = SAILS.c(new File(G.getFilesDir(), "SAILSMap/" + string2 + ".ver"));
                        if (string2.equals(((SAILS)SAILS.this).K.b.j + "\n") && bl4) {
                            return;
                        }
                        SAILS.this.K.a(new OnLoadStatusCallback(){

                            @Override
                            public void onCacheLoaded() {
                                SAILS.this.C = false;
                            }

                            @Override
                            public void onNetworkLoadingProgress(boolean bl, int n2) {
                                if (bl) {
                                    if (!bl4) {
                                        SAILS.a(((SAILS)SAILS.this).K.c, string2);
                                        try {
                                            SAILS.this.a(new File(G.getFilesDir(), "SAILSMap/" + string2 + "/"));
                                        }
                                        catch (IOException | XmlPullParserException throwable) {
                                            throwable.printStackTrace();
                                            onLoadStatusCallback.onNetworkLoadingFailed(throwable.toString());
                                            SAILS.this.C = false;
                                            return;
                                        }
                                        SAILS.b(((SAILS)SAILS.this).K.b.j, new File(G.getFilesDir(), "SAILSMap/" + string2 + ".ver"));
                                        sharedPreferences.edit().putBoolean(string2, true).apply();
                                    } else {
                                        sharedPreferences.edit().putBoolean(string2 + " downloaded", true).apply();
                                        sharedPreferences.edit().putString(string2 + " mapzipfile", ((SAILS)SAILS.this).K.c.getPath()).apply();
                                        sharedPreferences.edit().putString(string2 + " mapTimestamp", ((SAILS)SAILS.this).K.b.j).apply();
                                    }
                                    onLoadStatusCallback.onNetworkLoadingProgress(true, 100);
                                } else {
                                    onLoadStatusCallback.onNetworkLoadingProgress(false, n2);
                                }
                                SAILS.this.C = false;
                            }

                            @Override
                            public void onNetworkLoadingFailed(String string) {
                                if (!bl4) {
                                    onLoadStatusCallback.onNetworkLoadingFailed(string);
                                }
                                SAILS.this.C = false;
                            }
                        });
                    }

                    @Override
                    public void onFailed(String string) {
                        SAILS.this.C = false;
                        if (bl4) {
                            return;
                        }
                        onLoadStatusCallback.onNetworkLoadingFailed("failed to get building info on network");
                    }
                });
            }
        });
        thread.setPriority(10);
        thread.start();
    }

    private void b() {
        if (this.m != null) {
            this.m.clearBaseMap();
        }
    }

    public void setBLEScanFailCallback(BLEScanFailCallback bLEScanFailCallback) {
        this.j.h = bLEScanFailCallback;
    }

    public boolean resetBLEProcedure(@NonNull OnResetFinishCallback onResetFinishCallback) {
        if (this.j.ac == null) {
            return false;
        }
        if (this.isLocationEngineStarted()) {
            this.stopLocatingEngine();
        }
        return this.j.ac.a(onResetFinishCallback);
    }

    @Deprecated
    public void setStepLengthFactor(double d2) {
        this.j.X.b = d2;
    }

    void a(File file) {
        int n2;
        this.H = false;
        this.j.a(file);
        this.j.b(file);
        if (this.checkMode(2048)) {
            this.setSpeedFactor(this.z);
        }
        this.j.C.h.clear();
        this.j.C.i.clear();
        for (n n3 : this.j.C.f) {
            for (z object : n3.h) {
                n2 = Collections.binarySearch(this.j.C.h, object);
                if (n2 < 0) {
                    this.j.C.h.add(-n2 - 1, object);
                }
                if (n2 <= 0 || !(this.j.C.h.get((int)n2).c < object.c)) continue;
                this.j.C.h.remove(n2);
                this.j.C.h.add(n2, object);
            }
        }
        for (n n3 : this.j.C.f) {
            for (Beacon beacon : n3.i) {
                n2 = Collections.binarySearch(this.j.C.i, beacon, new Beacon.b());
                if (n2 < 0) {
                    this.j.C.i.add(-n2 - 1, beacon);
                }
                if (n2 <= 0 || !(this.j.C.i.get((int)n2).x < beacon.x)) continue;
                this.j.C.i.remove(n2);
                this.j.C.i.add(n2, beacon);
            }
        }
        if (!this.j.C.f.isEmpty()) {
            this.j.C.e = this.j.C.f.get(0);
        }
        this.j.c();
        this.c();
        this.H = true;
    }

    public void setEnvironmentIsHighBeaconDensity(boolean bl) {
        if (bl) {
            com.sails.engine.q.l = 3.0;
            com.sails.engine.q.k = 40.0;
            if (this.checkMode(512)) {
                com.sails.engine.h.a(2.0);
                com.sails.engine.q.c = 5;
                com.sails.engine.q.e = 25;
                com.sails.engine.q.d = 30;
                com.sails.engine.q.b = 5;
                com.sails.engine.q.l = 3.0;
                com.sails.engine.q.k = 40.0;
            } else {
                com.sails.engine.h.a(10.0);
                com.sails.engine.h.b(1.5);
            }
        }
    }

    public void startLocatingEngine() {
        this.r.b(10L);
        if (this.checkMode(8192)) {
            this.j.t();
            this.j.ah = true;
            if (this.m != null) {
                this.m.b();
            }
            return;
        }
        if ((this.checkMode(2) || this.checkMode(1) || this.checkMode(8) || this.checkMode(4)) && !this.isWiFiTurnOn()) {
            WifiManager wifiManager = (WifiManager)G.getSystemService("wifi");
            wifiManager.setWifiEnabled(true);
        }
        if (this.checkMode(256) || this.checkMode(32) || this.checkMode(16) || this.checkMode(128) || this.checkMode(64)) {
            if (Build.VERSION.SDK_INT < 18) {
                Toast.makeText((Context)G, (CharSequence)"Android Version < 4.3", (int)0).show();
                return;
            }
            if (!this.isBLEAvailable()) {
                Toast.makeText((Context)G, (CharSequence)"No Bluetooth 4.0", (int)0).show();
                return;
            }
            if (!this.isBluetoothTurnOn() && this.O != null) {
                this.j.ac.c = false;
                this.O.onAlert();
                return;
            }
        }
        if (this.checkMode(2048) && this.F == null) {
            this.j.i = this.F = new GPSLocation(G);
        }
        this.j.ac.b.clear();
        this.j.t();
        this.j.ah = true;
        if (this.m != null) {
            this.m.b();
        }
    }

    private void c() {
        this.j.am.clear();
        this.j.an.clear();
        this.j.ao.clear();
        this.j.ap.clear();
        this.j.aq.clear();
        for (n n2 : this.j.C.f) {
            for (LocationRegion locationRegion : n2.n) {
                if (locationRegion.type != null && locationRegion.type.equals("lock")) {
                    this.j.am.add(locationRegion);
                    continue;
                }
                if (locationRegion.type != null && locationRegion.type.equals("lock_gps")) {
                    locationRegion.c = true;
                    this.j.am.add(locationRegion);
                    continue;
                }
                if (locationRegion.type != null && locationRegion.type.equals("plaza")) {
                    this.j.an.add(locationRegion);
                    continue;
                }
                if (locationRegion.type != null && locationRegion.type.equals("boundary")) {
                    this.j.ap.add(locationRegion);
                    continue;
                }
                if (locationRegion.type != null && locationRegion.type.equals("freedom")) {
                    this.j.ao.add(locationRegion);
                    continue;
                }
                if (locationRegion.type == null || !locationRegion.type.equals("parking")) continue;
                this.j.aq.add(locationRegion);
            }
        }
    }

    public LocationRegion getInBuildingName(double d2, double d3) {
        LocationRegion locationRegion = null;
        for (LocationRegion locationRegion2 : this.j.ap) {
            if (!locationRegion2.isInRegion(d2, d3) || locationRegion2.label == null || locationRegion2.label.length() == 0) continue;
            locationRegion = locationRegion2;
            break;
        }
        return locationRegion;
    }

    public LocationRegion isInParkingArea(double d2, double d3, String string) {
        LocationRegion locationRegion = null;
        if (this.j.aq.size() == 0) {
            return null;
        }
        for (LocationRegion locationRegion2 : this.j.aq) {
            if (!locationRegion2.isInRegion(d2, d3) || !locationRegion2.a.a.equals(string)) continue;
            locationRegion = locationRegion2;
            break;
        }
        return locationRegion;
    }

    public LocationRegion getCurrentInBuildingName() {
        if (!this.isLocationFix()) {
            return null;
        }
        return this.getInBuildingName(this.getProcessLongitude(), this.getProcessLatitude());
    }

    public void stopLocatingEngine() {
        this.r.a();
        if (this.m != null) {
            this.m.c();
        }
        this.j.u();
        if (this.checkMode(2048) && this.F != null) {
            this.F.d();
            this.F = null;
            this.j.i = null;
            this.I = false;
            this.j.c = false;
        }
    }

    public boolean isLocationEngineStarted() {
        return this.j.al;
    }

    public boolean isUseGPS() {
        return this.I;
    }

    public void setSimulationLongitude(double d2) {
        this.t = d2;
    }

    public void setSimulationLatitude(double d2) {
        this.s = d2;
    }

    public void setSimulationUserHeading(double d2) {
        this.y = d2;
    }

    public void setSimulationFloor(String string) {
        n n2 = com.sails.engine.b.m;
        for (n n3 : this.j.C.f) {
            if (!n3.a.equals(string)) continue;
            com.sails.engine.b.m = n3;
            this.j.N = n3;
            break;
        }
        if (!this.checkMode(8192)) {
            return;
        }
        if (n2 != null && n2 != com.sails.engine.b.m && this.j.as != null) {
            this.j.as.onFloorChanged(this.j.N.a);
        }
    }

    public double getLatitude() {
        if (this.checkMode(8192)) {
            return this.s;
        }
        if (!this.I || this.j.ae || this.j.j) {
            return this.j.z();
        }
        return this.F.getLatitude();
    }

    public double getLongitude() {
        if (this.checkMode(8192)) {
            return this.t;
        }
        this.d();
        if (!this.I || this.j.ae || this.j.j) {
            return this.j.y();
        }
        return this.F.getLongitude();
    }

    public double getProcessLongitude() {
        block9: {
            block11: {
                block10: {
                    if (this.i == null) break block9;
                    if (!this.i.a || !this.i.isRoutingEnable()) break block10;
                    if (this.i.s == PurePathRoutingManager.MY_LOCATION) break block11;
                }
                this.n = false;
                if (this.j.y) {
                    return this.getLongitude();
                }
                int n2 = this.i.getCurrentFloorRemainingDistance();
                if (n2 < 3 && this.i.getCurrentAllPathNodes() != null && this.i.getCurrentAllPathNodes().size() > 1) {
                    this.n = true;
                    return this.i.getCurrentAllPathNodes().get((int)0).longitude;
                }
                return this.getLongitude();
            }
            return this.w == 0.0 ? this.getLongitude() : this.w;
        }
        if (this.m == null) {
            return this.getLongitude();
        }
        if (!this.m.getRoutingManager().a || !this.m.getRoutingManager().isRoutingEnable() || this.m.getRoutingManager().u != PathRoutingManager.MY_LOCATION) {
            this.n = false;
            if (this.j.y) {
                return this.getLongitude();
            }
            int n3 = this.m.getRoutingManager().getCurrentFloorRemainingDistance();
            if (n3 < 3 && this.m.getRoutingManager().getCurrentAllPathNodes() != null && this.m.getRoutingManager().getCurrentAllPathNodes().size() > 1) {
                this.n = true;
                return this.m.getRoutingManager().getCurrentAllPathNodes().get((int)0).longitude;
            }
            return this.getLongitude();
        }
        return this.w == 0.0 ? this.getLongitude() : this.w;
    }

    public double getProcessLatitude() {
        block9: {
            block11: {
                block10: {
                    if (this.i == null) break block9;
                    if (!this.i.a || !this.i.isRoutingEnable()) break block10;
                    if (this.i.s == PurePathRoutingManager.MY_LOCATION) break block11;
                }
                if (this.j.y) {
                    return this.getLatitude();
                }
                int n2 = this.i.getCurrentFloorRemainingDistance();
                if (n2 < 3 && this.i.getCurrentAllPathNodes() != null && this.i.getCurrentAllPathNodes().size() > 1) {
                    return this.i.getCurrentAllPathNodes().get((int)0).latitude;
                }
                return this.getLatitude();
            }
            return this.u == 0.0 ? this.getLatitude() : this.u;
        }
        if (this.m == null) {
            return this.getLatitude();
        }
        if (!this.m.getRoutingManager().a || !this.m.getRoutingManager().isRoutingEnable() || this.m.getRoutingManager().u != PathRoutingManager.MY_LOCATION) {
            if (this.j.y) {
                return this.getLatitude();
            }
            int n3 = this.m.getRoutingManager().getCurrentFloorRemainingDistance();
            if (n3 < 3 && this.m.getRoutingManager().getCurrentAllPathNodes() != null && this.m.getRoutingManager().getCurrentAllPathNodes().size() > 1) {
                return this.m.getRoutingManager().getCurrentAllPathNodes().get((int)0).latitude;
            }
            return this.getLatitude();
        }
        return this.u == 0.0 ? this.getLatitude() : this.u;
    }

    private void d() {
        if (!this.checkMode(2048)) {
            return;
        }
        if (this.F == null) {
            this.j.i = this.F = new GPSLocation(G);
        }
        if (System.currentTimeMillis() - this.B < 500L) {
            return;
        }
        this.B = System.currentTimeMillis();
        if ((this.checkMode(32) || this.checkMode(16)) && this.checkMode(2048)) {
            if (com.sails.engine.b.c() && !this.I) {
                this.F.b();
                this.o = this.F.isAvaliable() && this.F.getAccuracy() <= (double)this.F.b ? ++this.o : 0;
                boolean bl = false;
                if (this.j.ae) {
                    if (this.o > 5 || Double.isNaN(this.getLatitude())) {
                        bl = true;
                    }
                } else if (this.o > 3 || Double.isNaN(this.getLatitude())) {
                    bl = true;
                }
                if (bl) {
                    this.I = true;
                    this.j.c = true;
                    this.j.Z.f();
                }
            } else if (!com.sails.engine.b.c()) {
                this.o = 0;
                this.F.d();
                if (this.I) {
                    this.recalculatePosition();
                    this.I = false;
                    this.j.c = false;
                    this.j.Z.f();
                }
            }
        }
    }

    public void setGPSOffset(GeoPoint geoPoint) {
        this.j.i.setOffset(geoPoint);
    }

    public void recalculatePosition() {
        this.j.aa.d();
    }

    public double getAccuracy() {
        if (!this.showAccuracy) {
            return 0.01;
        }
        if (this.checkMode(8192)) {
            return 0.01;
        }
        if (!this.I || this.F == null) {
            return this.j.Z.c();
        }
        return this.F.getAccuracy();
    }

    public boolean isHeadingAvailable() {
        if (this.checkMode(8192)) {
            return true;
        }
        return this.j.ag;
    }

    public String getFloor() {
        if (this.checkMode(8192) && com.sails.engine.b.m != null) {
            return com.sails.engine.b.m.a;
        }
        if (this.j.a(8) || this.j.a(4) || this.j.a(2) || this.j.a(1)) {
            if (this.j.e() != null && this.j.e().a && this.j.e().b != null) {
                return this.j.e().b.a;
            }
        } else if (this.j.a(256) || this.j.a(32) || this.j.a(16) || this.j.a(128) || this.j.a(64)) {
            if (this.I && this.F != null && this.F.isAvaliable() && this.j.x != null) {
                return this.j.x.a;
            }
            if (this.j.f() != null && this.j.f().a && this.j.f().b != null) {
                return this.j.f().b.a;
            }
        }
        return "";
    }

    public int getFloorNumber() {
        if (this.checkMode(8192)) {
            return com.sails.engine.b.m != null ? com.sails.engine.b.m.b : Integer.MAX_VALUE;
        }
        if (this.j.a(8) || this.j.a(4) || this.j.a(2) || this.j.a(1)) {
            if (this.j.e() != null && this.j.e().a && this.j.e().b != null) {
                return this.j.e().b.b;
            }
        } else if (this.j.a(256) || this.j.a(32) || this.j.a(16) || this.j.a(128) || this.j.a(64)) {
            if (this.I && this.F != null && this.F.isAvaliable() && this.j.x != null) {
                return this.j.x.b;
            }
            if (this.j.f() != null && this.j.f().a && this.j.f().b != null) {
                return this.j.f().b.b;
            }
        }
        return Integer.MAX_VALUE;
    }

    public String getFloorEntireName(String string) {
        if (this.checkMode(8192) && com.sails.engine.b.m != null) {
            return com.sails.engine.c.a(com.sails.engine.b.m.b) + " " + com.sails.engine.b.m.c;
        }
        n n2 = this.c(string);
        if (n2 != null) {
            return com.sails.engine.c.a(n2.b) + " " + n2.c;
        }
        return null;
    }

    public String getFloorDescription(String string) {
        if (this.checkMode(8192) && com.sails.engine.b.m != null) {
            return com.sails.engine.b.m.c;
        }
        n n2 = this.c(string);
        if (n2 != null) {
            return n2.c;
        }
        return null;
    }

    public boolean hasGyro() {
        SensorManager sensorManager = (SensorManager)G.getSystemService("sensor");
        List list = sensorManager.getSensorList(-1);
        for (Sensor sensor : list) {
            if (sensor.getType() != 4) continue;
            return true;
        }
        return false;
    }

    private boolean e() {
        if (G == null) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)G.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    public List<String> getLocationRegionTypeList(String string) {
        n n2 = this.c(string);
        if (n2 != null) {
            return n2.m;
        }
        return null;
    }

    public List<LocationRegion> getLocationRegionList(String string) {
        n n2 = this.c(string);
        if (n2 != null) {
            return n2.n;
        }
        return null;
    }

    public LocationRegion getLocationRegionByUUID(String string) {
        return this.j.C.s.get(string);
    }

    public List<LocationRegion> getFilteredLocationRegionList(String string, String string2, String string3) {
        if (string2 == null) {
            return null;
        }
        n n2 = this.c(string);
        ArrayList<LocationRegion> arrayList = new ArrayList<LocationRegion>();
        if (n2 != null) {
            if (string2.equals("facility")) {
                if (string3 == null) {
                    return n2.q;
                }
                for (LocationRegion locationRegion : n2.q) {
                    if (locationRegion.subtype == null || !locationRegion.subtype.equals(string3)) continue;
                    arrayList.add(locationRegion);
                }
                return arrayList;
            }
            if (string2.equals("building")) {
                if (string3 == null) {
                    return n2.p;
                }
                for (LocationRegion locationRegion : n2.p) {
                    if (locationRegion.subtype == null || !locationRegion.subtype.equals(string3)) continue;
                    arrayList.add(locationRegion);
                }
                return arrayList;
            }
            if (string2.equals("store")) {
                if (string3 == null) {
                    return n2.r;
                }
                for (LocationRegion locationRegion : n2.r) {
                    if (locationRegion.subtype == null || !locationRegion.subtype.equals(string3)) continue;
                    arrayList.add(locationRegion);
                }
                return arrayList;
            }
            if (string2.equals("gateway")) {
                if (string3 == null) {
                    return n2.t;
                }
                for (LocationRegion locationRegion : n2.t) {
                    if (locationRegion.subtype == null || !locationRegion.subtype.equals(string3)) continue;
                    arrayList.add(locationRegion);
                }
                return arrayList;
            }
            if (string2.equals("transfer")) {
                if (string3 == null) {
                    return n2.s;
                }
                for (LocationRegion locationRegion : n2.s) {
                    if (locationRegion.subtype == null || !locationRegion.subtype.equals(string3)) continue;
                    arrayList.add(locationRegion);
                }
                return arrayList;
            }
            return null;
        }
        return null;
    }

    public boolean amIHere(LocationRegion locationRegion) {
        return locationRegion.isInRegion(this.getLongitude(), this.getLatitude());
    }

    public void setOnBLEScanListener(OnBLEScanCallback onBLEScanCallback) {
        this.j.ac.a(onBLEScanCallback);
    }

    public void setOnLocationChangeEventListener(OnLocationChangeEventListener onLocationChangeEventListener) {
        this.j.aU = onLocationChangeEventListener;
    }

    public void setOnBTLEPushEventListener(OnBTLEPushEventListener onBTLEPushEventListener) {
        this.j.ar = onBTLEPushEventListener;
    }

    public void setOnFloorChangeListener(OnFloorChangeListener onFloorChangeListener) {
        this.j.as = onFloorChangeListener;
    }

    public boolean isInThisBuilding() {
        if (this.checkMode(8192)) {
            return true;
        }
        if (this.j.a(8) || this.j.a(4) || this.j.a(2) || this.j.a(1)) {
            if (this.j.e() != null) {
                return this.j.e().a;
            }
        } else if (this.j.a(256) || this.j.a(32) || this.j.a(16) || this.j.a(128) || this.j.a(64)) {
            if (this.j.c) {
                double d2 = this.getLongitude();
                double d3 = this.getLatitude();
                return !Double.isNaN(d2) && !Double.isNaN(d3) && this.m != null && this.m.isInMap(new GeoPoint(d3, d2));
            }
            if (this.j.f() != null) {
                return this.j.f().a;
            }
        }
        return false;
    }

    public boolean isLocationFix() {
        if (this.checkMode(8192)) {
            return true;
        }
        if (this.getFloor() == null) {
            return false;
        }
        if (Double.isNaN(this.getLongitude()) || Double.isNaN(this.getLatitude())) {
            return false;
        }
        if (this.I) {
            return true;
        }
        return !this.getFloor().equals("");
    }

    public void setOnBLEPositionInitialzeCallback(long l2, OnBLEPositionInitializeCallback onBLEPositionInitializeCallback) {
        this.j.ay = true;
        this.j.aA = l2;
        this.j.ax = onBLEPositionInitializeCallback;
    }

    public void setOnBTDisableAlertCallback(OnBTDisableAlertCallback onBTDisableAlertCallback) {
        this.O = onBTDisableAlertCallback;
    }

    public void setMagneticDefaultInclinationAngle(float f2) {
        com.sails.engine.w.i = f2;
    }

    public boolean isMagneticInterfered() {
        if (this.isLocationEngineStarted()) {
            return this.j.aa.a();
        }
        return false;
    }

    public List<HashMap<String, Object>> getBLEBeaconList() {
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        if (this.j.C == null) {
            return arrayList;
        }
        for (Beacon beacon : this.j.C.l) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("lon", beacon.i);
            hashMap.put("lat", beacon.j);
            hashMap.put("floor", beacon.getFloorName());
            hashMap.put("mac", beacon.n);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public List<HashMap<String, Object>> getBeaconPatrollingList() {
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        ArrayList<Beacon> arrayList2 = new ArrayList<Beacon>(this.j.ac.b);
        if (this.j.ac == null) {
            return arrayList;
        }
        if (this.j.ac.b == null) {
            return arrayList;
        }
        for (Beacon beacon : arrayList2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("mac", beacon.n);
            if (beacon.isIbeacon()) {
                hashMap.put("mac", beacon.t.b);
                hashMap.put("battery", beacon.t.h);
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public void clearBeaconPatrollingList() {
        this.j.ac.b.clear();
    }

    public List<HashMap<String, Object>> getFingerPrintLists() {
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        if (this.j.C == null) {
            return arrayList;
        }
        for (n n2 : this.j.C.f) {
            for (List<i> list : n2.j) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("start_lon", list.get((int)0).f);
                hashMap.put("start_lat", list.get((int)0).g);
                hashMap.put("end_lon", list.get((int)(list.size() - 1)).f);
                hashMap.put("end_lat", list.get((int)(list.size() - 1)).g);
                hashMap.put("floor", n2.a);
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    private void a(final int n2, final OnFinishCallback onFinishCallback) {
        try {
            this.j.C.f.get(n2).a(new Handler(){

                public void handleMessage(Message message) {
                    if (n2 == 0) {
                        onFinishCallback.onSuccess("");
                        return;
                    }
                    SAILS.this.a(n2 - 1, onFinishCallback);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            onFinishCallback.onFailed("load floor failed");
        }
    }

    public void loadAllRssFingerPrint(OnFinishCallback onFinishCallback) {
        if (this.j.C == null) {
            return;
        }
        this.a(this.j.C.f.size() - 1, onFinishCallback);
    }

    public void setGPSThresholdParameter(int n2, int n3, int n4) {
        com.sails.engine.b.a(n2, n3, n4);
    }

    public void LSPLoad(List<SensorElement> list) {
        this.q.a(list);
        this.q.a(this.P);
    }

    public void forceDeadnocking(boolean bl) {
        this.j.j = bl;
    }

    public boolean LSPPlay() {
        if (this.q.c()) {
            this.p = true;
            this.j.aT = true;
            this.j.i.d = true;
            return true;
        }
        return false;
    }

    public void LSPStop() {
        this.q.b();
        this.p = false;
        this.j.aT = false;
        this.j.i.d = false;
        this.j.Z.a();
    }

    public void LSPPause() {
        this.q.a();
    }

    public void LSPSetListener(LocationSignalPlayerListener locationSignalPlayerListener) {
        this.q.a(locationSignalPlayerListener);
    }

    public void LSPSetPercentage(float f2) {
        this.q.a(f2);
    }

    public LocationData calculateBackgroundLocation(List<SensorElement.Beacon> list) {
        ArrayList<v> arrayList = new ArrayList<v>();
        for (SensorElement.Beacon beacon : list) {
            Beacon beacon2 = new Beacon();
            beacon2.l = beacon.id_btle;
            v v2 = new v(beacon2);
            v2.b(beacon.rssi);
            v2.d();
            arrayList.add(v2);
        }
        return this.j.g(arrayList);
    }

    public String getServiceTermsCHT() {
        String string = "\u300ciMap\u300d\u670d\u52d9\u689d\u6b3e\n\u4e0a\u6b21\u4fee\u6539\u65e5\u671f\uff1a2014 \u5e74 1 \u6708 25 \u65e5\n\u60a8\u82e5\u4e0b\u8f09\u3001\u5b89\u88dd\u6216\u4f7f\u7528 \u300ciMap\u300d\u7cfb\u5217\u8edf\u9ad4\u3001\u5b58\u53d6\u6216\u4f7f\u7528 \u300ciMap\u300d\u670d\u52d9(\u4ee5\u4e0b\u7d71\u7a31\u300c\u7522\u54c1\u300d\u548c\u300c \u670d\u52d9\u300d)\uff0c\u6216\u662f\u5b58\u53d6\u6216\u4f7f\u7528\u300c\u7522\u54c1\u300d\u6240\u63d0\u4f9b\u7684\u4efb\u4f55\u5167\u5bb9\uff0c\u5373\u8868\u793a\u60a8\u540c\u610f\u63a5\u53d7\u672c\u670d\u52d9\u689d\u6b3e(\u4ee5\u4e0b\u7c21\u7a31\u300c \u689d\u6b3e\u300d)\u7d04\u675f\uff1a\u8acb\u5148\u8a73\u95b1\u672c\u6587\u4ef6\uff0c\u518d\u7e7c\u7e8c\u4e0b\u4e00\u6b65\uff1b\u6b64\u6587\u4ef6\u69cb\u6210\u60a8\u8207 SAILS \u4e4b\u9593\u7684\u7d04\u675f\u5354\u8b70\u3002\n\u60a8\u82e5\u4e0b\u8f09\u3001\u5b58\u53d6\u6216\u4f7f\u7528\u300c\u7522\u54c1\u300d\uff0c\u5373\u8868\u793a\u60a8\u4ea6\u540c\u610f\u672c\u689d\u6b3e\u3002\n1. \u300c\u7522\u54c1\u300d\u7684\u4f7f\u7528\u3002SAILS \u6388\u4e88\u60a8\u975e\u5c08\u5c6c\u4e14\u4e0d\u5f97\u8f49\u8b93\u7684\u6388\u6b0a\uff0c\u8b93\u60a8\u5b58\u53d6 \u300ciMap\u300d\u8edf\u9ad4\u8207\u670d\u52d9\uff0c\u4e26\u53ef\u4f9d\u64da\u300c\u689d\u6b3e\u300d\u898f\u5b9a\u5b58\u53d6\u300c\u7522\u54c1\u300d\u7684\u300c\u5167\u5bb9\u300d(\u5b9a\u7fa9\u5982\u4e0b)\u3002\n2. \u4f7f\u7528\u9650\u5236\u3002\u9664\u975e\u60a8\u4e8b\u5148\u7372\u5f97 SAILS \u7684\u66f8\u9762\u6388\u6b0a (\u5728\u9069\u7528\u60c5\u6cc1\u4e0b\uff0c\u53ef\u6539\u7531\u7279\u5b9a\u300c\u5167\u5bb9\u300d\u63d0\u4f9b\u8005\u6388\u6b0a)\uff0c\u5426\u5247\u4e0d\u5f97\u5f9e\u4e8b\u4e0b\u5217\u884c\u70ba\uff1a(a) \u8907\u88fd\u3001\u7ffb\u8b6f\u3001\u4fee\u6539\u300c\u5167\u5bb9\u300d\u6216\u5176\u4efb\u4f55\u90e8\u5206\uff0c\u6216\u88fd\u4f5c\u76f8\u95dc\u884d\u751f\u4f5c\u54c1\uff1b(b) \u91cd\u65b0\u6563\u4f48\u3001\u8f49\u6388\u6b0a\u3001\u51fa\u79df\u3001\u767c\u4f48\u3001\u92b7\u552e\u3001\u8f49\u8b93\u3001\u4ee5\u5408\u7d04\u51fa\u79df\u3001\u63a8\u92b7\u3001\u8f49\u79fb\uff0c\u6216\u4ee5\u5176\u4ed6\u4efb\u4f55\u65b9\u5f0f\u63d0\u4f9b\u7b2c\u4e09\u65b9\u4f7f\u7528\u300c\u7522\u54c1\u300d\u6216\u300c\u5167\u5bb9\u300d\uff1b(c) \u5c0d\u300c\u670d\u52d9\u300d\u6216\u5176\u4efb\u4f55\u90e8\u5206\u9032\u884c\u9006\u5411\u5de5\u7a0b\u3001\u53cd\u8b6f\u6216\u5617\u8a66\u64f7\u53d6\u539f\u59cb\u7a0b\u5f0f\u78bc (\u9664\u975e\u7d93\u9069\u7528\u6cd5\u5f8b\u7684\u660e\u78ba\u8a31\u53ef\u6216\u8981\u6c42)\uff1b(d) \u4f7f\u7528\u300c\u7522\u54c1\u300d\u6642\uff0c\u8b93\u60a8\u6216\u4efb\u4f55\u4eba\u5f97\u4ee5\u5927\u91cf\u4e0b\u8f09\u6216\u5927\u91cf\u63d0\u4f9b\u4efb\u4f55\u300c\u5167\u5bb9\u300d\uff0c\u5305\u62ec\u4f46\u4e0d\u9650\u65bc\u6578\u5b57\u7d93\u7def\u5ea6\u5ea7\u6a19\u3001\u5716\u50cf\u53ca\u53ef\u986f\u793a\u7684\u5730\u5716\u8cc7\u6599\uff1b(e) \u522a\u9664\u3001\u96b1\u85cf\u6216\u4ee5\u4efb\u4f55\u65b9\u5f0f\u4fee\u6539\u4efb\u4f55\u51fa\u73fe\u5728\u300c\u7522\u54c1\u300d\u6216\u300c\u5167\u5bb9\u300d\u4e2d\u7684\u8b66\u544a\u6216\u9023\u7d50\uff1b\u6216 (f) \u5c07\u300c\u670d\u52d9\u300d\u6216\u300c\u5167\u5bb9\u300d\u914d\u642d\u4efb\u4f55\u4e0b\u5217\u88dd\u7f6e\u5c08\u7528\u6216\u76f8\u95dc\u7684\u7522\u54c1\u3001\u7cfb\u7d71\u6216\u61c9\u7528\u7a0b\u5f0f\u4f7f\u7528\uff1a(i) \u5373\u6642\u5c0e\u822a\u6216\u8def\u7dda\u5c0e\u5f15\uff0c\u5305\u62ec\u4f46\u4e0d\u9650\u65bc\u8207\u4f7f\u7528\u8005\u611f\u61c9\u88dd\u7f6e\u9032\u884c\u540c\u6b65\u5b9a\u4f4d\u7684\u8def\u53e3\u5c0e\u822a\u63d0\u793a\uff1b\u6216 (g) \u4f7f\u7528\u300c\u7522\u54c1\u300d\u5efa\u7acb\u5730\u65b9\u8cc7\u8a0a\u6216\u5176\u4ed6\u672c\u5730\u5546\u5bb6\u8cc7\u8a0a\u7684\u8cc7\u6599\u5eab\u3002\n3. \u9069\u7576\u884c\u70ba\uff1b\u9075\u5b88\u6cd5\u5f8b\u8207 SAILS \u653f\u7b56\u3002\u60a8\u540c\u610f\u5c0d\u300c\u7522\u54c1\u300d\u4f7f\u7528\u671f\u9593\u7684\u500b\u4eba\u884c\u70ba\u548c\u5167\u5bb9\u8ca0\u8cac\uff0c\u4e26\u627f\u64d4\u6240\u6709\u76f8\u95dc\u5f8c\u679c\u3002\u60a8\u540c\u610f\u53ea\u5c07\u300c\u7522\u54c1\u300d\u7528\u65bc\u5408\u6cd5\u53ca\u6b63\u7576\u76ee\u7684\uff0c\u4e26\u9075\u5b88\u300c\u689d\u6b3e\u300d\u53ca\u4efb\u4f55 SAILS \u63d0\u4f9b\u7684\u9069\u7528\u653f\u7b56\u6216\u6307\u5357\u3002\u8209\u4f8b\u4f86\u8aaa\uff0c\u60a8\u540c\u610f\u4e0d\u6703\u5728\u300c\u670d\u52d9\u300d\u4f7f\u7528\u671f\u9593\u5f9e\u4e8b\u4e0b\u5217\u884c\u70ba (\u4e0b\u5217\u7bc4\u4f8b\u4e26\u672a\u6db5\u84cb\u6240\u6709\u9055\u53cd\u898f\u5b9a\u7684\u4f7f\u7528\u65b9\u5f0f)\uff1a(a) \u8ab9\u8b17\u3001\u6feb\u7528\u3001\u9a37\u64fe\u3001\u8ddf\u8e64\u3001\u5a01\u8105\u6216\u4ee5\u5176\u4ed6\u65b9\u5f0f\u9055\u53cd\u4ed6\u4eba\u6cd5\u5f8b\u6b0a\u5229 (\u4f8b\u5982\u96b1\u79c1\u6b0a\u548c\u516c\u958b\u6b0a)\uff1b(b) \u4e0a\u50b3\u3001\u5f35\u8cbc\u3001\u4ee5\u96fb\u5b50\u90f5\u4ef6\u5bc4\u9001\u3001\u6563\u4f48\uff0c\u6216\u4ee5\u4efb\u4f55\u5176\u4ed6\u65b9\u5f0f\u63d0\u4f9b\u4efb\u4f55\u4e0d\u7576\u3001\u8ab9\u8b17\u3001\u7325\u893b\u6216\u975e\u6cd5\u5167\u5bb9\uff1b(c) \u4e0a\u50b3\u3001\u5f35\u8cbc\u3001\u6563\u4f48\u6216\u4ee5\u4efb\u4f55\u5176\u4ed6\u65b9\u5f0f\u63d0\u4f9b\u4fb5\u5bb3\u4efb\u4f55\u4e00\u65b9\u4e4b\u5c08\u5229\u6b0a\u3001\u5546\u6a19\u3001\u7248\u6b0a\u3001\u5546\u696d\u6a5f\u5bc6\u6216\u5176\u4ed6\u5c08\u5c6c\u6b0a\u5229\u7684\u5167\u5bb9 (\u9664\u975e\u8cb4\u7528\u6236\u70ba\u6b64\u6b0a\u5229\u4e4b\u64c1\u6709\u8005\u3001\u5df2\u5411\u76f8\u95dc\u64c1\u6709\u8005\u53d6\u5f97\u8a31\u53ef\uff0c\u6216\u6709\u5176\u4ed6\u6cd5\u5f8b\u4f9d\u64da\u53ef\u4f7f\u7528\u6b64\u985e\u5167\u5bb9)\uff1b(d) \u4e0a\u50b3\u3001\u5f35\u8cbc\u3001\u4ee5\u96fb\u5b50\u90f5\u4ef6\u5bc4\u9001\u3001\u6563\u4f48\u6216\u4ee5\u4efb\u4f55\u5176\u4ed6\u65b9\u5f0f\u5ba3\u50b3\u5c64\u58d3\u5f0f\u884c\u92b7\u3001\u63d0\u4f9b\u9023\u9396\u4fe1\u6216\u7834\u58de\u6027\u7684\u5546\u696d\u8a0a\u606f\u6216\u5ee3\u544a\uff1b(e) \u4e0a\u50b3\u3001\u5f35\u8cbc\u3001\u4ee5\u96fb\u5b50\u90f5\u4ef6\u5bc4\u9001\u3001\u6563\u4f48\u6216\u4ee5\u4efb\u4f55\u5176\u4ed6\u65b9\u5f0f\u63d0\u4f9b\u4efb\u4f55\u9069\u7528\u6cd5\u5f8b\u3001\u300c\u689d\u6b3e\u300d\u6216\u4efb\u4f55\u9069\u7528\u4e4b\u300c\u7522\u54c1\u300d\u653f\u7b56\u6216\u6307\u5f15\u7981\u6b62\u7684\u5176\u4ed6\u5167\u5bb9\u3001\u8a0a\u606f\u6216\u901a\u8a0a\u3002(f) \u4e0b\u8f09\u8cb4\u7528\u6236\u77e5\u6089\u6216\u7406\u61c9\u77e5\u6089\u70ba\u4ed6\u4eba\u975e\u6cd5\u6563\u4f48\u4e4b\u6a94\u6848\uff1b(g) \u5047\u5192\u4ed6\u4eba\u6216\u5be6\u9ad4\uff0c\u6216\u662f\u7ac4\u6539\u6216\u522a\u9664\u300c\u5167\u5bb9\u300d\u3001\u8edf\u9ad4\u6216\u5176\u4ed6\u8cc7\u6599\u51fa\u8655\u6216\u4f86\u6e90\u7684\u4f5c\u8005\u8cc7\u8a0a\u3001\u5c08\u5c6c\u8a2d\u8a08\u6216\u6a19\u7c64\uff1b(h) \u9650\u5236\u6216\u963b\u6b62\u5176\u4ed6\u4f7f\u7528\u8005\u4f7f\u7528\u53ca\u4eab\u6709\u300c\u7522\u54c1\u300d\u6216 SAILS \u670d\u52d9\uff1b(i) \u4f7f\u7528\u4efb\u4f55\u6f2b\u904a\u5668\u3001\u81ea\u52d5\u5c0b\u6aa2\u7a0b\u5f0f\u3001\u7db2\u7ad9\u641c\u5c0b/\u64f7\u53d6\u61c9\u7528\u7a0b\u5f0f\u6216\u5176\u4ed6\u88dd\u7f6e\uff0c\u5c0d SAILS \u670d\u52d9\u6216\u300c\u5167\u5bb9\u300d\u4e4b\u4efb\u4f55\u90e8\u5206\u9032\u884c\u64f7\u53d6\u6216\u5efa\u7acb\u7d22\u5f15\uff0c\u6216\u8490\u96c6\u4f7f\u7528\u8005\u8cc7\u8a0a\u4e26\u7528\u65bc\u4efb\u4f55\u672a\u7d93\u6388\u6b0a\u7684\u7528\u9014\uff1b(j) \u5728\u63d0\u4ea4\u5167\u5bb9\u4e2d\u8aa4\u5c0e\u6216\u6697\u793a SAILS \u8d0a\u52a9\u6216\u8a8d\u53ef\u8a72\u7b49\u5167\u5bb9\uff1b(k) \u4ee5\u81ea\u52d5\u65b9\u5f0f\u6216\u4ee5\u507d\u88dd\u6216\u8a50\u6b3a\u65b9\u6cd5\u5efa\u7acb\u4f7f\u7528\u8005\u5e33\u6236\uff1b(l) \u5ba3\u50b3\u975e\u6cd5\u6d3b\u52d5\uff0c\u6216\u63d0\u4f9b\u76f8\u95dc\u6307\u5f15\uff1b(m) \u9f13\u52f5\u91dd\u5c0d\u4efb\u4f55\u5718\u9ad4\u6216\u500b\u4eba\u7684\u4eba\u8eab\u50b7\u5bb3\uff1b\u6216 (n) \u6563\u4f48\u75c5\u6bd2\u3001\u7db2\u8def\u8815\u87f2\u3001\u7455\u75b5\u3001\u6728\u99ac\u7a0b\u5f0f\u6216\u4efb\u4f55\u5177\u7834\u58de\u529b\u7684\u9805\u76ee\u3002\n4. \u300c\u7522\u54c1\u300d\u7684\u5167\u5bb9\u3002 \u300ciMap\u300d\u548c\u53ef\u8b93\u60a8\u5b58\u53d6\u53ca\u67e5\u770b\u5404\u7a2e\u5167\u5bb9\uff0c\u5305\u62ec\u4f46\u4e0d\u9650\u65bc\u651d\u5f71\u5716\u50cf\u3001\u5730\u5716\u3001\u5546\u5bb6\u8cc7\u8a0a\u3001\u8a55\u8ad6\u3001\u4ea4\u901a\uff0c\u4ee5\u53ca\u7531 SAILS\u3001\u5176\u6388\u6b0a\u8005\u548c\u4f7f\u7528\u8005\u6240\u63d0\u4f9b\u7684\u5176\u4ed6\u76f8\u95dc\u8cc7\u8a0a (\u4ee5\u4e0b\u7d71\u7a31\u300c\u5167\u5bb9\u300d)\u3002\u6b64\u5916\uff0c\u60a8\u53ef\u4ee5\u9078\u64c7\u5b58\u53d6\u5176\u4ed6\u7b2c\u4e09\u65b9\u900f\u904e SAILS \u670d\u52d9 (\u4f8b\u5982 SAILS \u5c0f\u5de5\u5177) \u5728\u300c\u7522\u54c1\u300d\u4e2d\u6240\u63d0\u4f9b\u7684\u5167\u5bb9\u3002\u60a8\u77ad\u89e3\u4e26\u540c\u610f\u4ee5\u4e0b\u898f\u5b9a\uff1a(a) \u5730\u5716\u8cc7\u6599\u3001\u8def\u7dda\u548c\u76f8\u95dc\u300c\u5167\u5bb9\u300d\u53ea\u4f9b\u8a08\u5283\u4e4b\u7528\u3002\u5929\u5019\u72c0\u6cc1\u3001\u65bd\u5de5\u5340\u57df\u3001\u9053\u8def\u5c01\u9589\u6216\u5176\u4ed6\u4e8b\u4ef6\uff0c\u53ef\u80fd\u5c0e\u81f4\u9053\u8def\u72c0\u6cc1\u6216\u8def\u7dda\u8207\u5730\u5716\u67e5\u8a62\u7d50\u679c\u4e0d\u540c\uff0c\u4f7f\u7528\u6b64\u300c\u5167\u5bb9\u300d\u6642\u8acb\u81ea\u884c\u4f5c\u51fa\u5224\u65b7\u3002\n6. \u64d4\u4fdd\u514d\u8cac\u8072\u660e\u8207\u8cac\u4efb\u9650\u5236\u3002(a) SAILS \u53ca\u5176\u6388\u6b0a\u8005\u5c0d\u4efb\u4f55\u5167\u5bb9\u6216\u300c\u7522\u54c1\u300d\u4e4b\u6b63\u78ba\u6027\u6216\u5b8c\u6574\u6027\u4e26\u4e0d\u63d0\u4f9b\u8072\u660e\u6216\u64d4\u4fdd\u3002\u6211\u5011\u6703\u4ee5\u5546\u696d\u4e0a\u5408\u7406\u7684\u6280\u8853\u8207\u6ce8\u610f\u7a0b\u5ea6\u63d0\u4f9b\u300c\u670d\u52d9\u300d\uff0c\u5e0c\u671b\u60a8\u6703\u76e1\u60c5\u4f7f\u7528\uff0c\u4f46SAILS \u6216\u5176\u4f9b\u61c9\u5546\u6216\u7d93\u92b7\u5546\u5747\u4e0d\u5c0d\u300c\u670d\u52d9\u300d\u505a\u51fa\u4efb\u4f55\u7279\u5b9a\u4fdd\u8b49\u3002\n\u4f8b\u5982\uff0c\u6211\u5011\u4e0d\u6703\u5c31\u300c\u670d\u52d9\u300d\u4e2d\u7684\u5167\u5bb9\u3001\u300c\u670d\u52d9\u300d\u4e4b\u7279\u5b9a\u529f\u80fd\u53ca\u5176\u53ef\u9760\u6027\u3001\u53ef\u7528\u6027\u548c\u7b26\u5408\u60a8\u7684\u9700\u6c42\u7684\u80fd\u529b\uff0c\u505a\u51fa\u4efb\u4f55\u627f\u8afe\u3002\u6211\u5011\u50c5\u4ee5\u300c\u73fe\u72c0\u300d\u63d0\u4f9b\u300c\u670d\u52d9\u300d\u3002\u90e8\u5206\u53f8\u6cd5\u7ba1\u8f44\u5340\u6703\u898f\u5b9a\u61c9\u63d0\u4f9b\u7279\u5b9a\u64d4\u4fdd\uff0c\u4f8b\u5982\u5c0d\u9069\u92b7\u6027\u3001\u7279\u6b8a\u7528\u9014\u9069\u7528\u6027\u53ca\u672a\u4fb5\u6b0a\u4e4b\u9ed8\u793a\u64d4\u4fdd\u3002\u51e1\u6cd5\u5f8b\u51c6\u8a31\u6642\uff0c\u6211\u5011\u5747\u6392\u9664\u4e00\u5207\u64d4\u4fdd\u8cac\u4efb\u3002\n (b) SAILS\u8072\u660e\u4e0d\u63d0\u4f9b\u4efb\u4f55\u8207\u300c\u5167\u5bb9\u300d\u53ca\u300c\u7522\u54c1\u300d\u76f8\u95dc\u7684\u64d4\u4fdd\uff0c\u5c0d\u4f7f\u7528\u300c\u5167\u5bb9\u300d\u6216\u300c\u7522\u54c1\u300d\u5c0e\u81f4\u7684\u4efb\u4f55\u640d\u5bb3\u6216\u640d\u5931\uff0c\u6982\u4e0d\u627f\u64d4\u4efb\u4f55\u8cac\u4efb\u3002\n";
        return string;
    }

    public boolean setLockPathEnable(boolean bl) {
        if (this.i != null) {
            this.i.a = bl;
            return true;
        }
        if (this.m == null) {
            return false;
        }
        this.m.getRoutingManager().a = bl;
        return true;
    }

    public boolean setLockPathParameter(double d2, double d3) {
        if (this.i != null) {
            this.i.b = d2;
            this.i.c = d3;
            return true;
        }
        if (this.m == null) {
            return false;
        }
        this.m.getRoutingManager().b = d2;
        this.m.getRoutingManager().c = d3;
        return true;
    }

    void a(double d2, double d3) {
        this.x = d2;
        this.v = d3;
        if (d2 == 0.0 || d3 == 0.0) {
            this.u = 0.0;
            this.w = 0.0;
        }
    }

    public void setServerURL(String string) {
        if ("ipsmap".equals("ipsmap")) {
            com.sails.engine.u.a = string;
        }
    }

    private void f() {
        List<Object> list = this.j.Z.k != null ? this.j.Z.k : new ArrayList();
        List<Object> list2 = this.j.Z.l != null ? this.j.Z.l : new ArrayList();
        double d2 = this.getLongitude();
        double d3 = this.getLatitude();
        if (this.j.c) {
            this.j.P = Double.isNaN(d2) || Double.isNaN(d3) ? SignalStatus.NO_BEACON_GPS_IN_MAP : (this.m != null && this.m.isInMap(new GeoPoint(d3, d2)) ? SignalStatus.NO_BEACON_GPS_IN_MAP : SignalStatus.NO_BEACON_GPS_OUT_MAP);
        } else if (list.size() > 0) {
            if ((Double)list2.get(0) < -85.0 || list.size() < 3 || list.size() > 1 && (Double)list2.get(1) < -90.0) {
                this.j.P = SignalStatus.WEAK_BEACON_SIGNAL;
            } else if (list.size() >= 3 && (Double)list2.get(0) > -80.0) {
                this.j.P = SignalStatus.STRONG_BEACON_SIGNAL;
            }
            if (list.size() > 1 && this.j.P != SignalStatus.WEAK_BEACON_SIGNAL && this.j.P != SignalStatus.STRONG_BEACON_SIGNAL) {
                this.j.P = SignalStatus.WEAK_BEACON_SIGNAL;
            }
        } else {
            this.j.P = SignalStatus.STATUS_UNAVAILABLE;
        }
        if (this.j.Q != null && this.E != this.j.P) {
            this.j.Q.onStatusChange(this.j.P);
            this.E = this.j.P;
        }
    }

    public int getBtleScanScore() {
        return this.j.H();
    }

    static {
        l = Float.toString(5.3f);
    }

    private static class b {
        private File a;
        private ZipInputStream b;
        private String c;
        private boolean d;

        private b() {
        }

        private void a(File file) {
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    this.a(file2);
                }
            }
            file.delete();
        }

        public String a(ZipInputStream zipInputStream, File file, boolean bl) {
            this.a = file;
            this.b = zipInputStream;
            this.a(file);
            this.a("");
            this.a(bl);
            return this.c;
        }

        public String b(ZipInputStream zipInputStream, File file, boolean bl) {
            this.a = file;
            this.b = zipInputStream;
            this.a("");
            this.b(bl);
            return this.c;
        }

        public void a(boolean bl) {
            ZipEntry zipEntry;
            while ((zipEntry = this.b.getNextEntry()) != null) {
                Closeable closeable;
                Object object;
                this.c = zipEntry.getName();
                String[] stringArray = this.c.split("/");
                if (stringArray.length > 1) {
                    object = "";
                    for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                        object = (String)object + "/";
                        object = (String)object + stringArray[i2];
                    }
                    this.a((String)object);
                }
                if (zipEntry.isDirectory()) {
                    if (bl) {
                        this.a(new File(this.a, this.c));
                    }
                    this.a(this.c);
                    continue;
                }
                object = new BufferedInputStream(this.b);
                File file = new File(this.a, this.c);
                if (bl || !file.exists()) {
                    int n2;
                    closeable = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)closeable);
                    byte[] byArray = new byte[1024];
                    while ((n2 = ((BufferedInputStream)object).read(byArray, 0, 1024)) >= 0) {
                        bufferedOutputStream.write(byArray, 0, n2);
                    }
                    bufferedOutputStream.close();
                    closeable.close();
                }
                this.b.closeEntry();
                if (!this.c.substring(this.c.lastIndexOf("/") + 1).equals("map.zip") && !this.c.substring(this.c.lastIndexOf("/") + 1).equals("btle.zip") || file.length() == 0L) continue;
                try {
                    closeable = new ZipInputStream(new FileInputStream(file));
                    new b().b((ZipInputStream)closeable, file.getParentFile(), bl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.b.close();
        }

        public void b(boolean bl) {
            ZipEntry zipEntry;
            boolean bl2 = false;
            while ((zipEntry = this.b.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    if (!bl2) {
                        this.c = zipEntry.getName();
                        bl2 = true;
                        if (bl) {
                            this.a(new File(this.a, this.c));
                        }
                    }
                    this.a(zipEntry.getName());
                    continue;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.b);
                File file = new File(this.a, zipEntry.getName());
                if (bl || !file.exists()) {
                    int n2;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    byte[] byArray = new byte[1024];
                    while ((n2 = bufferedInputStream.read(byArray, 0, 1024)) >= 0) {
                        bufferedOutputStream.write(byArray, 0, n2);
                    }
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                }
                this.b.closeEntry();
            }
            this.b.close();
        }

        private void a(String string) {
            File file = new File(this.a, string);
            if (!file.isDirectory()) {
                file.mkdirs();
            }
        }
    }

    static class d
    extends Handler {
        WeakReference<SAILS> a;
        private boolean d = false;
        static long b;
        private int e = 0;
        long c = 0L;

        public void a(long l2) {
            b = l2;
        }

        public void b(long l2) {
            this.d = true;
            b = l2;
            SAILS sAILS = (SAILS)this.a.get();
            if (sAILS != null) {
                sAILS.u = 0.0;
                sAILS.w = 0.0;
                sAILS.v = 0.0;
                sAILS.x = 0.0;
            }
            this.c(0L);
        }

        public void a() {
            this.d = false;
        }

        d(SAILS sAILS) {
            this.a = new WeakReference<SAILS>(sAILS);
        }

        private void a(SAILS sAILS) {
            if (System.currentTimeMillis() - this.c < 100L) {
                return;
            }
            this.c = System.currentTimeMillis();
        }

        private void b(SAILS sAILS) {
            double d2 = 0.95;
            if (sAILS.u == 0.0 || sAILS.w == 0.0) {
                sAILS.u = sAILS.v;
                sAILS.w = sAILS.x;
            }
            sAILS.u = d2 * sAILS.u + (1.0 - d2) * sAILS.v;
            sAILS.w = d2 * sAILS.w + (1.0 - d2) * sAILS.x;
        }

        public void handleMessage(Message message) {
            SAILS sAILS = (SAILS)this.a.get();
            if (sAILS != null) {
                if (this.e > 100) {
                    this.e = 0;
                    sAILS.f();
                }
                ++this.e;
                if (this.d) {
                    if (sAILS.m != null && sAILS.m.getRoutingManager().isRoutingEnable() && sAILS.m.getRoutingManager().a) {
                        this.b(sAILS);
                    } else if (sAILS.i != null && sAILS.i.isRoutingEnable() && sAILS.i.a) {
                        this.b(sAILS);
                    }
                    this.c(b);
                }
            }
        }

        public void c(long l2) {
            this.removeMessages(0);
            this.sendMessageDelayed(this.obtainMessage(0), l2);
        }
    }

    public static interface OnBTDisableAlertCallback {
        public void onAlert();
    }

    public static interface OnBLEPositionInitializeCallback {
        public void onStart();

        public void onFixed();

        public void onTimeOut();
    }

    public static interface OnFloorChangeListener {
        public void onFloorChanged(String var1);
    }

    public static interface OnBTLEPushEventListener {
        public void OnPush(Beacon var1);

        public void OnNothingPush();
    }

    public static interface OnLocationChangeEventListener {
        public void OnLocationChange();
    }

    public static interface OnBLEScanCallback {
        public void onLeScan(BluetoothDevice var1, int var2);
    }

    public static interface OnResetFinishCallback {
        public void onFinishReset();
    }

    public static interface BLEScanFailCallback {
        public void onScanFailCallback(int var1);
    }

    public static interface OnLoadStatusCallback {
        public void onCacheLoaded();

        public void onNetworkLoadingProgress(boolean var1, int var2);

        public void onNetworkLoadingFailed(String var1);
    }

    public static interface OnFinishCallback {
        public void onSuccess(String var1);

        public void onFailed(String var1);
    }

    static class a {
        final double a;
        final double b;
        final double c;
        final double d;

        a(double d2, double d3, double d4, double d5) {
            this.a = d2;
            this.b = d3;
            this.c = d4;
            this.d = d5;
        }
    }

    static class c {
        final double a;
        final double b;
        final int c;
        final int d;
        final String e;
        final float f;
        final float g;

        c(int n2, String string, double d2, double d3, String string2, double d4, double d5) {
            this.c = n2;
            this.d = string.equalsIgnoreCase("MN-S01") ? 1 : (string.equalsIgnoreCase("MN-P01") ? 2 : 0);
            this.a = d2;
            this.b = d3;
            this.e = string2;
            this.f = (float)d4;
            this.g = (float)d5;
        }
    }

    public static interface NeedMagneticCalibrationCallback {
        public void onNeedCalibration(int var1);

        public void onFinishCalibration();

        public void onCalibrationTiltAngleUpdated(float var1, float var2, List<Integer> var3, int var4);
    }

    public static class RoutingInfo {
        public final boolean success;
        final int a;
        int b = 0;
        public int offset = 0;
        List<GeoNode> c;
        List<GeoNode> d;

        public int getDistance() {
            return this.a;
        }

        public List<GeoNode> getPathNodes() {
            return this.c;
        }

        RoutingInfo(boolean bl, int n2) {
            this.success = bl;
            this.a = n2;
        }
    }

    public static class GeoNode {
        public final double longitude;
        public final double latitude;
        public int floornumber = -1;
        public String floorname = null;
        public String floorDesc = null;
        public LocationRegion BelongsRegion = null;

        public GeoNode(double d2, double d3) {
            this.latitude = d3;
            this.longitude = d2;
        }
    }

    public static interface SignalStatusChangeCallback {
        public void onStatusChange(SignalStatus var1);
    }

    public static enum SignalStatus {
        STRONG_BEACON_SIGNAL,
        WEAK_BEACON_SIGNAL,
        NO_BEACON_GPS_IN_MAP,
        NO_BEACON_GPS_OUT_MAP,
        STATUS_UNAVAILABLE;

    }
}

