/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.core.model;

import com.sails.engine.core.model.CoordinatesUtil;
import com.sails.engine.core.model.GeoPoint;
import java.io.Serializable;

public class BoundingBox
implements Serializable {
    private static final long a = 1L;
    public final double maxLatitude;
    public final double maxLongitude;
    public final double minLatitude;
    public final double minLongitude;

    public static BoundingBox fromString(String string) {
        double[] dArray = CoordinatesUtil.a(string, 4);
        return new BoundingBox(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public BoundingBox(double d2, double d3, double d4, double d5) {
        CoordinatesUtil.b(d2);
        CoordinatesUtil.c(d3);
        CoordinatesUtil.b(d4);
        CoordinatesUtil.c(d5);
        if (d2 > d4) {
            throw new IllegalArgumentException("invalid latitude range: " + d2 + ' ' + d4);
        }
        if (d3 > d5) {
            throw new IllegalArgumentException("invalid longitude range: " + d3 + ' ' + d5);
        }
        this.minLatitude = d2;
        this.minLongitude = d3;
        this.maxLatitude = d4;
        this.maxLongitude = d5;
    }

    public boolean contains(GeoPoint geoPoint) {
        return this.minLatitude <= geoPoint.latitude && this.maxLatitude >= geoPoint.latitude && this.minLongitude <= geoPoint.longitude && this.maxLongitude >= geoPoint.longitude;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BoundingBox)) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)object;
        if (Double.doubleToLongBits(this.maxLatitude) != Double.doubleToLongBits(boundingBox.maxLatitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxLongitude) != Double.doubleToLongBits(boundingBox.maxLongitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minLatitude) != Double.doubleToLongBits(boundingBox.minLatitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.minLongitude) == Double.doubleToLongBits(boundingBox.minLongitude);
    }

    public GeoPoint getCenterPoint() {
        double d2 = (this.maxLatitude - this.minLatitude) / 2.0;
        double d3 = (this.maxLongitude - this.minLongitude) / 2.0;
        return new GeoPoint(this.minLatitude + d2, this.minLongitude + d3);
    }

    public double getLatitudeSpan() {
        return this.maxLatitude - this.minLatitude;
    }

    public double getLongitudeSpan() {
        return this.maxLongitude - this.minLongitude;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.maxLatitude);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.maxLongitude);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.minLatitude);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.minLongitude);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        return n3;
    }

    public boolean intersects(BoundingBox boundingBox) {
        if (this == boundingBox) {
            return true;
        }
        return this.maxLatitude >= boundingBox.minLatitude && this.maxLongitude >= boundingBox.minLongitude && this.minLatitude <= boundingBox.maxLatitude && this.minLongitude <= boundingBox.maxLongitude;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("minLatitude=");
        stringBuilder.append(this.minLatitude);
        stringBuilder.append(", minLongitude=");
        stringBuilder.append(this.minLongitude);
        stringBuilder.append(", maxLatitude=");
        stringBuilder.append(this.maxLatitude);
        stringBuilder.append(", maxLongitude=");
        stringBuilder.append(this.maxLongitude);
        return stringBuilder.toString();
    }
}

