/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.location.Location;
import com.sails.engine.v;
import java.util.ArrayList;
import java.util.List;

public class SensorElement {
    public static final int TYPE_STEP = 1;
    public static final int TYPE_HEADING = 2;
    public static final int TYPE_BEACON = 3;
    public static final int TYPE_GPS = 4;
    public int type;
    public int step;
    public long timestamp;
    public double heading;
    public List<Beacon> scanResult;
    public double longitude;
    public double latitude;
    public double accuracy;
    public double speed;

    public int getType() {
        return this.type;
    }

    public SensorElement step(int n2) {
        this.type = 1;
        this.step = n2;
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public SensorElement heading(double d2) {
        this.type = 2;
        this.heading = d2;
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public SensorElement beacon(List<v> list) {
        this.type = 3;
        ArrayList<Beacon> arrayList = new ArrayList<Beacon>();
        for (v v2 : list) {
            Beacon beacon = new Beacon();
            beacon.id_btle = v2.a.l;
            beacon.rssi = v2.b();
            arrayList.add(beacon);
        }
        this.scanResult = arrayList;
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public SensorElement gps(Location location) {
        this.type = 4;
        this.longitude = location.getLongitude();
        this.latitude = location.getLatitude();
        this.accuracy = location.getAccuracy();
        this.speed = location.getSpeed();
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public static class Beacon {
        public long id_btle;
        public double rssi;
    }
}

