/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine;

import android.graphics.Point;
import com.sails.engine.MapView;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.MapPosition;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.ScreenDensity;

public class MapViewPosition {
    private double a;
    private double b;
    private final MapView c;
    private float d;

    MapViewPosition(MapView mapView) {
        this.c = mapView;
        this.a = 0.0;
        this.b = 0.0;
        this.d = 0.0f;
    }

    public synchronized BoundingBox getBoundingBox() {
        double d2 = MercatorProjection.longitudeToPixelX(this.b, this.d);
        double d3 = MercatorProjection.latitudeToPixelY(this.a, this.d);
        int n2 = this.c.getWidth() / 2;
        int n3 = this.c.getHeight() / 2;
        long l2 = MercatorProjection.getMapSize(this.d);
        double d4 = Math.max(0.0, d2 - (double)n2);
        double d5 = Math.max(0.0, d3 - (double)n3);
        double d6 = Math.min((double)l2, d2 + (double)n2);
        double d7 = Math.min((double)l2, d3 + (double)n3);
        double d8 = MercatorProjection.pixelYToLatitude(d7, this.d);
        double d9 = MercatorProjection.pixelXToLongitude(d4, this.d);
        double d10 = MercatorProjection.pixelYToLatitude(d5, this.d);
        double d11 = MercatorProjection.pixelXToLongitude(d6, this.d);
        return new BoundingBox(d8, d9, d10, d11);
    }

    public synchronized BoundingBox getBoundingBox(float f2) {
        double d2 = MercatorProjection.longitudeToPixelX(this.b, f2);
        double d3 = MercatorProjection.latitudeToPixelY(this.a, f2);
        int n2 = this.c.getWidth() / 2;
        int n3 = this.c.getHeight() / 2;
        long l2 = MercatorProjection.getMapSize(f2);
        double d4 = Math.max(0.0, d2 - (double)n2 / (double)ScreenDensity.density);
        double d5 = Math.max(0.0, d3 - (double)n3 / (double)ScreenDensity.density);
        double d6 = Math.min((double)l2, d2 + (double)n2 / (double)ScreenDensity.density);
        double d7 = Math.min((double)l2, d3 + (double)n3 / (double)ScreenDensity.density);
        double d8 = MercatorProjection.pixelYToLatitude(d7, f2);
        double d9 = MercatorProjection.pixelXToLongitude(d4, f2);
        double d10 = MercatorProjection.pixelYToLatitude(d5, f2);
        double d11 = MercatorProjection.pixelXToLongitude(d6, f2);
        return new BoundingBox(d8, d9, d10, d11);
    }

    public synchronized BoundingBox getBoundingBox(double d2, double d3, int n2, float f2) {
        double d4 = MercatorProjection.longitudeToPixelX(d3, f2);
        double d5 = MercatorProjection.latitudeToPixelY(d2, f2);
        int n3 = n2 / 2;
        int n4 = n2 / 2;
        long l2 = MercatorProjection.getMapSize(f2);
        double d6 = Math.max(0.0, d4 - (double)n3 / (double)ScreenDensity.density);
        double d7 = Math.max(0.0, d5 - (double)n4 / (double)ScreenDensity.density);
        double d8 = Math.min((double)l2, d4 + (double)n3 / (double)ScreenDensity.density);
        double d9 = Math.min((double)l2, d5 + (double)n4 / (double)ScreenDensity.density);
        double d10 = MercatorProjection.pixelYToLatitude(d9, f2);
        double d11 = MercatorProjection.pixelXToLongitude(d6, f2);
        double d12 = MercatorProjection.pixelYToLatitude(d7, f2);
        double d13 = MercatorProjection.pixelXToLongitude(d8, f2);
        return new BoundingBox(d10, d11, d12, d13);
    }

    public synchronized BoundingBox getBoundingBox(double d2, double d3, float f2) {
        double d4 = MercatorProjection.longitudeToPixelX(d3, f2);
        double d5 = MercatorProjection.latitudeToPixelY(d2, f2);
        int n2 = this.c.getWidth() / 2;
        int n3 = this.c.getHeight() / 2;
        long l2 = MercatorProjection.getMapSize(f2);
        double d6 = Math.max(0.0, d4 - (double)n2 / (double)ScreenDensity.density);
        double d7 = Math.max(0.0, d5 - (double)n3 / (double)ScreenDensity.density);
        double d8 = Math.min((double)l2, d4 + (double)n2 / (double)ScreenDensity.density);
        double d9 = Math.min((double)l2, d5 + (double)n3 / (double)ScreenDensity.density);
        double d10 = MercatorProjection.pixelYToLatitude(d9, f2);
        double d11 = MercatorProjection.pixelXToLongitude(d6, f2);
        double d12 = MercatorProjection.pixelYToLatitude(d7, f2);
        double d13 = MercatorProjection.pixelXToLongitude(d8, f2);
        return new BoundingBox(d10, d11, d12, d13);
    }

    public synchronized GeoPoint getCenter() {
        return new GeoPoint(this.a, this.b);
    }

    public synchronized MapPosition getMapPosition() {
        return new MapPosition(this.getCenter(), this.d);
    }

    public synchronized float getZoomLevel() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCenter(float f2, float f3) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            double d2 = MercatorProjection.longitudeToPixelX(this.b, this.d) - (double)f2;
            double d3 = MercatorProjection.latitudeToPixelY(this.a, this.d) - (double)f3;
            long l2 = MercatorProjection.getMapSize(this.d);
            d2 = Math.min(Math.max(0.0, d2), (double)l2);
            d3 = Math.min(Math.max(0.0, d3), (double)l2);
            double d4 = MercatorProjection.pixelYToLatitude(d3, this.d);
            double d5 = MercatorProjection.pixelXToLongitude(d2, this.d);
            this.a(new GeoPoint(d4, d5));
        }
        this.c.redraw();
    }

    public void setCenter(GeoPoint geoPoint) {
        this.a(geoPoint);
        this.c.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapPosition(MapPosition mapPosition) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.a(mapPosition.geoPoint);
            this.c(mapPosition.zoomLevel);
        }
        this.c.redrawMapItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapScale(float f2) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            int n2 = this.c.getWidth() / 2;
            int n3 = this.c.getHeight() / 2;
            this.c.getOverlayController().postScale(f2, f2, n2, n3);
        }
        this.c.redraw();
    }

    public void setZoomLevel(float f2) {
        this.c(f2);
        this.c.redrawMapItems();
    }

    public void zoom(float f2, float f3) {
        float f4 = this.b(f2);
        int n2 = this.c.getWidth() / 2;
        int n3 = this.c.getHeight() / 2;
    }

    public void zoomIn() {
        this.zoom(1.0f, 1.0f);
    }

    public void zoomOut() {
        this.zoom(-1.0f, 1.0f);
    }

    private float a(float f2) {
        float f3 = this.c.getMapZoomControls().c();
        float f4 = this.c.getZoomLevelMax();
        return Math.max(Math.min(f2, f4), f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GeoPoint geoPoint) {
        MapPosition mapPosition = this.getMapPosition();
        Point point = this.c.getProjection().toPoint(mapPosition.geoPoint, null, mapPosition.zoomLevel);
        Object object = this;
        synchronized (object) {
            this.a = geoPoint.latitude;
            this.b = geoPoint.longitude;
        }
        object = this.getMapPosition();
        Point point2 = this.c.getProjection().toPoint(this.getCenter(), null, ((MapPosition)object).zoomLevel);
        this.c.getOverlayController().postTranslate(point.x - point2.x, point.y - point2.y);
    }

    private synchronized float b(float f2) {
        return this.d(this.d + f2);
    }

    private void c(float f2) {
        float f3 = this.d(f2);
        int n2 = this.c.getWidth() / 2;
        int n3 = this.c.getHeight() / 2;
        this.c.getOverlayController().postScale(f3, f3, n2, n3);
    }

    private synchronized float d(float f2) {
        float f3 = this.d;
        float f4 = this.a(f2);
        if (f4 == f3) {
            return 1.0f;
        }
        this.d = f4;
        this.c.onZoomLevelChange(f4);
        this.c.getMapZoomControls().c(f4);
        return (float)Math.pow(2.0, f4 - f3);
    }
}

