package com.locnavi.location.uploadlocation.engine.model;

import java.util.Comparator;

/**
 * Created by Richard on 2013/8/14.
 */
public class Beacon {
    /*PUSH*/
    int pushType =0;
    final static int PUSH_SOUND=1;
    final static int PUSH_TEXT=2;
    final static int PUSH_IMAGE=3;
    final static int PUSH_VIDEO=4;
    final static int PUSH_TTS=5;
    public String push_link=null;
    public String store_link=null;
    public String push_name=null;
//    public List<LocationRegion> locationRegions=new ArrayList<LocationRegion>();
    /*AD TYPE*/
    int adType;

    public int beaconType=0;
    public final static int WIFI_BEACON=1;
    public final static int BTLE_BEACON=2;
    public final static int WIFI_BTLE_BEACON=3;

    /*Replace*/ public double lon,lat;
    /*Replace*/ public long id_wifi=0;
    /*Replace*/ public long id_btle=0;
    /*Replace*/ public String mac_wifi=null;
    /*Replace*/ public String mac_btle=null;
    /*Replace*/ public String ssid=null;
    /*Replace*/ public String btleName=null;
    /*Replace*/ public double btlePower=0;
    /*Replace*/ public int wifiPower=0;
//    /*Replace*/ public MapDataBase floor;
    /*Replace*/ public IBeacon iBeacon=null;


    /*Replace*/ public long updateTimeStamp;
    /*Replace*/ public long updateTimeInterval;
    /*Replace*/ public double btlemaxholdpower=-Double.MAX_VALUE;
    /*Replace*/ public double wifimaxholdpower=-Double.MAX_VALUE;

    public Beacon clone(){
        Beacon beacon=new Beacon();
        beacon.pushType =this.pushType;
        beacon.adType =this.adType;
        beacon.beaconType=this.beaconType;
        beacon.lon=this.lon;
        beacon.lat=this.lat;
        beacon.id_wifi=this.id_wifi;
        beacon.id_btle=this.id_btle;
        beacon.mac_wifi=this.mac_wifi;
        beacon.mac_btle=this.mac_btle;
        beacon.ssid=this.ssid;
        beacon.btleName=this.btleName;
        beacon.btlePower=this.btlePower;
        beacon.wifiPower=this.wifiPower;
//        beacon.floor=this.floor;
        beacon.iBeacon=this.iBeacon;
        beacon.updateTimeStamp=this.updateTimeStamp;
        beacon.updateTimeInterval=this.updateTimeInterval;
        beacon.btlemaxholdpower=this.btlemaxholdpower;
        beacon.wifimaxholdpower=this.wifimaxholdpower;
//        beacon.locationRegions=this.locationRegions;
        return beacon;
    }


    public double getLon(){
        return lon;
    }

    public double getLat(){
        return lat;
    }

    public long getWiFiId(){
        return id_wifi;
    }

    public long getBTLEId(){
        return id_btle;
    }

//    public int getFloorNumber(){
//        return floor.floorNumber;
//    }
//
//    public String getFloorName(){
//        return floor.floorName;
//    }
//
//    public String getFloorDesc(){
//        return floor.floorDesc;
//    }

    public String getProxUUID(){
        if(iBeacon==null)
            return null;

        return iBeacon.proximity_uuid;
    }


    public String getMajor(){
        if(iBeacon==null)
            return null;

        return iBeacon.major;
    }

    public String getMinor(){
        if(iBeacon==null)
            return null;

        return iBeacon.minor;
    }

    public int get1MTxPower(){
        if(iBeacon==null)
            return -1;

        return iBeacon.txPower;
    }

    public boolean isIbeacon(){
        if(iBeacon==null)
            return false;
        else
            return true;
    }


    /*Replace*/ public static class ComparatorBeaconWiFiById implements Comparator<Beacon> {

        @Override
        public int compare(Beacon lhs, Beacon rhs) {
            if(lhs.id_wifi>rhs.id_wifi)
                return 1;
            else if(lhs.id_wifi==rhs.id_wifi)
                return 0;
            return -1;
        }
    }
    /*Replace*/ public static class ComparatorBeaconBTLEById implements Comparator<Beacon> {

        @Override
        public int compare(Beacon lhs, Beacon rhs) {
            if(lhs.id_btle>rhs.id_btle)
                return 1;
            else if(lhs.id_btle==rhs.id_btle)
                return 0;
            return -1;
        }
    }

    /*Replace*/ public static class ComparatorBeaconBTLEByRSSI implements Comparator<Beacon> {

        @Override
        public int compare(Beacon ScanResult, Beacon ScanResult2) {
            if(ScanResult.btlePower>ScanResult2.btlePower)
                return -1;
            if(ScanResult.btlePower==ScanResult2.btlePower)
                return 0;
            return 1;
        }
    }

    /*Replace*/ public static class ComparatorBeaconWiFiByRSSI implements Comparator<Beacon> {

        @Override
        public int compare(Beacon ScanResult, Beacon ScanResult2) {
            if(ScanResult.wifiPower>ScanResult2.wifiPower)
                return -1;
            if(ScanResult.wifiPower==ScanResult2.wifiPower)
                return 0;
            return 1;
        }
    }

    /*Replace*/ public static long BSSIDStringToLongInt(String BSSID) {
        long id = Long
                .valueOf(
                        BSSID.substring(0, 2) + BSSID.substring(3, 5)
                                + BSSID.substring(6, 8)
                                + BSSID.substring(9, 11)
                                + BSSID.substring(12, 14)
                                + BSSID.substring(15, 17), 16);
        return id;
    }

    /*Replace*/ public static class IBeacon{
        public String prefix=null;
        public String proximity_uuid=null;
        public String major=null;
        public String minor=null;
        public int txPower=0;

        public IBeacon(String prefix, String proximity_uuid, String major, String minor, int txPower){
            this.prefix=prefix;
            this.proximity_uuid=proximity_uuid;
            this.major=major;
            this.minor=minor;
            this.txPower=txPower;
        }
    }
    /*Replace*/ public static class ASEiBeacon extends IBeacon{
        public int battery; //0-100
        public ASEiBeacon(IBeacon iBeacon){
            super(iBeacon.prefix,iBeacon.proximity_uuid,"", "", iBeacon.txPower);
//            byte[] bytes;
            int input1=Integer.parseInt(iBeacon.major,16);
            int input2=Integer.parseInt(iBeacon.minor,16);
            byte[] conv = new byte[4];
            conv[3] = (byte) (input2 & 0xff);
            input2 >>= 8;
            conv[2] = (byte) (input2 & 0xff);
//            input >>= 8;
            conv[1] = (byte) (input1 & 0xff);
            input1 >>= 8;
            conv[0] = (byte) input1;
            int[] value=new int[4];
            for(int i=0;i<4;i++){
                value[i]=conv[i]&0xFF;
            }
            value=AES(value,true,12);
            int major = value[1];
            int minor = ((value[2] & 0xF) << 8) + value[3];
            if ((value[0] & 0x80) == 0) {
                battery = (value[2] & 0xF0) >> 4;
            }
            battery=battery*100/15;
            this.major=Integer.toString(major,16);
            this.minor=Integer.toString(minor,16);
        }
        public ASEiBeacon(IBeacon iBeacon,byte battery) {
            super(iBeacon.prefix,iBeacon.proximity_uuid,iBeacon.major, iBeacon.minor, iBeacon.txPower);
            switch(battery) {
                default:
                case 0:
                    this.battery=0;
                    break;
                case 1:
                    this.battery=4;
                    break;
                case 2:
                    this.battery=20;
                    break;
                case 3:
                    this.battery=36;
                    break;
                case 4:
                    this.battery=52;
                    break;
                case 5:
                    this.battery=68;
                    break;
                case 6:
                    this.battery=84;
                    break;
                case 7:
                    this.battery=100;
                    break;
            }
        }


        private static int[] AES(int[] state, boolean dir, int size) {
            int[] sbox = {
                    99, 124, 119, 123, 242, 107, 111, 197, 48, 1, 103, 43, 254, 215, 171, 118, 202, 130, 201, 125,
                    250, 89, 71, 240, 173, 212, 162, 175, 156, 164, 114, 192, 183, 253, 147, 38, 54, 63, 247, 204,
                    52, 165, 229, 241, 113, 216, 49, 21, 4, 199, 35, 195, 24, 150, 5, 154, 7, 18, 128, 226,
                    235, 39, 178, 117, 9, 131, 44, 26, 27, 110, 90, 160, 82, 59, 214, 179, 41, 227, 47, 132,
                    83, 209, 0, 237, 32, 252, 177, 91, 106, 203, 190, 57, 74, 76, 88, 207, 208, 239, 170, 251,
                    67, 77, 51, 133, 69, 249, 2, 127, 80, 60, 159, 168, 81, 163, 64, 143, 146, 157, 56, 245,
                    188, 182, 218, 33, 16, 255, 243, 210, 205, 12, 19, 236, 95, 151, 68, 23, 196, 167, 126, 61,
                    100, 93, 25, 115, 96, 129, 79, 220, 34, 42, 144, 136, 70, 238, 184, 20, 222, 94, 11, 219,
                    224, 50, 58, 10, 73, 6, 36, 92, 194, 211, 172, 98, 145, 149, 228, 121, 231, 200, 55, 109,
                    141, 213, 78, 169, 108, 86, 244, 234, 101, 122, 174, 8, 186, 120, 37, 46, 28, 166, 180, 198,
                    232, 221, 116, 31, 75, 189, 139, 138, 112, 62, 181, 102, 72, 3, 246, 14, 97, 53, 87, 185,
                    134, 193, 29, 158, 225, 248, 152, 17, 105, 217, 142, 148, 155, 30, 135, 233, 206, 85, 40, 223,
                    140, 161, 137, 13, 191, 230, 66, 104, 65, 153, 45, 15, 176, 84, 187, 22 };

            int[] rsbox = {
                    82, 9, 106, 213, 48, 54, 165, 56, 191, 64, 163, 158, 129, 243, 215, 251, 124, 227, 57, 130,
                    155, 47, 255, 135, 52, 142, 67, 68, 196, 222, 233, 203, 84, 123, 148, 50, 166, 194, 35, 61,
                    238, 76, 149, 11, 66, 250, 195, 78, 8, 46, 161, 102, 40, 217, 36, 178, 118, 91, 162, 73,
                    109, 139, 209, 37, 114, 248, 246, 100, 134, 104, 152, 22, 212, 164, 92, 204, 93, 101, 182, 146,
                    108, 112, 72, 80, 253, 237, 185, 218, 94, 21, 70, 87, 167, 141, 157, 132, 144, 216, 171,
                    0, 140, 188, 211, 10, 247, 228, 88, 5, 184, 179, 69, 6, 208, 44, 30, 143, 202, 63, 15, 2,
                    193, 175, 189, 3, 1, 19, 138, 107, 58, 145, 17, 65, 79, 103, 220, 234, 151, 242, 207, 206,
                    240, 180, 230, 115, 150, 172, 116, 34, 231, 173, 53, 133, 226, 249, 55, 232, 28, 117, 223, 110,
                    71, 241, 26, 113, 29, 41, 197, 137, 111, 183, 98, 14, 170, 24, 190, 27, 252, 86, 62, 75,
                    198, 210, 121, 32, 154, 219, 192, 254, 120, 205, 90, 244, 31, 221, 168, 51, 136, 7, 199, 49,
                    177, 18, 16, 89, 39, 128, 236, 95, 96, 81, 127, 169, 25, 181, 74, 13, 45, 229, 122, 159,
                    147, 201, 156, 239, 160, 224, 59, 77, 174, 42, 245, 176, 200, 235, 187, 60, 131, 83, 153, 97,
                    23, 43, 4, 126, 186, 119, 214, 38, 225, 105, 20, 99, 85, 33, 12, 125 };
            int[] Rcon = { 1, 2, 4, 8, 16, 32, 64, 128, 27, 54 };
            int[] key = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 };
            int i = key[0];

            key[0] = key[7];
            key[7] = key[10];
            key[10] = key[5];
            key[5] = key[1];
            key[1] = key[8];
            key[8] = i;
            i = key[2];
            key[2] = key[6];
            key[6] = key[15];
            key[15] = key[14];
            key[14] = key[12];
            key[12] = key[3];
            key[3] = i;
            i = key[13];
            key[13] = key[9];
            key[9] = key[4];
            key[4] = i;

            if (dir) {
                for (int round = 0; round < 10; round++) {
                    key[0] = (sbox[key[(13 - size)]] ^ key[0] ^ Rcon[round]);
                    key[1] = (sbox[key[(14 - size)]] ^ key[1]);
                    key[2] = (sbox[key[(15 - size)]] ^ key[2]);
                    key[3] = (sbox[key[(12 - size)]] ^ key[3]);
                    for (i = 4; i < 16 - size; i++)
                        key[i] ^= key[(i - 4)];
                }
                for (i = 0; i < 16 - size; i++)
                    state[i] ^= key[i];
            }
            for (int round = 0; round < 10; round++) {
                if (dir) {
                    for (i = 15 - size; i > 3; i--)
                        key[i] ^= key[(i - 4)];
                    key[0] = (sbox[key[(13 - size)]] ^ key[0] ^ Rcon[(9 - round)]);
                    key[1] = (sbox[key[(14 - size)]] ^ key[1]);
                    key[2] = (sbox[key[(15 - size)]] ^ key[2]);
                    key[3] = (sbox[key[(12 - size)]] ^ key[3]);
                } else if (size <= 8) {
                    for (i = 0; i < 16; i++) {
                        state[i] = sbox[(state[i] ^ key[i])];
                    }
                    int buf1 = state[1];
                    state[1] = state[5];
                    state[5] = state[9];
                    state[9] = state[13];
                    state[13] = buf1;
                    buf1 = state[2];
                    int buf2 = state[6];
                    state[2] = state[10];
                    state[6] = state[14];
                    state[10] = buf1;
                    state[14] = buf2;
                    buf1 = state[15];
                    state[15] = state[11];
                    state[11] = state[7];
                    state[7] = state[3];
                    state[3] = buf1;
                }
                if (((round > 0) && (dir)) || ((round < 9) && (!dir))) {
                    for (i = 0; i < 4 - size / 4; i++) {
                        int buf4 = i << 2;

                        if (dir) {
                            int buf1 = galois_mul2(galois_mul2(state[buf4] ^ state[(buf4 + 2)]));
                            int buf2 = galois_mul2(galois_mul2(state[(buf4 + 1)] ^ state[(buf4 + 3)]));
                            state[buf4] ^= buf1;
                            state[(buf4 + 1)] ^= buf2;
                            state[(buf4 + 2)] ^= buf1;
                            state[(buf4 + 3)] ^= buf2;
                        }
                        int buf1 = state[buf4] ^ state[(buf4 + 1)] ^ state[(buf4 + 2)] ^ state[(buf4 + 3)];
                        int buf2 = state[buf4];
                        int buf3 = state[buf4] ^ state[(buf4 + 1)]; buf3 = galois_mul2(buf3); state[buf4] = (state[buf4] ^ buf3 ^ buf1);
                        buf3 = state[(buf4 + 1)] ^ state[(buf4 + 2)]; buf3 = galois_mul2(buf3); state[(buf4 + 1)] = (state[(buf4 + 1)] ^ buf3 ^ buf1);
                        buf3 = state[(buf4 + 2)] ^ state[(buf4 + 3)]; buf3 = galois_mul2(buf3); state[(buf4 + 2)] = (state[(buf4 + 2)] ^ buf3 ^ buf1);
                        buf3 = state[(buf4 + 3)] ^ buf2; buf3 = galois_mul2(buf3); state[(buf4 + 3)] = (state[(buf4 + 3)] ^ buf3 ^ buf1);
                    }
                }
                if (dir) {
                    if (size <= 8) {
                        int buf1 = state[13];
                        state[13] = state[9];
                        state[9] = state[5];
                        state[5] = state[1];
                        state[1] = buf1;
                        buf1 = state[10];
                        int buf2 = state[14];
                        state[10] = state[2];
                        state[14] = state[6];
                        state[2] = buf1;
                        state[6] = buf2;
                        buf1 = state[3];
                        state[3] = state[7];
                        state[7] = state[11];
                        state[11] = state[15];
                        state[15] = buf1;
                        for (i = 0; i < 16; i++)
                            state[i] = (rsbox[state[i]] ^ key[i]);
                    }
                } else {
                    key[0] = (sbox[key[(13 - size)]] ^ key[0] ^ Rcon[round]);
                    key[1] = (sbox[key[(14 - size)]] ^ key[1]);
                    key[2] = (sbox[key[(15 - size)]] ^ key[2]);
                    key[3] = (sbox[key[(12 - size)]] ^ key[3]);
                    for (i = 4; i < 16 - size; i++) {
                        key[i] ^= key[(i - 4)];
                    }
                }
            }

            if (!dir) {
                for (i = 0; i < 16 - size; i++)
                    state[i] ^= key[i];
            }
            return state;
        }
        private static int galois_mul2(int value) {
            if (value >> 7 != 0) {
                return (value << 1 ^ 0x1B) & 0xFF;
            }
            return value << 1;
        }
    }
}
