package com.locnavi.location.xunjimap.utils;

import android.content.Context;

/**
 * author:chen
 * time:2017/5/25
 * desc:
 */
public class SpUtils {

    public static String getSearchHistoryJson(Context context) {
        String content = PreferenceUtils.getString(PreferenceContract.KEY_SEARCH_HISTORY, "", context);
        return IpsUtils.decodeString(content);
    }

    public static void setSearchHistory(Context context, String content) {
        PreferenceUtils.putString(PreferenceContract.KEY_SEARCH_HISTORY, IpsUtils.encodeString(content), context);
    }

    public static void clearSearchHistory(Context context) {
        PreferenceUtils.putString(PreferenceContract.KEY_SEARCH_HISTORY, "", context);
    }

    public static void setBackGroundJson(Context context, String backGroundJson) {
        PreferenceUtils.putString(PreferenceContract.KEY_BACKGROUND, IpsUtils.encodeString(backGroundJson), context);
    }

    public static String getBackGroundJson(Context context) {
        return IpsUtils.decodeString(PreferenceUtils.getString(PreferenceContract.KEY_BACKGROUND, "", context));
    }


    public static String getUserMobile(Context context) {
        return PreferenceUtils.getString(PreferenceContract.USER_MOBILE, "", context);
    }

    public static void setUserMobile(Context context, String mobile) {
        PreferenceUtils.putString(PreferenceContract.USER_MOBILE, mobile, context);
    }

    public static int getGuideWhiteList(Context context) {
        return PreferenceUtils.getInt(PreferenceContract.HAS_GUIDE_WHITELIST, 0, context);
    }

    public static void setGuideWhiteList(Context context, int time) {
        PreferenceUtils.putInt(PreferenceContract.HAS_GUIDE_WHITELIST, time, context);
    }

    public static int getNotificationTime(Context context) {
        return PreferenceUtils.getInt(PreferenceContract.NOTIFICATIONTIME, 0, context);
    }

    public static void setNotificationTime(Context context, int time) {
        PreferenceUtils.putInt(PreferenceContract.NOTIFICATIONTIME, time, context);
    }


    public static String getSearch_data(Context context) {
        return PreferenceUtils.getString(PreferenceContract.SEARCH_DATA, "", context);
    }

    public static void setSearch_data(Context context, String data) {
        PreferenceUtils.putString(PreferenceContract.SEARCH_DATA, data, context);
    }


    public static String getCarCheckDatas(Context context, String projectId) {
        return PreferenceUtils.getString(projectId, "", context);
    }


    public static void setCarCheckDatas(Context context, String carCheckData, String projectId) {
        PreferenceUtils.putString(projectId, carCheckData, context);
    }
}
