package com.locnavi.location.xunjimap;

import android.app.Activity;
import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;


import com.locnavi.location.R;
import com.locnavi.location.xunjimap.model.bean.InitNavErrorException;
import com.locnavi.location.xunjimap.model.bean.UserToTargetData;
import com.locnavi.location.xunjimap.model.parse.App;
import com.locnavi.location.xunjimap.model.parse.Project;
import com.locnavi.location.xunjimap.utils.Constants;
import com.locnavi.location.xunjimap.utils.IpsConstants;
import com.locnavi.location.xunjimap.utils.L;
import com.locnavi.location.xunjimap.utils.T;
import com.parse.ParseException;
import com.parse.ParseQuery;
import com.sails.engine.LocationRegion;
import com.sails.engine.PathRoutingManager;
import com.sails.engine.SAILS;
import com.sails.engine.SAILSMapView;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.overlay.ListOverlay;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_MODE_BLE_GPS;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_STATUS_NAVIGATING;

/**
 * author:chen
 * time:2017/5/16
 * desc:
 */
public class XJNavigation {
    private Activity activity;
    private final int navStatus;
    private SAILS sails;
    private SAILSMapView sailsMapView;
    private Project project;
    private String mapId;
    private boolean isFirstQueryMap = true, isFirstLocationFix = true;
    private XJLocationListener ipsLocationListener;

    private Context context;

    private int navMode;
    private PathRoutingManager pathRoutingManager;

    private ListOverlay listOverlay;

    private ArrayList<String> targetIdList = null;
    private UserToTargetLocationListener userToTargetLocationListener;
    private ArrayList<LocationRegion> targetRegionList;
    private String targetRegionString;
    private boolean hasCached;

    private int progress = -100;
    private double userNavigatingZoom;
    private App app;

    public XJNavigation(Context context, String mapId, ArrayList<String> targetIdList) {
        this.mapId = mapId;
        this.context = context;

        if(this.targetIdList == null){
            this.targetIdList = targetIdList;
        }else {
            this.targetIdList.clear();
            this.targetIdList = targetIdList;
        }

        navMode = NAV_MODE_BLE_GPS;
        navStatus = NAV_STATUS_NAVIGATING;
        initSail();
        loadCloudBuilding();
        setTargetId(targetIdList);
    }


    public XJNavigation(Context context, String mapId) {
        this.mapId = mapId;
        this.context = context;
        navMode = NAV_MODE_BLE_GPS;
        navStatus = NAV_STATUS_NAVIGATING;
        initSail();
        loadCloudBuilding();
//        setTargetId(targetIdList);
    }

    public ArrayList<UserToTargetData> setTargetId(ArrayList<String> targetIdList) {
        ArrayList<UserToTargetData> userToTargetDataArrayList = new ArrayList<>();
        if(targetIdList != null){
            this.targetIdList = new ArrayList<>();
            this.targetRegionList = new ArrayList<>();
            for (int i = 0; i < targetIdList.size(); i++) {
                String targetId = targetIdList.get(i);
                L.e("dddd","hasCached" +hasCached);
                if (hasCached || progress >= 100) {
                    LocationRegion targetRegion = getTargetRegion(targetId);
                    UserToTargetData userToTargetData = new UserToTargetData();
                    userToTargetData.setSuccess(true);
                    userToTargetData.setTargetId(targetId);
                    userToTargetData.setTarget(targetRegion.getName());
                    userToTargetData.setTargetFloor(targetRegion.getFloorNumber());
                    this.targetIdList.add(targetId);
                    userToTargetDataArrayList.add(userToTargetData);
                    this.targetRegionList.add(targetRegion);
                } else {
                    UserToTargetData userToTargetData = new UserToTargetData();
                    userToTargetData.setSuccess(false);
                    userToTargetData.setTargetId(targetId);
                    userToTargetData.setErrorCode(4);
                    userToTargetData.setErrorCode(Constants.ERROR_CODE_7);
                    userToTargetData.setErrorMessage(Constants.ERROR_MESSAGE_7);
                    userToTargetDataArrayList.add(userToTargetData);
                    this.targetIdList.add(targetId);
                }
            }

            return userToTargetDataArrayList;
        }else {
            UserToTargetData userToTargetData = new UserToTargetData();
            userToTargetData.setSuccess(false);
            userToTargetData.setErrorCode(Constants.ERROR_CODE_8);
            userToTargetData.setErrorMessage(Constants.ERROR_MESSAGE_8);
            userToTargetDataArrayList.add(userToTargetData);
            return userToTargetDataArrayList;
        }


    }

    private void initSail() {
        sails = new SAILS(context);
        sails.setServerURL(Constants.CLOUD_SERVER_URL);

        LocationRegion.FONT_LANGUAGE = LocationRegion.NORMAL;

        sailsMapView = new SAILSMapView(context);
        sailsMapView.setSAILSEngine(sails);
        sailsMapView.setOutsourcingPath(new File(Environment.getExternalStorageDirectory(), "ecsgroup").toString());


        sails.setMagneticCalibrationCallback(new SAILS.NeedMagneticCalibrationCallback() {
            @Override
            public void onNeedCalibration(int i) {
                //一旦指南针精度不高,马上回到初始状态,但是在导航过程中也会退出导航的 延迟以显示在最上层

            }

            @Override
            public void onFinishCalibration() {

            }

            @Override
            public void onCalibrationTiltAngleUpdated(float v, float v1, List<Integer> list, int i) {

            }
        });


        sails.setBLEScanFailCallback(new SAILS.BLEScanFailCallback() {
            @Override
            public void onScanFailCallback(int i) {
                InitNavErrorException initNavErrorException = new InitNavErrorException(Constants.ERROR_CODE_0, Constants.ERROR_MESSAGE_0);

                userToTargetLocationListener.onError(initNavErrorException);
            }
        });

        sails.setOnFloorChangeListener(new SAILS.OnFloorChangeListener() {
            @Override
            public void onFloorChanged(String s) {
                sailsMapView.loadCurrentLocationFloorMap();
            }
        });
        sails.setOnLocationChangeEventListener(new SAILS.OnLocationChangeEventListener() {
            @Override
            public void OnLocationChange() {

            }
        });


        sails.setOnFloorChangeListener(new SAILS.OnFloorChangeListener() {
            @Override
            public void onFloorChanged(String s) {

            }
        });

        sailsMapView.setOnModeChangedListener(new SAILSMapView.OnModeChangedListener() {
            @Override
            public void onModeChanged(int i) {

            }
        });


        sailsMapView.setOnFloorChangedListener(new SAILSMapView.OnFloorChangedListener() {
            @Override
            public void onFloorChangedBefore(String s) {

            }

            @Override
            public void onFloorChangedAfter(String s) {

            }
        });
    }


    public void registerUserToTargetLocationListener(UserToTargetLocationListener userToTargetLocationListener) {
        this.userToTargetLocationListener = userToTargetLocationListener;
    }


    public boolean isLocationFix() {
        //判断是否下载地图和是否定位
        return sails != null && sails.isLocationFix() &&
                sailsMapView.isInMap(new GeoPoint(sails.getLatitude(), sails.getLongitude()));
    }




    public ArrayList<UserToTargetData> startRouting() {
        ArrayList<UserToTargetData> userToTargetDataArrayList = new ArrayList<>();
        if (targetRegionList != null){
            for (int i = 0; i < targetRegionList.size(); i++) {
                LocationRegion locationRegion = targetRegionList.get(i);
                String targetId = targetIdList.get(i);
                boolean locationFix = isLocationFix();
                if (locationFix){
                    SAILS.RoutingInfo routingInfo = sails.route3D(locationRegion);
                    boolean success = routingInfo.success;
                    if (success){
                        int distance = routingInfo.getDistance();
                        L.e("dddd distance" , distance + "");
                        targetRegionString =  locationRegion.getName();
                        UserToTargetData userToTargetData = new UserToTargetData();
                        userToTargetData.setSuccess(true);
                        userToTargetData.setTargetId(targetId);
                        userToTargetData.setTargetFloor(locationRegion.getFloorNumber());
                        userToTargetData.setTarget(targetRegionString);
                        userToTargetData.setToTargetDistance(distance);
                        userToTargetData.setLocationFloor(sails.getFloorNumber());
                        double latitude = sails.getLatitude();
                        double longitude = sails.getLongitude();
                        userToTargetData.setLongitude(longitude);
                        userToTargetData.setNearLocationRegionUUid(locationRegion.uuid);
                        userToTargetData.setLatitude(latitude);
                        userToTargetData.setNearLocationRegionName(getNearestLocationRegion());
                        String buildingName = sails.getBuildingName();
                        if (buildingName!= null){
                            userToTargetData.setBuildingName(buildingName);
                        }

                        userToTargetDataArrayList.add(userToTargetData);
//                        userToTargetDat
                    }else {
                        UserToTargetData userToTargetData = new UserToTargetData();
                        userToTargetData.setSuccess(false);
                        userToTargetData.setTargetId(targetId);
                        userToTargetData.setTargetFloor(locationRegion.getFloorNumber());
                        userToTargetData.setErrorCode(Constants.ERROR_CODE_5);
                        userToTargetData.setErrorMessage(Constants.ERROR_MESSAGE_5);
                        userToTargetDataArrayList.add(userToTargetData);

                    }
                }else {
                    UserToTargetData userToTargetData = new UserToTargetData();
                    userToTargetData.setSuccess(false);
                    userToTargetData.setTargetId(targetId);
                    userToTargetData.setTargetFloor(locationRegion.getFloorNumber());
                    userToTargetData.setErrorCode(Constants.ERROR_CODE_6);
                    userToTargetData.setErrorMessage(Constants.ERROR_MESSAGE_6);
                    userToTargetDataArrayList.add(userToTargetData);
                }
            }
            return userToTargetDataArrayList;
        }else {
            UserToTargetData userToTargetData = new UserToTargetData();
            userToTargetData.setSuccess(false);
            userToTargetData.setErrorCode(Constants.ERROR_CODE_8);
            userToTargetData.setErrorMessage(Constants.ERROR_MESSAGE_8);
            userToTargetDataArrayList.add(userToTargetData);
            return userToTargetDataArrayList;
        }

    }

    private String getNearestLocationRegion() {
        List<LocationRegion> locationRegionList = sails.getCurrentInRegions();
        String lr;
        if (locationRegionList != null && locationRegionList.size() > 0) {
            LocationRegion locationRegion = locationRegionList.get(0);
            String type = locationRegion.type;
            if (type != null && (type.equals("freedom") || type.equals("boundary") || type.equals("lock"))) {
                lr = getNearestLocationRegionFromAll();
            } else {
                lr = locationRegionList.get(0).label;
            }
        } else {
            lr = getNearestLocationRegionFromAll();
        }
        return lr;
    }

    private String getNearestLocationRegionFromAll() {
        String lr = "";
        ArrayList<LocationRegion> allRegionList = getAllRegionList();
        if (sails.isInThisBuilding() && allRegionList != null) {
            List<LocationRegion> locationRegions = sails.sortLocationRegionsByPathLength(allRegionList);
            if (locationRegions != null && locationRegions.size() > 0) {
                lr = locationRegions.get(0).label;
            }
        }
        return lr;
    }

    private ArrayList<LocationRegion> getAllRegionList() {
        ArrayList<LocationRegion> AllLocationRegionList = new ArrayList<>();
        List<String> floorNameList = sails.getFloorNameList();
        if (floorNameList != null) {
            for (String s : floorNameList) {
                List<LocationRegion> locationRegionList = sails.getLocationRegionList(s);
                if (locationRegionList != null) {
                    for (LocationRegion locationRegion : locationRegionList) {
                        if (locationRegion.type != null) {
                            String type = locationRegion.type;
                            if (type.equals("freedom") || type.equals("boundary") || type.equals("lock")) {
                                continue;
                            }
                        }
                        AllLocationRegionList.add(locationRegion);
                    }
                }

            }
        }
        return AllLocationRegionList;
    }

    private void mapViewInitial() {
        if (!sails.getFloorNameList().isEmpty()) {
            if (project.getFloorName() != null) {
                sailsMapView.loadFloorMap(project.getFloorName());
            }
            sailsMapView.setNavigationModeYOffsetHeightRatio(0.22);
            sailsMapView.getMapViewPosition().setZoomLevel(Float.parseFloat(project.getZoom() + ""));
            sailsMapView.setAnimatingToRotationAngle((float) project.getAngle());
            userNavigatingZoom = project.getNavigationZoom();
            initRoutingManger();
            //预设目的地
        }
    }

    private void loadCloudBuilding() {
        isFirstQueryMap = true;
        if (XJLocationSDK.app != null) {
            app = XJLocationSDK.app;
            ParseQuery<Project> query = XJLocationSDK.app.getProjects().getQuery();
//            query.whereEqualTo("visible", true);
            if (!XJLocationSDK.debug) {
                query.whereEqualTo("isDebug", false);
            }
            query.setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK);
            query.findInBackground((objects, e) -> {
                if (e != null) {
                    e.printStackTrace();
                    if (e.getCode() != ParseException.CACHE_MISS && isFirstQueryMap) {
//                        T.showShort(R.string.ips_location_no_permission_read_this_map);
                        InitNavErrorException initNavErrorException = new InitNavErrorException(Constants.ERROR_CODE_1, Constants.ERROR_MESSAGE_1);
                        if (userToTargetLocationListener != null) {
                            userToTargetLocationListener.onError(initNavErrorException);
                        }

                    }
                    return;
                }
                if (!isFirstQueryMap) {
                    return;
                }
                isFirstQueryMap = false;
                for (int i = 0; i < objects.size(); i++) {
                    Project project = objects.get(i);
                    if (project.getObjectId().equals(mapId)) {
                        this.project = project;
                        L.e("dddd map name :  ", project.getName());
                        break;
                    }
                }
                if (this.project == null) {
//                    T.showShort(R.string.ips_location_no_permission_read_this_map);
                    InitNavErrorException initNavErrorException = new InitNavErrorException(Constants.ERROR_CODE_1, Constants.ERROR_MESSAGE_1);
                    if (userToTargetLocationListener != null) {
                        userToTargetLocationListener.onError(initNavErrorException);
                    }
                    return;
                }
                if (project.getBuildingId().isEmpty() || project.getToken().isEmpty()) {
//                    T.showShort(R.string.ips_lcoation_info_lack);
                    InitNavErrorException initNavErrorException = new InitNavErrorException(Constants.ERROR_CODE_2, Constants.ERROR_MESSAGE_2);
                    if (userToTargetLocationListener != null) {
                        userToTargetLocationListener.onError(initNavErrorException);
                    }
                    return;
                }

                sails.loadCloudBuilding(project.getToken(), project.getBuildingId(), new SAILS.OnLoadStatusCallback() {
                    @Override
                    public void onCacheLoaded() {
                        hasCached = true;
                        sails.setGPSFloorLayer(project.getGpsFloorlayer() + "");
                        mapViewInitial();
                        engineLocationProcedure();
                    }


                    @Override
                    public void onNetworkLoadingProgress(boolean loadSuccess, int progress) {
                        XJNavigation.this.progress = progress;
                        if (loadSuccess && !hasCached) {
                            sails.setGPSFloorLayer(project.getGpsFloorlayer() + "");
                            L.e("dddd", "load NetworkLoading ");
                            mapViewInitial();
                            engineLocationProcedure();
                            hasCached = true;
                        }
                    }

                    @Override
                    public void onNetworkLoadingFailed(String s) {
                        L.e("dddd", "load map fail");
                        InitNavErrorException initNavErrorException = new InitNavErrorException(Constants.ERROR_CODE_3, Constants.ERROR_MESSAGE_3);
                        if (userToTargetLocationListener != null) {
                            userToTargetLocationListener.onError(initNavErrorException);
                        }
                    }
                });
            });
        } else {
            T.showShort(R.string.ips_location_init_ipsmap_fail);
            return;
        }
    }

    private void engineLocationProcedure() {
        if (sails != null) {
            if (sails.isLocationEngineStarted()) {
                sailsMapView.setLocatorMarkerVisible(false);
                sailsMapView.invalidate();
                sails.stopLocatingEngine();
                sailsMapView.setMode(SAILSMapView.GENERAL);
            } else {
                sails.setGPSThresholdParameter(project.getInToOut(), project.getOutToIn(), project.getPowerThreshold()); //in_to_out,out_to_in,beacon min power
                sails.setEnvironmentIsHighBeaconDensity(true);//v1.51
                updateNavMode();
//                sails.setSpeedFactor(5.0);
                sails.startLocatingEngine();
                L.e("dddd", "start location");
            }
//            initNavigation();
        }
    }


    private void stopLocation() {
        if (sails != null && sails.isLocationEngineStarted()) {
            sails.stopLocatingEngine();
        }
    }


    private LocationRegion getTargetRegion(String targetId) {
        ArrayList<LocationRegion> AllLocationRegionList = new ArrayList<>();
        List<String> floorNameList = sails.getFloorNameList();
        if (floorNameList != null) {
            for (String s : floorNameList) {
                List<LocationRegion> locationRegionList = sails.getLocationRegionList(s);
                if (locationRegionList != null) {
                    for (LocationRegion locationRegion : locationRegionList) {
                        if (locationRegion.type != null) {
                            String type = locationRegion.type;
                            if (type.equals("freedom") || type.equals("boundary") || type.equals("lock")) {
                                continue;
                            }
                        }
                        if (!TextUtils.isEmpty(locationRegion.uuid) && locationRegion.uuid.equals(targetId)) {
                            return locationRegion;
                        }
                    }
                }

            }
        }
        return null;
    }


    private void initRoutingManger() {
        pathRoutingManager = sailsMapView.getRoutingManager();
        pathRoutingManager.setRouteMode(PathRoutingManager.ELEVATOR_FIRST);
        pathRoutingManager.locationRegionCrossable(true);
        pathRoutingManager.setStartRegion(PathRoutingManager.MY_LOCATION);
    }

    private void updateNavMode() {
        navMode = IpsConstants.NAV_MODE_BLE_GPS;
        if (sails != null && sailsMapView != null) {
            switch (navMode) {
                case IpsConstants.NAV_MODE_SIMULATION:
                    sails.setMode(SAILS.SIMULATION | SAILS.WITH_GPS);
                    break;
                case IpsConstants.NAV_MODE_BLE_GPS:
                    sails.setMode(SAILS.BLE_GFP_IMU | SAILS.WITH_GPS | SAILS.WITHOUT_FOLLOW_HEADING);
                    sails.setMode(SAILS.BLE_GFP_IMU | SAILS.WITH_GPS );
                    break;
                case IpsConstants.NAV_MODE_WIFI_GPS:
                    sails.setMode(SAILS.WIFI_GFP_IMU | SAILS.WITH_GPS);
                    break;
            }
//            sailsMapView.setLocatorMarkerVisible(true);
            if (sails.isInThisBuilding()) {
                sailsMapView.setMode(SAILSMapView.LOCATION_CENTER_LOCK | SAILSMapView.FOLLOW_PHONE_HEADING);
            } else {
                sailsMapView.setMode(SAILSMapView.GENERAL);
            }
        }
    }

    private void initNavigation() {
        sails.startLocatingEngine();
    }


    public void stopNavigation() {
        activity = null;
        context = null;
        userToTargetLocationListener = null;
        if (sails != null && sails.isLocationEngineStarted()) {
            sails.stopLocatingEngine();
        }
        sails = null;
        sailsMapView = null;
    }


}
