/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.location.xunjimap.utils;

import android.text.TextUtils;
import com.locnavi.location.xunjimap.utils.CallBackUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class RequestUtil {
    private String mMetyodType;
    private String mUrl;
    private Map<String, String> mParamsMap;
    private String mJsonStr;
    private File mFile;
    private List<File> mfileList;
    private String mfileKey;
    private Map<String, File> mfileMap;
    private String mFileType;
    private Map<String, String> mHeaderMap;
    private CallBackUtil mCallBack;
    private OkHttpClient mOkHttpClient;
    private Request mOkHttpRequest;
    private Request.Builder mRequestBuilder;

    RequestUtil(String string2, String string3, Map<String, String> map, Map<String, String> map2, CallBackUtil callBackUtil) {
        this(string2, string3, null, null, null, null, null, null, map, map2, callBackUtil);
    }

    RequestUtil(String string2, String string3, String string4, Map<String, String> map, CallBackUtil callBackUtil) {
        this(string2, string3, string4, null, null, null, null, null, null, map, callBackUtil);
    }

    RequestUtil(String string2, String string3, Map<String, String> map, File file, String string4, String string5, Map<String, String> map2, CallBackUtil callBackUtil) {
        this(string2, string3, null, file, null, string4, null, string5, map, map2, callBackUtil);
    }

    RequestUtil(String string2, String string3, Map<String, String> map, List<File> list, String string4, String string5, Map<String, String> map2, CallBackUtil callBackUtil) {
        this(string2, string3, null, null, list, string4, null, string5, map, map2, callBackUtil);
    }

    RequestUtil(String string2, String string3, Map<String, String> map, Map<String, File> map2, String string4, Map<String, String> map3, CallBackUtil callBackUtil) {
        this(string2, string3, null, null, null, null, map2, string4, map, map3, callBackUtil);
    }

    private RequestUtil(String string2, String string3, String string4, File file, List<File> list, String string5, Map<String, File> map, String string6, Map<String, String> map2, Map<String, String> map3, CallBackUtil callBackUtil) {
        this.mMetyodType = string2;
        this.mUrl = string3;
        this.mJsonStr = string4;
        this.mFile = file;
        this.mfileList = list;
        this.mfileKey = string5;
        this.mfileMap = map;
        this.mFileType = string6;
        this.mParamsMap = map2;
        this.mHeaderMap = map3;
        this.mCallBack = callBackUtil;
        this.getInstance();
    }

    private void getInstance() {
        this.mOkHttpClient = new OkHttpClient();
        this.mRequestBuilder = new Request.Builder();
        if (this.mFile != null || this.mfileList != null || this.mfileMap != null) {
            this.setFile();
        } else {
            switch (this.mMetyodType) {
                case "GET": {
                    this.setGetParams();
                    break;
                }
                case "POST": {
                    this.mRequestBuilder.post(this.getRequestBody());
                    break;
                }
                case "PUT": {
                    this.mRequestBuilder.put(this.getRequestBody());
                    break;
                }
                case "DELETE": {
                    this.mRequestBuilder.delete(this.getRequestBody());
                }
            }
        }
        this.mRequestBuilder.url(this.mUrl);
        if (this.mHeaderMap != null) {
            this.setHeader();
        }
        this.mOkHttpRequest = this.mRequestBuilder.build();
    }

    private RequestBody getRequestBody() {
        if (!TextUtils.isEmpty((CharSequence)this.mJsonStr)) {
            MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
            return RequestBody.create((MediaType)mediaType, (String)this.mJsonStr);
        }
        FormBody.Builder builder = new FormBody.Builder();
        if (this.mParamsMap != null) {
            for (String string2 : this.mParamsMap.keySet()) {
                builder.add(string2, this.mParamsMap.get(string2));
            }
        }
        return builder.build();
    }

    private void setGetParams() {
        if (this.mParamsMap != null) {
            this.mUrl = this.mUrl + "?";
            for (String string2 : this.mParamsMap.keySet()) {
                this.mUrl = this.mUrl + string2 + "=" + this.mParamsMap.get(string2) + "&";
            }
            this.mUrl = this.mUrl.substring(0, this.mUrl.length() - 1);
        }
    }

    private void setFile() {
        if (this.mFile != null) {
            if (this.mParamsMap == null) {
                this.setPostFile();
            } else {
                this.setPostParameAndFile();
            }
        } else if (this.mfileList != null) {
            this.setPostParameAndListFile();
        } else if (this.mfileMap != null) {
            this.setPostParameAndMapFile();
        }
    }

    private void setPostFile() {
        if (this.mFile != null && this.mFile.exists()) {
            MediaType mediaType = MediaType.parse((String)this.mFileType);
            RequestBody requestBody = RequestBody.create((MediaType)mediaType, (File)this.mFile);
            this.mRequestBuilder.post((RequestBody)new ProgressRequestBody(requestBody, this.mCallBack));
        }
    }

    private void setPostParameAndFile() {
        if (this.mParamsMap != null && this.mFile != null) {
            MultipartBody.Builder builder = new MultipartBody.Builder();
            builder.setType(MultipartBody.FORM);
            for (String string2 : this.mParamsMap.keySet()) {
                builder.addFormDataPart(string2, this.mParamsMap.get(string2));
            }
            builder.addFormDataPart(this.mfileKey, this.mFile.getName(), RequestBody.create((MediaType)MediaType.parse((String)this.mFileType), (File)this.mFile));
            this.mRequestBuilder.post((RequestBody)new ProgressRequestBody((RequestBody)builder.build(), this.mCallBack));
        }
    }

    private void setPostParameAndListFile() {
        if (this.mfileList != null) {
            MultipartBody.Builder builder = new MultipartBody.Builder();
            builder.setType(MultipartBody.FORM);
            if (this.mParamsMap != null) {
                for (String object : this.mParamsMap.keySet()) {
                    builder.addFormDataPart(object, this.mParamsMap.get(object));
                }
            }
            for (File file : this.mfileList) {
                builder.addFormDataPart(this.mfileKey, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)this.mFileType), (File)file));
            }
            this.mRequestBuilder.post((RequestBody)builder.build());
        }
    }

    private void setPostParameAndMapFile() {
        if (this.mfileMap != null) {
            MultipartBody.Builder builder = new MultipartBody.Builder();
            builder.setType(MultipartBody.FORM);
            if (this.mParamsMap != null) {
                for (String string2 : this.mParamsMap.keySet()) {
                    builder.addFormDataPart(string2, this.mParamsMap.get(string2));
                }
            }
            for (String string2 : this.mfileMap.keySet()) {
                builder.addFormDataPart(string2, this.mfileMap.get(string2).getName(), RequestBody.create((MediaType)MediaType.parse((String)this.mFileType), (File)this.mfileMap.get(string2)));
            }
            this.mRequestBuilder.post((RequestBody)builder.build());
        }
    }

    private void setHeader() {
        if (this.mHeaderMap != null) {
            for (String string2 : this.mHeaderMap.keySet()) {
                this.mRequestBuilder.addHeader(string2, this.mHeaderMap.get(string2));
            }
        }
    }

    void execute() {
        this.mOkHttpClient.newCall(this.mOkHttpRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException iOException) {
                if (RequestUtil.this.mCallBack != null) {
                    RequestUtil.this.mCallBack.onError(call, iOException);
                }
            }

            public void onResponse(Call call, Response response) {
                if (RequestUtil.this.mCallBack != null) {
                    RequestUtil.this.mCallBack.onSeccess(call, response);
                }
            }
        });
    }

    private static class ProgressRequestBody
    extends RequestBody {
        private final RequestBody requestBody;
        private BufferedSink bufferedSink;
        private CallBackUtil callBack;

        ProgressRequestBody(RequestBody requestBody, CallBackUtil callBackUtil) {
            this.requestBody = requestBody;
            this.callBack = callBackUtil;
        }

        public MediaType contentType() {
            return this.requestBody.contentType();
        }

        public long contentLength() {
            return this.requestBody.contentLength();
        }

        public void writeTo(BufferedSink bufferedSink) {
            if (this.bufferedSink == null) {
                this.bufferedSink = Okio.buffer((Sink)this.sink(bufferedSink));
            }
            this.requestBody.writeTo(this.bufferedSink);
            this.bufferedSink.flush();
        }

        private Sink sink(BufferedSink bufferedSink) {
            return new ForwardingSink((Sink)bufferedSink){
                long bytesWritten;
                long contentLength;
                {
                    super(sink);
                    this.bytesWritten = 0L;
                    this.contentLength = 0L;
                }

                public void write(Buffer buffer, long l2) {
                    super.write(buffer, l2);
                    if (this.contentLength == 0L) {
                        this.contentLength = this.contentLength();
                    }
                    this.bytesWritten += l2;
                    final float f2 = (float)this.bytesWritten * 1.0f / (float)this.contentLength;
                    CallBackUtil.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callBack.onProgress(f2, contentLength);
                        }
                    });
                }
            };
        }
    }
}

