package com.locnavi.location.uploadlocation.engine;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;


import com.locnavi.location.uploadlocation.engine.model.Satellite;
import com.sails.engine.SensorElement;
import com.locnavi.location.uploadlocation.engine.model.Beacon;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by richard on 2017/8/5.
 */

public class SensorAdapter implements SensorEventListener,
        BLESourceController.OnSourceUpdateCallback{
    private final Context context;
    boolean fromRealSignal = true;
    private SAILSSensorEventListener listener = null;
    private SensorManager sensorManager = null;
    private BLESourceController blesc = null;
    private float[] gravity = new float[3];
    private float[] geomag = new float[3];
    private long headingTimestamp = System.currentTimeMillis();
    private double filteredHeading = 0;
    private List<SensorElement> recordList = new ArrayList<>();

    int playIndex = 0;
    long firstRecordTimestamp = 0;
    long firstPlayerTimestamp = 0;
    long savedTimestamp1;
    long savedTimestamp2;
    int duration = 0;
    private long totalDuration;
    private int lastUpdateIndex = 0;
    private boolean autoTurnOnBT = false;

    public SensorAdapter(Context context) {
        this.context=context;
    }
    public SensorAdapter run() {
        if(fromRealSignal) {
            // start step processing
//            sensorManager = (SensorManager) context.getSystemService(Context.SENSOR_SERVICE);
//            sensorManager.registerListener(this,sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),SensorManager.SENSOR_DELAY_FASTEST);
//            sensorManager.registerListener(this,sensorManager.getDefaultSensor(Sensor.TYPE_GAME_ROTATION_VECTOR),SensorManager.SENSOR_DELAY_FASTEST);
//            sensorManager.registerListener(this,sensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD),SensorManager.SENSOR_DELAY_FASTEST);
//            sensorManager.registerListener(this,sensorManager.getDefaultSensor(Sensor.TYPE_GYROSCOPE),SensorManager.SENSOR_DELAY_FASTEST);
            //start ble scan processing
            blesc = new BLESourceController(context);
            blesc.setOnBTLESourceUpdateCallback(this);

//            blesc.setAutoTurnOnBT(autoTurnOnBT);
            blesc.enableSource();

            //gps signal processing

        } else {
          //  playPlayer();
        }
        return this;
    }
    public void pausePlayer() {
        inPlay=false;
    }
    public void stopPlayer() {
        inPlay=false;
        if(recordList.size()==0)
            return;
        setPlayIndex(0,true);
    }
    public void playPlayer() {
        resumePlayer();
    }
    public SensorAdapter setPercentagePlayer(float percentage) {
        if (percentage <= 0) {
            setPlayIndex(0);
            return this;
        }
        if (percentage >= 100) {
            setPlayIndex(recordList.size() - 1);
            return this;
        }
        double timestamp = (percentage/100.0) * (double)totalDuration + firstRecordTimestamp;
        for (int i = 0; i < recordList.size(); i++) {
            if (recordList.get(i).timestamp > timestamp) {
                setPlayIndex(i);
                return this;
            }
        }
        return this;
    }
    private void setPlayIndex(int i) {
        setPlayIndex(i,false);
    }
    private void setPlayIndex(int i,boolean forceUpdate) {
        if(i<0) {
            lastUpdateIndex = 0;
            playIndex = 0;
            updateUIProcedure();
            return;
        }
        if(i>recordList.size()-1) {
            lastUpdateIndex = recordList.size()-1;
            playIndex = lastUpdateIndex;
            updateUIProcedure();
            inPlay=false;
            return;
        }
        double p = ((double)(recordList.get(lastUpdateIndex).timestamp - recordList.get(i).timestamp))/totalDuration;
        if(Math.abs(p)>0.1 || forceUpdate) {
            lastUpdateIndex = i;
            updateUIProcedure();
        }
        playIndex = i;
    }

    private void updateUIProcedure() {

    }

    public void resumePlayer() {
        inPlay = true;
        firstRecordTimestamp = recordList.get(playIndex).timestamp;
        playRecord();
    }
    boolean inPlay = false;
    private void playRecord() {
        inPlay = true;
        firstPlayerTimestamp = System.currentTimeMillis();
        new Thread(new Runnable() {
            @Override
            public void run() {
                while(true) {
                    if(inPlay) {
                        SensorElement se = recordList.get(playIndex);
                        execute(se);
                        setPlayIndex(playIndex+1);
                        if(playIndex >= recordList.size()) {
                            inPlay = false;
                            return;
                        }
                        se = recordList.get(playIndex);
                        long sleep = (se.timestamp - firstRecordTimestamp)
                                -(System.currentTimeMillis() - firstPlayerTimestamp);
                        if(sleep < -300) {
                            firstRecordTimestamp = se.timestamp;
                            firstPlayerTimestamp = System.currentTimeMillis();
                        } else {
                            try {
                                Thread.sleep(sleep - 5 > 0 ? sleep - 5 : 1);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        try {
                            Thread.sleep(50);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }

            }
        }).start();
    }
    static class VirtualLocation extends Location {
        final double latitude,longitude;
        float accuracy,speed;
        public double getLongitude() {
            return longitude;
        }
        public double getLatitude() {
            return latitude;
        }
        public float getAccuracy() {
            return accuracy;
        }
        public float getSpeed() {
            return speed;
        }
        public VirtualLocation(double lon,double lat,float acc,float spd) {
            super("");
            longitude=lon;
            latitude=lat;
            accuracy=acc;
            speed=spd;
        }
    }
    private void execute(SensorElement sensorElement) {
        if(listener == null)
            return;
        switch(sensorElement.getType()) {
            case SensorElement.TYPE_STEP:
//                listener.onStep();
                break;
            case SensorElement.TYPE_HEADING:
//                listener.onHeading(sensorElement.heading);
                break;
            case SensorElement.TYPE_GPS:
                break;
            case SensorElement.TYPE_BEACON:
                List<Satellite> satellites = new ArrayList<>();
                for(SensorElement.Beacon b : sensorElement.scanResult) {
                    Beacon beacon = new Beacon();
                    beacon.id_btle=b.id_btle;
                    Satellite satellite = new Satellite(beacon);
                    satellite.checkInRSSI(b.rssi);
                    satellite.refreshRSSI();
                    satellites.add(satellite);
                }
                listener.onBLEScan(satellites);
                break;
        }
    }


    public SensorAdapter load(List<SensorElement> recordList) {
        stopPlayer();
        this.recordList = recordList;
        if(recordList.size()>1) {
            firstRecordTimestamp = recordList.get(0).timestamp;
            totalDuration = recordList.get(recordList.size()-1).timestamp - firstRecordTimestamp;
            fromRealSignal = false;
        }
        return this;
    }
    public SensorAdapter stop() {
        if(sensorManager!=null) {
            sensorManager.unregisterListener(this);
            sensorManager = null;
        }

        if(blesc != null) {
            blesc.disableSource();
            blesc = null;
        }

        return this;
    }
    public SensorAdapter setOnSensorEventListner(SAILSSensorEventListener listener) {
        this.listener = listener;
        return this;
    }

    public SensorAdapter setAutoTurnOnBT(boolean autoTurnOnBT) {

        this.autoTurnOnBT = autoTurnOnBT;
        return this;
    }

    @Override
    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
//            float[] accdata = event.values.clone();
            // acc.setText(Float.toString(totalAcc));
            float alpha = 0.8f;
            gravity[0] = alpha * gravity[0] + (1 - alpha) * event.values[0];
            gravity[1] = alpha * gravity[1] + (1 - alpha) * event.values[1];
            gravity[2] = alpha * gravity[2] + (1 - alpha) * event.values[2];
        }
        if (event.sensor.getType()==Sensor.TYPE_MAGNETIC_FIELD) {
            geomag[0]=event.values[0];
            geomag[1]=event.values[1];
            geomag[2]=event.values[2];
        }
        if(System.currentTimeMillis() - headingTimestamp > 20) {
            float[] rotationMatrix = new float[16];
            float[] vals = new float[16];
            SensorManager.getRotationMatrix(rotationMatrix, null, gravity, geomag);
            SensorManager.getOrientation(rotationMatrix,vals);

            double heading=vals[0] * (180/Math.PI);
            double filterFactor = 0.08;//0.05;
            if (filteredHeading - heading > 180) filteredHeading -= 360;
            else if (filteredHeading - heading < -180) filteredHeading += 360;
            filteredHeading = (filteredHeading) * (1 - filterFactor) + (filterFactor * heading);


            headingTimestamp = System.currentTimeMillis();
        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int i) {

    }



    private void onStepProcess() {
        if(listener!=null) {
        }
    }

    @Override
    public void OnUpdateBegin() {

    }

    @Override
    public void OnFPScanUpdated(List<Satellite> sr) {
        if(listener!=null) {
            listener.onBLEScan(sr);
        }

    }

}
