/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.widget.ImageButton;
import com.sails.engine.MapView;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class MapJPGOverlay
implements OverlayItem {
    public static int LOGLEVEL = 0;
    public static boolean WARN = LOGLEVEL > 1;
    public static boolean DEBUG = LOGLEVEL > 0;
    public static final int DefaultRefreshPeriod = 100;
    public MapView mMapView = null;
    public ImageButton mLockButton = null;
    private Bitmap c = null;
    private final Paint d;
    private android.graphics.Point e = new android.graphics.Point();
    private android.graphics.Point f = new android.graphics.Point();
    GeoPoint a = new GeoPoint(0.0, 0.0);
    GeoPoint b = new GeoPoint(0.01, 0.01);

    public MapJPGOverlay(Bitmap bitmap) {
        this.c = bitmap;
        this.d = new Paint(1);
        this.d.setFilterBitmap(true);
    }

    public boolean isLoadMap() {
        return this.c != null;
    }

    public synchronized void loadJPGMap(Bitmap bitmap) {
        if (this.c != null) {
            this.c.recycle();
        }
        this.c = bitmap;
    }

    public boolean toSaveBMP(File file) {
        if (this.c == null) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.c.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public GeoPoint getBMPCenter() {
        if (this.c == null) {
            return new GeoPoint(0.0, 0.0);
        }
        return new GeoPoint(-this.b.longitude / (double)this.c.getWidth() * (double)this.c.getHeight() / 2.0, this.b.longitude / 2.0);
    }

    public synchronized void clear() {
        if (this.c != null) {
            this.c.recycle();
        }
        this.c = null;
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.c == null) {
            return true;
        }
        this.mMapView.getProjection().toPixels(this.a, this.e);
        this.mMapView.getProjection().toPixels(this.b, this.f);
        double d2 = (float)(this.e.x - n2) * ScreenDensity.density;
        double d3 = (float)(this.e.y - n3) * ScreenDensity.density;
        android.graphics.Point point2 = new android.graphics.Point();
        float f4 = (float)(this.f.x - this.e.x) * ScreenDensity.density / (float)this.c.getWidth();
        Matrix matrix = new Matrix();
        matrix.postScale(f4, f4);
        matrix.postTranslate((float)((int)d2 + n2) + (float)(1465 * canvas.getWidth() / 10000) * ScreenDensity.density, (float)((int)d3 + n3) + (float)(1465 * canvas.getHeight() / 10000) * ScreenDensity.density);
        matrix.postRotate(f3, (float)n2, (float)n3);
        canvas.drawBitmap(this.c, matrix, this.d);
        return true;
    }
}

