package com.locnavi.location.xunjimap;

import android.content.Context;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;

import com.locnavi.location.R;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseQuery;
import com.sails.engine.LocationRegion;
import com.sails.engine.MarkerManager;
import com.sails.engine.PathRoutingManager;
import com.sails.engine.SAILS;
import com.sails.engine.SAILSMapView;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.overlay.ListOverlay;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;
//import com.locnavi.location.R;
import com.locnavi.location.uploadlocation.XJGetUserBackGroundDatas;
import com.locnavi.location.uploadlocation.UserAllBackgroundDataListener;
import com.locnavi.location.xunjimap.model.parse.App;
import com.locnavi.location.xunjimap.model.parse.Project;
import com.locnavi.location.xunjimap.model.parse.Punch;
import com.locnavi.location.xunjimap.service.NavigationHandler;
import com.locnavi.location.xunjimap.utils.Constants;
import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.location.xunjimap.utils.IpsConstants;
import com.locnavi.location.xunjimap.utils.IpsUtils;
import com.locnavi.location.xunjimap.utils.L;
import com.locnavi.location.xunjimap.utils.T;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_MODE_BLE_GPS;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_MODE_SIMULATION;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_STATUS_DEFAULT;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_STATUS_FINISH;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_STATUS_NAVIGATING;
import static com.locnavi.location.xunjimap.utils.IpsConstants.NAV_STATUS_NAVIGATING_PAUSE;


/**
 * author:chen
 * time:2017/5/16
 * desc:
 */
public class XJClient {

    private static final int MSG_START_ENGINE = 0, MSG_LOCATION_WAIT = 1, MSG_SEND_LOCATION = 2;
    private static int TIME_OUT = 10000;
    private SAILS sails;
    private SAILSMapView sailsMapView;
    private Project project;
    private String mapId;
    private boolean isFirstQueryMap = true, isFirstLocationFix = true;
    private XJLocationListener xjLocationListener;
    private MyHandler handler;

    private String userId;
    private App app;
    private Context context;
    public static UserAllBackgroundDataListener userAllBackgroundDataListener;
    private int navMode;
    private PathRoutingManager pathRoutingManager;
    private MarkerManager markerManager;
    private ListOverlay listOverlay;
    private List<OverlayItem> overlayItems;
    private int navStatus;
    private long countTime;
    private Timer timerNav;
    private boolean isRouteSuccess;
    private int currentDistance;
    private NavigationHandler navigationHandler;
    private List<SAILS.GeoNode> navGeoNodes;
    private String targetId = null;
    private UserToTargetLocationListener userToTargetLocationListener;

    public XJClient(Context context, String mapId) {
        this.mapId = mapId;
        this.context = context;
        handler = new MyHandler();
        sails = new SAILS(context);
        sails.setServerURL(Constants.CLOUD_SERVER_URL);
        sailsMapView = new SAILSMapView(context);
        sailsMapView.setSAILSEngine(sails);
    }

    public XJClient(Context context, String mapId, String userId) {
        this.userId = userId;
        this.mapId = mapId;
        handler = new MyHandler();
        sails = new SAILS(context);
        sails.setServerURL(Constants.CLOUD_SERVER_URL);
        sailsMapView = new SAILSMapView(context);
        sailsMapView.setSAILSEngine(sails);
    }


    //        String lr = getNearestLocationRegion();
//        if (!TextUtils.isEmpty(lr)) {
//            ipsLocation.setNearLocationRegion(lr);
//        }

    public void setCallBackTimeOut(int timeMS){
        TIME_OUT = timeMS;
    }

    public void registerLocationListener(XJLocationListener xjLocationListener) {
        this.xjLocationListener = xjLocationListener;
    }
    public void registerUserAllLocationDataListener( UserAllBackgroundDataListener userAllBackgroundDataListener) {
        this.userAllBackgroundDataListener = userAllBackgroundDataListener;
    }


    public void registerUserToTargetLocationListener(String targetId , UserToTargetLocationListener userToTargetLocationListener){
        this.targetId = targetId;
        this.userToTargetLocationListener = userToTargetLocationListener;
    }


    public boolean isLocationFix() {
        return sails != null && sails.isLocationFix() &&
                sailsMapView.isInMap(new GeoPoint(sails.getLatitude(), sails.getLongitude()));
    }


    public void startNavigation(){
        loadCloudBuilding();
        //路径规划
        initRoutingManger();
        showPathRoute();
        //选择开始导航模式开始
        navMode = NAV_MODE_BLE_GPS;
        navStatus = NAV_STATUS_NAVIGATING;

//        updateNavStatus();
        updateNavMode();
        initNavigation();
        startNavTimerTask();
    }





    public void getUserAllLocationData(String userId , int page , String mapId){
        if(TextUtils.isEmpty(mapId)){
            mapId = "05rQwjfdSO";
        }
        //userId deviceId
//        TODO
        XJGetUserBackGroundDatas XJGetUserBackGroundDatas = new XJGetUserBackGroundDatas();
        XJGetUserBackGroundDatas.setPage(page);
        XJGetUserBackGroundDatas.queryBackgroundData(mapId, IpsUtils.getDeviceID());

    }

    public void start() {
        if (handler.hasMessages(MSG_LOCATION_WAIT) || handler.hasMessages(MSG_SEND_LOCATION)) {
            return;
        }
        if (sails != null && project != null && sails.isLocationFix() && xjLocationListener != null) {
            handler.sendEmptyMessageDelayed(MSG_SEND_LOCATION, 500);
        } else if (sails != null && project != null && !sails.isLocationFix() && xjLocationListener != null) {
            handler.sendEmptyMessageDelayed(MSG_LOCATION_WAIT, TIME_OUT);
        } else {
            loadCloudBuilding();
        }

    }

    public void stop() {
        stopLocation();
        handler.removeMessages(MSG_START_ENGINE);
        handler.removeMessages(MSG_LOCATION_WAIT);
    }

    private void loadCloudBuilding() {
        isFirstQueryMap = true;
        if (XJLocationSDK.app != null) {
            app = XJLocationSDK.app;
            ParseQuery<Project> query = XJLocationSDK.app.getProjects().getQuery();
            query.whereEqualTo("visible", true);
            if (!XJLocationSDK.debug) {
                query.whereEqualTo("isDebug", false);
            }
            query.setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK);
            query.findInBackground((objects, e) -> {
                if (e != null) {
                    e.printStackTrace();
                    if (e.getCode() != ParseException.CACHE_MISS && isFirstQueryMap) {
                        T.showShort(R.string.ips_location_no_permission_read_this_map);
                    }
                    return;
                }
                if (!isFirstQueryMap) {
                    return;
                }
                isFirstQueryMap = false;
                for (int i = 0; i < objects.size(); i++) {
                    Project project = objects.get(i);
                    if (project.getObjectId().equals(mapId)) {
                        this.project = project;
                        break;
                    }
                }
                if (this.project == null) {
                    T.showShort(R.string.ips_location_no_permission_read_this_map);
                    return;
                }
                if (project.getBuildingId().isEmpty() || project.getToken().isEmpty()) {
                    T.showShort(R.string.ips_lcoation_info_lack);
                    return;
                }
                sails.setOnLocationChangeEventListener(() -> {
                    if (sails.isLocationFix() && handler.hasMessages(MSG_LOCATION_WAIT)) {
                        if (xjLocationListener != null) {
                            handler.sendEmptyMessageDelayed(MSG_SEND_LOCATION, 500);
                            handler.removeMessages(MSG_LOCATION_WAIT);
                            isFirstLocationFix = false;
                        }
                    }
                    if (sails.isLocationFix() && isFirstLocationFix) {
                        isFirstLocationFix = false;
                        sailsMapView.loadFloorMap(project.getGpsFloorlayer() + "");
                        if (xjLocationListener != null) {
                            handler.sendEmptyMessageDelayed(MSG_SEND_LOCATION, 500);
                        }
                    }
                });

                sails.loadCloudBuilding(project.getToken(), project.getBuildingId(), new SAILS.OnFinishCallback() {
                    @Override
                    public void onSuccess(String response) {
                        handler.sendEmptyMessage(MSG_START_ENGINE);
                    }

                    @Override
                    public void onFailed(String response) {

                    }
                });
            });
        } else {
            T.showShort(R.string.ips_location_init_ipsmap_fail);
            return;
        }
    }

    private void startLocation() {
        if (sails != null) {
            sails.setGPSFloorLayer(project.getGpsFloorlayer() + "");
            sails.setGPSThresholdParameter(project.getInToOut(), project.getOutToIn(), project.getPowerThreshold()); //in_to_out,out_to_in,beacon min power
            sails.setEnvironmentIsHighBeaconDensity(true);//v1.51
            sails.setMode(SAILS.BLE_GFP_IMU | SAILS.WITH_GPS);
            sails.startLocatingEngine();
            handler.sendEmptyMessageDelayed(MSG_LOCATION_WAIT, TIME_OUT);
        }
    }


    private void stopLocation() {
        if (sails != null && sails.isLocationEngineStarted()) {
            sails.stopLocatingEngine();
        }
    }

    public String getNearestLocationRegion() {
        List<LocationRegion> locationRegionList = sails.getCurrentInRegions();
        String lr;
        if (locationRegionList != null && locationRegionList.size() > 0) {
            LocationRegion locationRegion = locationRegionList.get(0);
            String type = locationRegion.type;
            if (type != null && (type.equals("freedom") || type.equals("boundary") || type.equals("lock"))) {
                lr = getNearestLocationRegionFromAll();
            } else {
                lr = locationRegionList.get(0).label;
            }
        } else {
            lr = getNearestLocationRegionFromAll();
        }
        return lr;
    }

    private String getNearestLocationRegionFromAll() {
        String lr = "";
        ArrayList<LocationRegion> allRegionList = getAllRegionList();
        if (sails.isInThisBuilding() && allRegionList != null) {
            List<LocationRegion> locationRegions = sails.sortLocationRegionsByPathLength(allRegionList);
            if (locationRegions != null && locationRegions.size() > 0) {
                lr = locationRegions.get(0).label;
            }
        }
        return lr;
    }

    private ArrayList<LocationRegion> getAllRegionList() {
        ArrayList<LocationRegion> AllLocationRegionList = new ArrayList<>();
        List<String> floorNameList = sails.getFloorNameList();
        if (floorNameList != null) {
            for (String s : floorNameList) {
                List<LocationRegion> locationRegionList = sails.getLocationRegionList(s);
                if (locationRegionList != null) {
                    for (LocationRegion locationRegion : locationRegionList) {
                        if (locationRegion.type != null) {
                            String type = locationRegion.type;
                            if (type.equals("freedom") || type.equals("boundary") || type.equals("lock")) {
                                continue;
                            }
                        }
                        AllLocationRegionList.add(locationRegion);
                    }
                }

            }
        }
        return AllLocationRegionList;
    }



    private class NavTimerTask extends TimerTask {
        @Override
        public void run() {
            countTime++;
            if (navStatus == NAV_STATUS_FINISH || navStatus == NAV_STATUS_DEFAULT) {
                timerNav.cancel();
            }
        }
    }

    private void startNavTimerTask() {
        countTime = 0;
        timerNav = new Timer();
        timerNav.schedule(new NavTimerTask(), 1000, 1000);
    }

    private void showPathRoute() {
        overlayItems.clear();
        sails.clearRouteCache();
        pathRoutingManager.enableHandler();
    }

    private void initRoutingManger() {
        pathRoutingManager = sailsMapView.getRoutingManager();
        //路径颜色设置
        pathRoutingManager.getPathPaint().setColor(0xFF4990E2);
        pathRoutingManager.getPathPaint().setStyle(Paint.Style.STROKE);
        pathRoutingManager.getPathPaint().setAlpha(255);
        pathRoutingManager.getPathPaint().setStrokeWidth(8 * ScreenDensity.density);
        pathRoutingManager.getPathPaint().setStrokeJoin(Paint.Join.ROUND);
        pathRoutingManager.getPathPaint().setStrokeCap(Paint.Cap.ROUND);
        pathRoutingManager.getPathPaint().setFilterBitmap(true);
        pathRoutingManager.getPathPaint().setAntiAlias(true);
        pathRoutingManager.getPathStrokePaint().setColor(0xffffff);
        pathRoutingManager.getPathStrokePaint().setStyle(Paint.Style.STROKE);
        pathRoutingManager.getPathStrokePaint().setAlpha(200);
        pathRoutingManager.getPathStrokePaint().setStrokeWidth(13 * ScreenDensity.density);
        pathRoutingManager.getPathStrokePaint().setStrokeJoin(Paint.Join.ROUND);
        pathRoutingManager.getPathStrokePaint().setStrokeCap(Paint.Cap.ROUND);
        pathRoutingManager.getPathStrokePaint().setFilterBitmap(true);
        pathRoutingManager.getPathStrokePaint().setAntiAlias(true);
        pathRoutingManager.setRouteMode(PathRoutingManager.ELEVATOR_FIRST);
        pathRoutingManager.locationRegionCrossable(true);
        markerManager = sailsMapView.getMarkerManager();
        listOverlay = new ListOverlay();
        overlayItems = listOverlay.getOverlayItems();
        //路径规划监听 有可能返回不成功
        pathRoutingManager.setOnRoutingUpdateListener(new PathRoutingManager.OnRoutingUpdateListener() {

            @Override
            public void onArrived(LocationRegion locationRegion) {

            }

            @Override
            public void onRouteSuccess() {
                isRouteSuccess = true;
                new Handler().postDelayed(() -> {
                    sailsMapView.setMode(SAILSMapView.GENERAL);
                    int width = DensityUtils.getScreenWidth(context) - DensityUtils.dp2px(context, 160);
                    sailsMapView.autoSetMapZoomAndView(pathRoutingManager.getCurrentFloorRoutingPathNodes(), width);
                    sailsMapView.setAnimatingToRotationAngle((float) project.getAngle());
                    if (navigationHandler != null) {
                        navigationHandler.clear();
                    }
                    List<SAILS.GeoNode> currentAllPathNodes = pathRoutingManager.getCurrentAllPathNodes();
                    if (currentAllPathNodes == null) {
                        return;
                    }
                    if (currentAllPathNodes.size() < 10000) {
                        navigationHandler = new NavigationHandler(sails, currentAllPathNodes);
                    } else {
                        //有待测试
                        T.showShort(context.getString(R.string.ipsmap_loction_error2));
                        navStatus = NAV_STATUS_DEFAULT;
//                        updateNavStatus();
                        return;
                    }
//                    loadSwitchMarker();
                }, 100);

            }

            @Override
            public void onRouteFail() {
                isRouteSuccess = false;
            }

            @Override
            public void onPathDrawFinish() {
            }

            @Override
            public void onTotalDistanceRefresh(int i) {
              if (navStatus == NAV_STATUS_NAVIGATING || navStatus == NAV_STATUS_NAVIGATING_PAUSE) {
                    currentDistance = i;
                    if (i > 10000) {
                        //有待测试
//                        T.showLong("gps 定位异常 !");
//                        navStatus = NAV_STATUS_DEFAULT;
//                        updateNavStatus();
                        return;
                    }
                    if (navStatus == NAV_STATUS_NAVIGATING) {
                        String hint = context.getString(R.string.ipsmap_left) + i + context.getString(R.string.ipsmap_left2) + IpsUtils.getDistanceTime((double) i);
                        L.e("ddddd","stance"+hint);
//                        navBottomDialog.setHint(hint);
                    }

                    /*导航中信息更新*/

//                    if ((i < IpsConstants.REACH_REAL_BLE_DISTANCE) && navMode != NAV_MODE_SIMULATION
//                            && sails.getFloorNumber() == targetRegion.getFloorNumber() && isVolumeOn) {
//                        voiceManager.textToVoice(IpsConstants.NAV_REACH_REAL, true);
//                        navStatus = NAV_STATUS_FINISH;
//                        updateNavStatus();
//                    }
//                    if ((i < IpsConstants.REACH_SIMULATION_DISTANCE) && navMode == NAV_MODE_SIMULATION
//                            && sails.getFloorNumber() == targetRegion.getFloorNumber() && isVolumeOn) {
//                        voiceManager.textToVoice(IpsConstants.NAV_REACH_SIMU, true);
//                        navStatus = NAV_STATUS_FINISH;
//                        updateNavStatus();
//                    }
                }
            }

            @Override
            public void onReachNearestTransferDistanceRefresh(int i, int i1) {
            }

            @Override
            public void onSwitchFloorInfoRefresh(List<PathRoutingManager.SwitchFloorInfo> list, int i) {
            }

            @Override
            public void onPathRearranged() {
                if (navMode != NAV_MODE_SIMULATION) {
                    pathRoutingManager.enableHandler();
                    String text = context.getString(R.string.xunji_location_rerount);
                    T.showShort(text);
                }

            }
        });

    }

    private void uploadPunch(String lr, boolean isInThisMap) {
        if (isInThisMap && project != null && app != null) {
            Punch punch = new Punch();
            punch.put(Punch.floor, sails.getFloor());
            if (!TextUtils.isEmpty(lr)) {
                punch.put(Punch.locationRegion, lr);
            }
            punch.put(Punch.lonLat, new ParseGeoPoint(sails.getLatitude(), sails.getLongitude()));
            if (userId != null) {
                punch.put(Punch.userId, userId);
            }
            punch.put(Punch.project, project);
            punch.put(Punch.app, app);
            punch.put(Punch.appName, Constants.getAppName(XJLocationSDK.context));
            punch.saveInBackground(e -> {
                if (e != null) {
                    L.e(context.getString(R.string.ipsmap_update_car_fail), e.getCause() + "  " + e.getMessage());
                } else {
                    L.e("eeee", context.getString(R.string.ipsmap_update_car_sucess));
                }
            });
        }
    }

    private void sendLocation() {
        XJLocation ipsLocation = new XJLocation();
        ipsLocation.setFloor(sails.getFloor());

        double latitude = sails.getLatitude();
        double longitude = sails.getLongitude();

        ipsLocation.setLatitude(latitude);
        ipsLocation.setLongitude(longitude);
        if ((int)latitude == 0&& (int)longitude == 0 ){
            if (xjLocationListener != null && !sails.isLocationFix()) {
                xjLocationListener.onReceiveLocation(null);
            }
            return;
        }
        ipsLocation.setFloorDescription(sails.getFloorDescription(sails.getFloor()));
        boolean isInThisMap = sailsMapView.isInMap(new GeoPoint(sails.getLatitude(), sails.getLongitude()));
        ipsLocation.setInThisMap(isInThisMap);
//        String lr = getNearestLocationRegion();
//        if (!TextUtils.isEmpty(lr)) {
//            ipsLocation.setNearLocationRegion(lr);
//        }
        xjLocationListener.onReceiveLocation(ipsLocation);
//        uploadPunch(lr, isInThisMap);
    }


    private class MyHandler extends Handler {
        public MyHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case MSG_START_ENGINE:
                    startLocation();
                    break;
                case MSG_LOCATION_WAIT:
                    if (xjLocationListener != null && !sails.isLocationFix()) {
                        xjLocationListener.onReceiveLocation(null);
                    }
                    break;
                case MSG_SEND_LOCATION:
                    sendLocation();
                    break;
            }
        }
    }



    private void updateNavMode() {
        navMode = IpsConstants.NAV_MODE_BLE_GPS;
        if (sails != null && sailsMapView != null) {
            switch (navMode) {
                case NAV_MODE_SIMULATION:
                    sails.setMode(SAILS.SIMULATION | SAILS.WITH_GPS);
                    break;
                case IpsConstants.NAV_MODE_BLE_GPS:
                    sails.setMode(SAILS.BLE_GFP_IMU | SAILS.WITH_GPS);
                    break;
                case IpsConstants.NAV_MODE_WIFI_GPS:
                    sails.setMode(SAILS.WIFI_GFP_IMU | SAILS.WITH_GPS);
                    break;
            }
            sailsMapView.setLocatorMarkerVisible(true);
            if (sails.isInThisBuilding()) {
                sailsMapView.setMode(SAILSMapView.LOCATION_CENTER_LOCK | SAILSMapView.FOLLOW_PHONE_HEADING);
            } else {
                sailsMapView.setMode(SAILSMapView.GENERAL);
            }
        }
    }

    private void initNavigation() {
        sails.startLocatingEngine();
    }



}
