package com.locnavi.location.xunjimap.utils;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

import java.lang.reflect.Field;


public class KeyboardUtils
{
	/**
	 * 打卡软键盘
	 * @param mContext
	 *            上下文
	 * @param mEditText
	 *            输入框
	 *
	 */
	public static void openKeybord(Context mContext, View mEditText)
	{
		InputMethodManager imm = (InputMethodManager) mContext
				.getSystemService(Context.INPUT_METHOD_SERVICE);
		imm.showSoftInput(mEditText, InputMethodManager.RESULT_SHOWN);
		imm.toggleSoftInput(InputMethodManager.SHOW_FORCED,
				InputMethodManager.HIDE_IMPLICIT_ONLY);
	}

	/**
	 * 关闭软键盘
	 * @param mContext
	 *            上下文
	 * @param mEditText
	 *            输入框
	 *
	 */
	public static void closeKeybord(Context mContext, View mEditText)
	{
		InputMethodManager imm = (InputMethodManager) mContext
				.getSystemService(Context.INPUT_METHOD_SERVICE);

		imm.hideSoftInputFromWindow(mEditText.getWindowToken(), 0);
	}
	
	public static void hideKeyboard(Activity activity) {
		InputMethodManager imm = (InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE);
		View view=activity.getCurrentFocus();
		if(view!=null){
			imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
		}
//		fixInputMethodManagerLeak(activity);
    }


	public static void fixInputMethodManagerLeak(Context context) {
		if (context == null) {
			return;
		}
		try {
			// 对 mCurRootView mServedView mNextServedView 进行置空...
			InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
			if (imm == null) {
				return;
			}// author:sodino mail:sodino@qq.com

			Object obj_get = null;
			Field f_mCurRootView = imm.getClass().getDeclaredField("mCurRootView");
			Field f_mServedView = imm.getClass().getDeclaredField("mServedView");
			Field f_mNextServedView = imm.getClass().getDeclaredField("mNextServedView");

			if (f_mCurRootView.isAccessible() == false) {
				f_mCurRootView.setAccessible(true);
			}
			obj_get = f_mCurRootView.get(imm);
			if (obj_get != null) { // 不为null则置为空
				f_mCurRootView.set(imm, null);
			}

			if (f_mServedView.isAccessible() == false) {
				f_mServedView.setAccessible(true);
			}
			obj_get = f_mServedView.get(imm);
			if (obj_get != null) { // 不为null则置为空
				f_mServedView.set(imm, null);
			}

			if (f_mNextServedView.isAccessible() == false) {
				f_mNextServedView.setAccessible(true);
			}
			obj_get = f_mNextServedView.get(imm);
			if (obj_get != null) { // 不为null则置为空
				f_mNextServedView.set(imm, null);
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

}

