/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.PolygonalChain;
import com.sails.engine.overlay.ScreenDensity;
import java.util.ArrayList;

public class PolylineWithArrow
implements OverlayItem {
    private final int a;
    private Paint b;
    private PolygonalChain c;
    public static double DegreeTolerance = 3.0;
    public double distanceTolerance = 100.0;

    public PolylineWithArrow(PolygonalChain polygonalChain, Paint paint, int n2) {
        this.c = polygonalChain;
        this.b = paint;
        this.a = n2;
        this.distanceTolerance = (float)(this.a * 2) * ScreenDensity.density;
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.c == null || this.b == null) {
            return false;
        }
        Path path = this.c.a(f2, point, false, n2, n3, f3);
        if (path == null) {
            return false;
        }
        Paint paint = new Paint(this.b);
        paint.setPathEffect((PathEffect)new CornerPathEffect(15.0f));
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawPath(path, paint);
        this.a(f2, canvas, point, n2, n3, f3);
        return true;
    }

    private void a(float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        int n4 = this.c.getGeoPoints().size();
        if (n4 < 2) {
            return;
        }
        ArrayList<PixelNode> arrayList = new ArrayList<PixelNode>();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        PixelNode pixelNode = null;
        PixelNode pixelNode2 = null;
        for (int i2 = 0; i2 < n4 + 1; ++i2) {
            GeoPoint geoPoint = i2 != n4 ? this.c.getGeoPoints().get(i2) : this.c.getGeoPoints().get(n4 - 2);
            double d5 = geoPoint.latitude;
            double d6 = geoPoint.longitude;
            float f4 = (float)(MercatorProjection.longitudeToPixelX(d6, f2) - point.x);
            float f5 = (float)(MercatorProjection.latitudeToPixelY(d5, f2) - point.y);
            double d7 = (f4 - (float)n2) * ScreenDensity.density;
            double d8 = (f5 - (float)n3) * ScreenDensity.density;
            double d9 = d7 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d8 * Math.sin((double)(-f3) / 180.0 * Math.PI);
            double d10 = d8 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d7 * Math.sin((double)(-f3) / 180.0 * Math.PI);
            double d11 = (double)n2 + d9;
            double d12 = (double)n3 + d10;
            PixelNode pixelNode3 = new PixelNode(d11, d12, 0.0);
            if (i2 == 0) {
                pixelNode2 = pixelNode3;
            } else {
                pixelNode.c = Math.atan2(pixelNode3.b - pixelNode.b, pixelNode3.a - pixelNode.a);
                if (Math.abs(Math.atan2(Math.sin(pixelNode.c - d3), Math.cos(pixelNode.c - d3))) > DegreeTolerance * Math.PI / 180.0 || i2 == n4) {
                    d3 = pixelNode.c;
                    if (d2 - d4 > this.distanceTolerance) {
                        arrayList.add(new PixelNode((pixelNode.a + pixelNode2.a) / 2.0, (pixelNode.b + pixelNode2.b) / 2.0, Math.atan2(pixelNode.b - pixelNode2.b, pixelNode.a - pixelNode2.a)));
                        d2 = 0.0;
                    }
                    pixelNode2 = pixelNode;
                    d4 = d2;
                }
                d2 += Math.pow(Math.pow(pixelNode3.b - pixelNode.b, 2.0) + Math.pow(pixelNode3.a - pixelNode.a, 2.0), 0.5);
            }
            pixelNode = pixelNode3;
        }
        double d13 = 0.23566666666666666 * (double)this.a * (double)ScreenDensity.density;
        Paint paint = new Paint(this.b);
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        if (arrayList.size() > 0) {
            for (PixelNode pixelNode4 : arrayList) {
                Path path = new Path();
                path.setFillType(Path.FillType.EVEN_ODD);
                f3 = 0.0f;
                path.moveTo((float)(d13 * Math.cos(pixelNode4.c + 2.0943951023931953) + pixelNode4.a), (float)(d13 * Math.sin(pixelNode4.c + 2.0943951023931953) + pixelNode4.b));
                path.lineTo((float)(1.5 * d13 * Math.cos(pixelNode4.c) + pixelNode4.a), (float)(1.5 * d13 * Math.sin(pixelNode4.c) + pixelNode4.b));
                path.lineTo((float)(d13 * Math.cos(pixelNode4.c - 2.0943951023931953) + pixelNode4.a), (float)(d13 * Math.sin(pixelNode4.c - 2.0943951023931953) + pixelNode4.b));
                path.close();
                canvas.drawPath(path, paint);
            }
        }
    }

    public synchronized Paint getPaintStroke() {
        return this.b;
    }

    public synchronized PolygonalChain getPolygonalChain() {
        return this.c;
    }

    public synchronized void setPaintStroke(Paint paint) {
        this.b = paint;
    }

    public synchronized void setPolygonalChain(PolygonalChain polygonalChain) {
        this.c = polygonalChain;
    }

    static class PixelNode {
        double a;
        double b;
        double c;

        PixelNode(double d2, double d3, double d4) {
            this.a = d2;
            this.b = d3;
            this.c = d4;
        }
    }
}

