/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.core.model;

import com.sails.engine.core.model.CoordinatesUtil;
import java.io.Serializable;

public class GeoPoint
implements Serializable,
Comparable<GeoPoint> {
    private static final double a = 6378137.0;
    private static final long b = 1L;
    public final double latitude;
    public final double longitude;

    public static GeoPoint fromString(String string) {
        double[] dArray = CoordinatesUtil.a(string, 2);
        return new GeoPoint(dArray[0], dArray[1]);
    }

    public static double latitudeDistance(int n2) {
        return (double)(n2 * 360) / 4.007501668557849E7;
    }

    public static double longitudeDistance(int n2, double d2) {
        return (double)(n2 * 360) / (4.007501668557849E7 * Math.cos(Math.toRadians(d2)));
    }

    public GeoPoint(double d2, double d3) {
        CoordinatesUtil.b(d2);
        CoordinatesUtil.c(d3);
        this.latitude = d2;
        this.longitude = d3;
    }

    @Override
    public int compareTo(GeoPoint geoPoint) {
        if (this.longitude > geoPoint.longitude) {
            return 1;
        }
        if (this.longitude < geoPoint.longitude) {
            return -1;
        }
        if (this.latitude > geoPoint.latitude) {
            return 1;
        }
        if (this.latitude < geoPoint.latitude) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeoPoint)) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)object;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(geoPoint.latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(geoPoint.longitude);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.latitude);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.longitude);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        return n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("latitude=");
        stringBuilder.append(this.latitude);
        stringBuilder.append(", longitude=");
        stringBuilder.append(this.longitude);
        return stringBuilder.toString();
    }
}

