/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.location.xunjimap;

import android.content.Context;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.locnavi.location.R;
import com.locnavi.location.uploadlocation.UserAllBackgroundDataListener;
import com.locnavi.location.xunjimap.UserToTargetLocationListener;
import com.locnavi.location.xunjimap.XJLocation;
import com.locnavi.location.xunjimap.XJLocationListener;
import com.locnavi.location.xunjimap.XJLocationSDK;
import com.locnavi.location.xunjimap.model.parse.App;
import com.locnavi.location.xunjimap.model.parse.Project;
import com.locnavi.location.xunjimap.model.parse.Punch;
import com.locnavi.location.xunjimap.utils.Constants;
import com.locnavi.location.xunjimap.utils.DensityUtils;
import com.locnavi.location.xunjimap.utils.IpsUtils;
import com.locnavi.location.xunjimap.utils.L;
import com.locnavi.location.xunjimap.utils.T;
import com.parse.ParseGeoPoint;
import com.parse.ParseQuery;
import com.sails.engine.LocationRegion;
import com.sails.engine.MarkerManager;
import com.sails.engine.PathRoutingManager;
import com.sails.engine.SAILS;
import com.sails.engine.SAILSMapView;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.overlay.ListOverlay;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class XJClient {
    private static final int MSG_START_ENGINE = 0;
    private static final int MSG_LOCATION_WAIT = 1;
    private static final int MSG_SEND_LOCATION = 2;
    private static int TIME_OUT = 10000;
    private SAILS sails;
    private SAILSMapView sailsMapView;
    private Project project;
    private String mapId;
    private boolean isFirstQueryMap = true;
    private boolean isFirstLocationFix = true;
    private XJLocationListener ipsLocationListener;
    private a handler;
    private String userId;
    private App app;
    private Context context;
    public static UserAllBackgroundDataListener userAllBackgroundDataListener;
    private int navMode;
    private PathRoutingManager pathRoutingManager;
    private MarkerManager markerManager;
    private ListOverlay listOverlay;
    private List<OverlayItem> overlayItems;
    private int navStatus;
    private long countTime;
    private Timer timerNav;
    private boolean isRouteSuccess;
    private int currentDistance;
    private com.locnavi.location.xunjimap.a.b navigationHandler;
    private List<SAILS.GeoNode> navGeoNodes;
    private String targetId = null;
    private UserToTargetLocationListener userToTargetLocationListener;

    public XJClient(Context context, String string2) {
        this.mapId = string2;
        this.context = context;
        this.handler = new a();
        this.sails = new SAILS(context);
        this.sails.setServerURL("https://gc.locnavi.com");
        this.sailsMapView = new SAILSMapView(context);
        this.sailsMapView.setSAILSEngine(this.sails);
    }

    public XJClient(Context context, String string2, String string3) {
        this.userId = string3;
        this.mapId = string2;
        this.handler = new a();
        this.sails = new SAILS(context);
        this.sails.setServerURL("https://gc.locnavi.com");
        this.sailsMapView = new SAILSMapView(context);
        this.sailsMapView.setSAILSEngine(this.sails);
    }

    public void setCallBackTimeOut(int n2) {
        TIME_OUT = n2;
    }

    public void registerLocationListener(XJLocationListener xJLocationListener) {
        this.ipsLocationListener = xJLocationListener;
    }

    public void registerUserAllLocationDataListener(UserAllBackgroundDataListener userAllBackgroundDataListener) {
        XJClient.userAllBackgroundDataListener = userAllBackgroundDataListener;
    }

    public void registerUserToTargetLocationListener(String string2, UserToTargetLocationListener userToTargetLocationListener) {
        this.targetId = string2;
        this.userToTargetLocationListener = userToTargetLocationListener;
    }

    public boolean isLocationFix() {
        return this.sails != null && this.sails.isLocationFix() && this.sailsMapView.isInMap(new GeoPoint(this.sails.getLatitude(), this.sails.getLongitude()));
    }

    public void startNavigation() {
        this.loadCloudBuilding();
        this.initRoutingManger();
        this.showPathRoute();
        this.navMode = 1;
        this.navStatus = 4;
        this.updateNavMode();
        this.initNavigation();
        this.startNavTimerTask();
    }

    public void getUserAllLocationData(String string2, int n2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = "05rQwjfdSO";
        }
        com.locnavi.location.uploadlocation.a a2 = new com.locnavi.location.uploadlocation.a();
        a2.a(n2);
        a2.a(string3, IpsUtils.getDeviceID());
    }

    public void start() {
        if (this.handler.hasMessages(1) || this.handler.hasMessages(2)) {
            return;
        }
        if (this.sails != null && this.project != null && this.sails.isLocationFix() && this.ipsLocationListener != null) {
            this.handler.sendEmptyMessageDelayed(2, 500L);
        } else if (this.sails != null && this.project != null && !this.sails.isLocationFix() && this.ipsLocationListener != null) {
            this.handler.sendEmptyMessageDelayed(1, TIME_OUT);
        } else {
            this.loadCloudBuilding();
        }
    }

    public void stop() {
        this.stopLocation();
        this.handler.removeMessages(0);
        this.handler.removeMessages(1);
    }

    private void loadCloudBuilding() {
        ParseQuery parseQuery;
        this.isFirstQueryMap = true;
        if (XJLocationSDK.app != null) {
            this.app = XJLocationSDK.app;
            parseQuery = XJLocationSDK.app.getProjects().getQuery();
            parseQuery.whereEqualTo("visible", (Object)true);
            if (!XJLocationSDK.debug) {
                parseQuery.whereEqualTo("isDebug", (Object)false);
            }
        } else {
            T.showShort(R.string.ips_location_init_ipsmap_fail);
            return;
        }
        parseQuery.setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK);
        parseQuery.findInBackground((list, parseException) -> {
            if (parseException != null) {
                parseException.printStackTrace();
                if (parseException.getCode() != 120 && this.isFirstQueryMap) {
                    T.showShort(R.string.ips_location_no_permission_read_this_map);
                }
                return;
            }
            if (!this.isFirstQueryMap) {
                return;
            }
            this.isFirstQueryMap = false;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Project project = (Project)((Object)((Object)list.get(i2)));
                if (!project.getObjectId().equals(this.mapId)) continue;
                this.project = project;
                break;
            }
            if (this.project == null) {
                T.showShort(R.string.ips_location_no_permission_read_this_map);
                return;
            }
            if (this.project.getBuildingId().isEmpty() || this.project.getToken().isEmpty()) {
                T.showShort(R.string.ips_lcoation_info_lack);
                return;
            }
            this.sails.setOnLocationChangeEventListener(() -> {
                if (this.sails.isLocationFix() && this.handler.hasMessages(1) && this.ipsLocationListener != null) {
                    this.handler.sendEmptyMessageDelayed(2, 500L);
                    this.handler.removeMessages(1);
                    this.isFirstLocationFix = false;
                }
                if (this.sails.isLocationFix() && this.isFirstLocationFix) {
                    this.isFirstLocationFix = false;
                    this.sailsMapView.loadFloorMap(this.project.getGpsFloorlayer() + "");
                    if (this.ipsLocationListener != null) {
                        this.handler.sendEmptyMessageDelayed(2, 500L);
                    }
                }
            });
            this.sails.loadCloudBuilding(this.project.getToken(), this.project.getBuildingId(), new SAILS.OnFinishCallback(){

                @Override
                public void onSuccess(String string2) {
                    XJClient.this.handler.sendEmptyMessage(0);
                }

                @Override
                public void onFailed(String string2) {
                }
            });
        });
    }

    private void startLocation() {
        if (this.sails != null) {
            this.sails.setGPSFloorLayer(this.project.getGpsFloorlayer() + "");
            this.sails.setGPSThresholdParameter(this.project.getInToOut(), this.project.getOutToIn(), this.project.getPowerThreshold());
            this.sails.setEnvironmentIsHighBeaconDensity(true);
            this.sails.setMode(2080);
            this.sails.startLocatingEngine();
            this.handler.sendEmptyMessageDelayed(1, TIME_OUT);
        }
    }

    private void stopLocation() {
        if (this.sails != null && this.sails.isLocationEngineStarted()) {
            this.sails.stopLocatingEngine();
        }
    }

    public String getNearestLocationRegion() {
        String string2;
        List<LocationRegion> list = this.sails.getCurrentInRegions();
        if (list != null && list.size() > 0) {
            LocationRegion locationRegion = list.get(0);
            String string3 = locationRegion.type;
            string2 = string3 != null && (string3.equals("freedom") || string3.equals("boundary") || string3.equals("lock")) ? this.getNearestLocationRegionFromAll() : list.get((int)0).label;
        } else {
            string2 = this.getNearestLocationRegionFromAll();
        }
        return string2;
    }

    private String getNearestLocationRegionFromAll() {
        List<LocationRegion> list;
        String string2 = "";
        ArrayList<LocationRegion> arrayList = this.getAllRegionList();
        if (this.sails.isInThisBuilding() && arrayList != null && (list = this.sails.sortLocationRegionsByPathLength(arrayList)) != null && list.size() > 0) {
            string2 = list.get((int)0).label;
        }
        return string2;
    }

    private ArrayList<LocationRegion> getAllRegionList() {
        ArrayList<LocationRegion> arrayList = new ArrayList<LocationRegion>();
        List<String> list = this.sails.getFloorNameList();
        if (list != null) {
            for (String string2 : list) {
                List<LocationRegion> list2 = this.sails.getLocationRegionList(string2);
                if (list2 == null) continue;
                for (LocationRegion locationRegion : list2) {
                    String string3;
                    if (locationRegion.type != null && ((string3 = locationRegion.type).equals("freedom") || string3.equals("boundary") || string3.equals("lock"))) continue;
                    arrayList.add(locationRegion);
                }
            }
        }
        return arrayList;
    }

    private void startNavTimerTask() {
        this.countTime = 0L;
        this.timerNav = new Timer();
        this.timerNav.schedule((TimerTask)new b(), 1000L, 1000L);
    }

    private void showPathRoute() {
        this.overlayItems.clear();
        this.sails.clearRouteCache();
        this.pathRoutingManager.enableHandler();
    }

    private void initRoutingManger() {
        this.pathRoutingManager = this.sailsMapView.getRoutingManager();
        this.pathRoutingManager.getPathPaint().setColor(-11955998);
        this.pathRoutingManager.getPathPaint().setStyle(Paint.Style.STROKE);
        this.pathRoutingManager.getPathPaint().setAlpha(255);
        this.pathRoutingManager.getPathPaint().setStrokeWidth(8.0f * ScreenDensity.density);
        this.pathRoutingManager.getPathPaint().setStrokeJoin(Paint.Join.ROUND);
        this.pathRoutingManager.getPathPaint().setStrokeCap(Paint.Cap.ROUND);
        this.pathRoutingManager.getPathPaint().setFilterBitmap(true);
        this.pathRoutingManager.getPathPaint().setAntiAlias(true);
        this.pathRoutingManager.getPathStrokePaint().setColor(0xFFFFFF);
        this.pathRoutingManager.getPathStrokePaint().setStyle(Paint.Style.STROKE);
        this.pathRoutingManager.getPathStrokePaint().setAlpha(200);
        this.pathRoutingManager.getPathStrokePaint().setStrokeWidth(13.0f * ScreenDensity.density);
        this.pathRoutingManager.getPathStrokePaint().setStrokeJoin(Paint.Join.ROUND);
        this.pathRoutingManager.getPathStrokePaint().setStrokeCap(Paint.Cap.ROUND);
        this.pathRoutingManager.getPathStrokePaint().setFilterBitmap(true);
        this.pathRoutingManager.getPathStrokePaint().setAntiAlias(true);
        this.pathRoutingManager.setRouteMode(6);
        this.pathRoutingManager.locationRegionCrossable(true);
        this.markerManager = this.sailsMapView.getMarkerManager();
        this.listOverlay = new ListOverlay();
        this.overlayItems = this.listOverlay.getOverlayItems();
        this.pathRoutingManager.setOnRoutingUpdateListener(new PathRoutingManager.OnRoutingUpdateListener(){

            @Override
            public void onArrived(LocationRegion locationRegion) {
            }

            @Override
            public void onRouteSuccess() {
                XJClient.this.isRouteSuccess = true;
                new Handler().postDelayed(() -> {
                    List<SAILS.GeoNode> list;
                    XJClient.this.sailsMapView.setMode(SAILSMapView.GENERAL);
                    int n2 = DensityUtils.getScreenWidth(XJClient.this.context) - DensityUtils.dp2px(XJClient.this.context, 160.0f);
                    XJClient.this.sailsMapView.autoSetMapZoomAndView(XJClient.this.pathRoutingManager.getCurrentFloorRoutingPathNodes(), n2);
                    XJClient.this.sailsMapView.setAnimatingToRotationAngle((float)XJClient.this.project.getAngle());
                    if (XJClient.this.navigationHandler != null) {
                        XJClient.this.navigationHandler.a();
                    }
                    if ((list = XJClient.this.pathRoutingManager.getCurrentAllPathNodes()) == null) {
                        return;
                    }
                    if (list.size() >= 10000) {
                        T.showShort(XJClient.this.context.getString(R.string.ipsmap_loction_error2));
                        XJClient.this.navStatus = 0;
                        return;
                    }
                    XJClient.this.navigationHandler = new com.locnavi.location.xunjimap.a.b(XJClient.this.sails, list);
                }, 100L);
            }

            @Override
            public void onRouteFail() {
                XJClient.this.isRouteSuccess = false;
            }

            @Override
            public void onPathDrawFinish() {
            }

            @Override
            public void onTotalDistanceRefresh(int n2) {
                if (XJClient.this.navStatus == 4 || XJClient.this.navStatus == 5) {
                    XJClient.this.currentDistance = n2;
                    if (n2 > 10000) {
                        return;
                    }
                    if (XJClient.this.navStatus == 4) {
                        String string2 = XJClient.this.context.getString(R.string.ipsmap_left) + n2 + XJClient.this.context.getString(R.string.ipsmap_left2) + IpsUtils.getDistanceTime(n2);
                        L.e("ddddd", "stance" + string2);
                    }
                }
            }

            @Override
            public void onReachNearestTransferDistanceRefresh(int n2, int n3) {
            }

            @Override
            public void onSwitchFloorInfoRefresh(List<PathRoutingManager.SwitchFloorInfo> list, int n2) {
            }

            @Override
            public void onPathRearranged() {
                if (XJClient.this.navMode != 0) {
                    XJClient.this.pathRoutingManager.enableHandler();
                    String string2 = "\u8def\u5f84\u91cd\u65b0\u89c4\u5212";
                    T.showShort(string2);
                }
            }
        });
    }

    private void uploadPunch(String string2, boolean bl) {
        if (bl && this.project != null && this.app != null) {
            Punch punch = new Punch();
            punch.put("floor", this.sails.getFloor());
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                punch.put("locationRegion", string2);
            }
            punch.put("lonlat", new ParseGeoPoint(this.sails.getLatitude(), this.sails.getLongitude()));
            if (this.userId != null) {
                punch.put("userId", this.userId);
            }
            punch.put("project", (Object)this.project);
            punch.put("app", (Object)this.app);
            punch.put("appName", Constants.getAppName(XJLocationSDK.context));
            punch.saveInBackground(parseException -> {
                if (parseException != null) {
                    L.e(this.context.getString(R.string.ipsmap_update_car_fail), parseException.getCause() + "  " + parseException.getMessage());
                } else {
                    L.e("eeee", this.context.getString(R.string.ipsmap_update_car_sucess));
                }
            });
        }
    }

    private void sendLocation() {
        XJLocation xJLocation = new XJLocation();
        xJLocation.setFloor(this.sails.getFloor());
        double d2 = this.sails.getLatitude();
        double d3 = this.sails.getLongitude();
        xJLocation.setLatitude(d2);
        xJLocation.setLongitude(d3);
        if ((int)d2 == 0 && (int)d3 == 0) {
            return;
        }
        xJLocation.setFloorDescription(this.sails.getFloorDescription(this.sails.getFloor()));
        boolean bl = this.sailsMapView.isInMap(new GeoPoint(this.sails.getLatitude(), this.sails.getLongitude()));
        xJLocation.setInThisMap(bl);
        this.ipsLocationListener.onReceiveLocation(xJLocation);
    }

    private void updateNavMode() {
        this.navMode = 1;
        if (this.sails != null && this.sailsMapView != null) {
            switch (this.navMode) {
                case 0: {
                    this.sails.setMode(10240);
                    break;
                }
                case 1: {
                    this.sails.setMode(2080);
                    break;
                }
                case 2: {
                    this.sails.setMode(2050);
                }
            }
            this.sailsMapView.setLocatorMarkerVisible(true);
            if (this.sails.isInThisBuilding()) {
                this.sailsMapView.setMode(SAILSMapView.LOCATION_CENTER_LOCK | SAILSMapView.FOLLOW_PHONE_HEADING);
            } else {
                this.sailsMapView.setMode(SAILSMapView.GENERAL);
            }
        }
    }

    private void initNavigation() {
        this.sails.startLocatingEngine();
    }

    private class a
    extends Handler {
        public void handleMessage(Message message) {
            super.handleMessage(message);
            switch (message.what) {
                case 0: {
                    XJClient.this.startLocation();
                    break;
                }
                case 1: {
                    if (XJClient.this.ipsLocationListener == null || XJClient.this.sails.isLocationFix()) break;
                    XJClient.this.ipsLocationListener.onReceiveLocation(null);
                    break;
                }
                case 2: {
                    XJClient.this.sendLocation();
                }
            }
        }
    }

    private class b
    extends TimerTask {
        private b() {
        }

        @Override
        public void run() {
            XJClient.this.countTime++;
            if (XJClient.this.navStatus == 6 || XJClient.this.navStatus == 0) {
                XJClient.this.timerNav.cancel();
            }
        }
    }
}

