/*
 * Decompiled with CFR 0.152.
 */
package com.locnavi.location.xunjimap.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Response;

public abstract class CallBackUtil<T> {
    public static Handler mMainHandler = new Handler(Looper.getMainLooper());

    public void onProgress(float f2, long l2) {
    }

    public void onError(final Call call, final Exception exception) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                CallBackUtil.this.onFailure(call, exception);
            }
        });
    }

    public void onSeccess(Call call, Response response) {
        final T t2 = this.onParseResponse(call, response);
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                CallBackUtil.this.onResponse(t2);
            }
        });
    }

    public abstract T onParseResponse(Call var1, Response var2);

    public abstract void onFailure(Call var1, Exception var2);

    public abstract void onResponse(T var1);

    public static abstract class CallBackFile
    extends CallBackUtil<File> {
        private final String mDestFileDir;
        private final String mdestFileName;

        public CallBackFile(String string2, String string3) {
            this.mDestFileDir = string2;
            this.mdestFileName = string3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File onParseResponse(Call call, Response response) {
            InputStream inputStream = null;
            byte[] byArray = new byte[8192];
            int n2 = 0;
            FileOutputStream fileOutputStream = null;
            try {
                inputStream = response.body().byteStream();
                final long l2 = response.body().contentLength();
                long l3 = 0L;
                File file = new File(this.mDestFileDir);
                if (!file.exists()) {
                    file.mkdirs();
                }
                File file2 = new File(file, this.mdestFileName);
                fileOutputStream = new FileOutputStream(file2);
                while ((n2 = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n2);
                    final long l4 = l3 += (long)n2;
                    mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            this.onProgress((float)l4 * 100.0f / (float)l2, l2);
                        }
                    });
                }
                fileOutputStream.flush();
                File file3 = file2;
                return file3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    response.body().close();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static abstract class CallBackBitmap
    extends CallBackUtil<Bitmap> {
        private int mTargetWidth;
        private int mTargetHeight;

        public CallBackBitmap() {
        }

        public CallBackBitmap(int n2, int n3) {
            this.mTargetWidth = n2;
            this.mTargetHeight = n3;
        }

        public CallBackBitmap(ImageView imageView) {
            int n2 = imageView.getWidth();
            int n3 = imageView.getHeight();
            if (n2 <= 0 || n3 <= 0) {
                throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6ImageView\u7684width\u6216height");
            }
            this.mTargetWidth = n2;
            this.mTargetHeight = n3;
        }

        @Override
        public Bitmap onParseResponse(Call call, Response response) {
            if (this.mTargetWidth == 0 || this.mTargetHeight == 0) {
                return BitmapFactory.decodeStream((InputStream)response.body().byteStream());
            }
            return this.getZoomBitmap(response);
        }

        private Bitmap getZoomBitmap(Response response) {
            byte[] byArray = null;
            try {
                byArray = response.body().bytes();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
            int n2 = options.outWidth;
            int n3 = options.outHeight;
            int n4 = 1;
            int n5 = (int)Math.floor((float)n2 / (float)this.mTargetWidth);
            int n6 = (int)Math.floor((float)n3 / (float)this.mTargetHeight);
            if (n5 > 1 || n6 > 1) {
                n4 = Math.max(n5, n6);
            }
            options.inSampleSize = n4;
            options.inJustDecodeBounds = false;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
            if (bitmap == null) {
                throw new RuntimeException("Failed to decode stream.");
            }
            return bitmap;
        }
    }

    public static abstract class CallBackString
    extends CallBackUtil<String> {
        @Override
        public String onParseResponse(Call call, Response response) {
            try {
                return response.body().string();
            }
            catch (IOException iOException) {
                new RuntimeException("failure");
                return "";
            }
        }
    }

    public static abstract class CallBackDefault
    extends CallBackUtil<Response> {
        @Override
        public Response onParseResponse(Call call, Response response) {
            return response;
        }
    }
}

