package com.locnavi.location.xunjimap.model.bean;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;

import java.util.Date;

/**
 * Created by liberty on 2017/4/27.
 */

public class LocationRegionData implements Parcelable, Comparable<LocationRegionData> {

    private String name ="";
    private String buildingName ="";
    private int floorNumber;
    private String floorName ="";
    private String floorDescription ="";
    private String type ="";
    private String subtype ="";
    private double longitude = 0;
    private double latitude = 0;
    private String objectId ="";
    private String deviceId ="";
    private Date createAt = new Date();
    private Date updatedAt = new Date();
    private double distanceTemp = 0;
    private int order = 0;
    private boolean isMe = false;
    private boolean selected = false;
    private boolean isFirst = false;
    private boolean isSameFloor = false;
    private boolean active = true;

    public boolean isSameFloor() {
        return isSameFloor;
    }

    public void setSameFloor(boolean sameFloor) {
        isSameFloor = sameFloor;
    }

    public boolean isFirst() {
        return isFirst;
    }

    public void setFirst(boolean first) {
        isFirst = first;
    }

    public String getFloorDescription() {
        return floorDescription;
    }

    public void setFloorDescription(String floorDescription) {
        this.floorDescription = floorDescription;
    }

    public String getBuildingName() {
        return buildingName;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubtype() {
        return subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isMe() {
        return isMe;
    }

    public void setMe(boolean me) {
        isMe = me;
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getObjectId() {
        return objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public Date getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public double getDistanceTemp() {
        return distanceTemp;
    }

    public void setDistanceTemp(double distanceTemp) {
        this.distanceTemp = distanceTemp;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public LocationRegionData() {
    }

    public LocationRegionData(String name, String floorName, double longitude, double latitude) {
        this.name = name;
        this.floorName = floorName;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public LocationRegionData(String name, String floorName, double longitude, double latitude, int order) {
        this.name = name;
        this.floorName = floorName;
        this.longitude = longitude;
        this.latitude = latitude;
        this.order = order;
    }

    public LocationRegionData(String name, String buildingName, String floorName,
                              String type, String subtype, double longitude, double latitude) {
        this.name = name;
        this.buildingName = buildingName;
        this.floorName = floorName;
        this.type = type;
        this.subtype = subtype;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public LocationRegionData(String name, String floorName) {
        this.name = name;
        this.floorName = floorName;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getFloorNumber() {
        return floorNumber;
    }

    public void setFloorNumber(int floorNumber) {
        this.floorNumber = floorNumber;
    }

    public String getFloorName() {
        return floorName;
    }

    public void setFloorName(String floorName) {
        this.floorName = floorName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LocationRegionData)) return false;

        LocationRegionData that = (LocationRegionData) o;

        if (getFloorNumber() != that.getFloorNumber()) return false;
        if (!getName().equals(that.getName())) return false;
        return getFloorName().equals(that.getFloorName());

    }

    @Override
    public int hashCode() {
        int result = getName().hashCode();
        result = 31 * result + getFloorNumber();
        result = 31 * result + getFloorName().hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "LocationRegionData{" +
                "name='" + name + '\'' +
                ", buildingName='" + buildingName + '\'' +
                ", floorNumber=" + floorNumber +
                ", floorName='" + floorName + '\'' +
                ", floorDescription='" + floorDescription + '\'' +
                ", type='" + type + '\'' +
                ", subtype='" + subtype + '\'' +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", objectId='" + objectId + '\'' +
                ", deviceId='" + deviceId + '\'' +
                ", createAt=" + createAt +
                ", updatedAt=" + updatedAt +
                ", distanceTemp=" + distanceTemp +
                ", order=" + order +
                ", isMe=" + isMe +
                ", selected=" + selected +
                ", isFirst=" + isFirst +
                ", isSameFloor=" + isSameFloor +
                ", active=" + active +
                '}';
    }

    @Override
    public int compareTo(@NonNull LocationRegionData o) {
        return this.order - o.getOrder();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.buildingName);
        dest.writeInt(this.floorNumber);
        dest.writeString(this.floorName);
        dest.writeString(this.floorDescription);
        dest.writeString(this.type);
        dest.writeString(this.subtype);
        dest.writeDouble(this.longitude);
        dest.writeDouble(this.latitude);
        dest.writeString(this.objectId);
        dest.writeString(this.deviceId);
        dest.writeLong(this.createAt != null ? this.createAt.getTime() : -1);
        dest.writeLong(this.updatedAt != null ? this.updatedAt.getTime() : -1);
        dest.writeDouble(this.distanceTemp);
        dest.writeInt(this.order);
        dest.writeByte(this.isMe ? (byte) 1 : (byte) 0);
        dest.writeByte(this.selected ? (byte) 1 : (byte) 0);
        dest.writeByte(this.isFirst ? (byte) 1 : (byte) 0);
        dest.writeByte(this.isSameFloor ? (byte) 1 : (byte) 0);
        dest.writeByte(this.active ? (byte) 1 : (byte) 0);
    }

    protected LocationRegionData(Parcel in) {
        this.name = in.readString();
        this.buildingName = in.readString();
        this.floorNumber = in.readInt();
        this.floorName = in.readString();
        this.floorDescription = in.readString();
        this.type = in.readString();
        this.subtype = in.readString();
        this.longitude = in.readDouble();
        this.latitude = in.readDouble();
        this.objectId = in.readString();
        this.deviceId = in.readString();
        long tmpCreateAt = in.readLong();
        this.createAt = tmpCreateAt == -1 ? null : new Date(tmpCreateAt);
        long tmpUpdatedAt = in.readLong();
        this.updatedAt = tmpUpdatedAt == -1 ? null : new Date(tmpUpdatedAt);
        this.distanceTemp = in.readDouble();
        this.order = in.readInt();
        this.isMe = in.readByte() != 0;
        this.selected = in.readByte() != 0;
        this.isFirst = in.readByte() != 0;
        this.isSameFloor = in.readByte() != 0;
        this.active = in.readByte() != 0;
    }

    public static final Creator<LocationRegionData> CREATOR = new Creator<LocationRegionData>() {
        @Override
        public LocationRegionData createFromParcel(Parcel source) {
            return new LocationRegionData(source);
        }

        @Override
        public LocationRegionData[] newArray(int size) {
            return new LocationRegionData[size];
        }
    };
}
