/*
 * Decompiled with CFR 0.152.
 */
package com.lmx.library.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.ArrayList;

public class ClearScreenLayout
extends FrameLayout {
    private int mDownX;
    private int mDownY;
    private int startX;
    private int translateX;
    private int endX;
    private boolean ifCleared;
    private VelocityTracker mVelocityTracker;
    private ValueAnimator mAnimator;
    private boolean leftSlide = true;
    private OnSlideClearListener slideClearListener;
    private ArrayList<View> listClearViews = new ArrayList();

    public ClearScreenLayout(Context context) {
        this(context, null);
    }

    public ClearScreenLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClearScreenLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        View view = new View(this.getContext());
        view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        view.setClickable(true);
        this.addView(view, 0);
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(200L);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ClearScreenLayout.this.translateChild((int)((float)ClearScreenLayout.this.translateX + value * (float)(ClearScreenLayout.this.endX - ClearScreenLayout.this.translateX)));
            }
        });
        this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (ClearScreenLayout.this.ifCleared && ClearScreenLayout.this.translateX == 0) {
                    if (ClearScreenLayout.this.slideClearListener != null) {
                        ClearScreenLayout.this.slideClearListener.onRestored();
                    }
                    ClearScreenLayout.this.ifCleared = !ClearScreenLayout.this.ifCleared;
                } else if (!ClearScreenLayout.this.ifCleared && Math.abs(ClearScreenLayout.this.translateX) == ClearScreenLayout.this.getWidth()) {
                    if (ClearScreenLayout.this.slideClearListener != null) {
                        ClearScreenLayout.this.slideClearListener.onCleared();
                    }
                    ClearScreenLayout.this.ifCleared = !ClearScreenLayout.this.ifCleared;
                }
            }
        });
    }

    public void setOnSlideListener(OnSlideClearListener slideListener) {
        this.slideClearListener = slideListener;
    }

    public void setSlideDirection(SlideDirection direction) {
        this.leftSlide = direction == SlideDirection.LEFT;
    }

    public void addClearViews(View ... views) {
        for (View cell : views) {
            if (this.listClearViews.contains(cell)) continue;
            this.listClearViews.add(cell);
        }
    }

    public void removeClearViews(View ... views) {
        for (View cell : views) {
            this.listClearViews.remove(cell);
        }
    }

    public void removeAllClearViews() {
        this.listClearViews.clear();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mDownX = x;
                this.mDownY = y;
                break;
            }
            case 2: {
                if (this.mAnimator.isRunning() || Math.abs(x - this.mDownX) <= Math.abs(y - this.mDownY)) break;
                this.startX = this.translateX;
                if (!(x - this.mDownX < -10 ? this.leftSlide && !this.ifCleared || !this.leftSlide && this.ifCleared : x - this.mDownX > 10 && (this.leftSlide && this.ifCleared || !this.leftSlide && !this.ifCleared))) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mVelocityTracker.addMovement(event);
        int x = (int)event.getX();
        int offsetX = x - this.mDownX;
        switch (event.getAction()) {
            case 2: {
                this.translateChild(this.startX + offsetX);
                return true;
            }
            case 1: {
                if (this.translateX != 0) {
                    this.mVelocityTracker.computeCurrentVelocity(10);
                    this.endX = Math.abs(offsetX) > this.getWidth() / 3 || this.mVelocityTracker.getXVelocity() > 20.0f && !this.leftSlide && !this.ifCleared || this.mVelocityTracker.getXVelocity() > 20.0f && this.leftSlide && this.ifCleared || this.mVelocityTracker.getXVelocity() < -20.0f && !this.leftSlide && this.ifCleared || this.mVelocityTracker.getXVelocity() < -20.0f && this.leftSlide && !this.ifCleared ? (this.ifCleared ? 0 : (this.leftSlide ? -this.getWidth() : this.getWidth())) : this.startX;
                }
                this.mAnimator.start();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void translateChild(int translate) {
        if (this.leftSlide && translate > 0 || !this.leftSlide && translate < 0) {
            translate = 0;
        }
        this.translateX = translate;
        for (int i = 0; i < this.listClearViews.size(); ++i) {
            this.listClearViews.get(i).setTranslationX((float)translate);
        }
    }

    public static enum SlideDirection {
        LEFT,
        RIGHT;

    }

    public static interface OnSlideClearListener {
        public void onCleared();

        public void onRestored();
    }
}

