/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.starter.data.es.utils;

import com.lmaye.app.common.context.PageResult;
import com.lmaye.app.common.query.ListQuery;
import com.lmaye.app.common.query.PageQuery;
import com.lmaye.app.common.query.Query;
import com.lmaye.app.common.query.Sort;
import com.lmaye.app.common.utils.GsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.util.CollectionUtils;

public final class ElasticSearchUtil {
    public static QueryBuilder convert(Query query) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!Objects.isNull(query) && !query.isNull()) {
            boolQueryBuilder.must(ElasticSearchUtil.convertQuery(query));
        }
        Query must = query.getMust();
        while (!Objects.isNull(must)) {
            if (!must.isNull()) {
                boolQueryBuilder.must(ElasticSearchUtil.convertQuery(must));
            }
            must = must.getMust();
        }
        Query should = query.getShould();
        while (!Objects.isNull(should)) {
            if (!should.isNull()) {
                boolQueryBuilder.should(ElasticSearchUtil.convertQuery(should));
            }
            should = should.getShould();
        }
        return boolQueryBuilder;
    }

    private static QueryBuilder convertQuery(Query query) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!CollectionUtils.isEmpty((Collection)query.getTerms())) {
            query.getTerms().forEach(q -> {
                if (q.isNegation()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)q.getField(), (Object)q.getValue()));
                } else {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)q.getField(), (Object)q.getValue()));
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)query.getMatches())) {
            query.getMatches().forEach(q -> {
                if (q.isNegation()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)q.getField(), (Object)q.getValue()));
                } else {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)q.getField(), (Object)q.getValue()));
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)query.getRanges())) {
            query.getRanges().forEach(q -> {
                if (q.isNegation()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.rangeQuery((String)q.getField()).gte(q.getGe()).lte(q.getLe()));
                } else {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)q.getField()).gte(q.getGe()).lte(q.getLe()));
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)query.getIns())) {
            query.getIns().forEach(q -> {
                if (q.isNegation()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)q.getField(), (Collection)q.getValues()));
                } else {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)q.getField(), (Collection)q.getValues()));
                }
            });
        }
        return boolQueryBuilder;
    }

    public static <T> List<T> searchScrollAll(RestHighLevelClient client, ListQuery query, long scrollAliveTime, Class<T> clazz) throws Exception {
        SearchRequest searchRequest = new SearchRequest();
        TimeValue keepAlive = TimeValue.timeValueMillis((long)scrollAliveTime);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        Sort sort = query.getSort();
        if (!Objects.isNull(sort) && !CollectionUtils.isEmpty((Collection)sort.getOrder())) {
            sort.getOrder().forEach(it -> searchSourceBuilder.sort(new FieldSortBuilder(it.getName()).order(Objects.equals(1, it.getAsc()) ? SortOrder.ASC : SortOrder.DESC)));
        }
        searchSourceBuilder.size(5000);
        searchSourceBuilder.query(ElasticSearchUtil.convert(query.getQuery()));
        Document doc = clazz.getAnnotation(Document.class);
        if (!Objects.isNull(doc) && StringUtils.isNotBlank((CharSequence)doc.indexName())) {
            searchRequest.indices(new String[]{doc.indexName()});
        }
        searchRequest.source(searchSourceBuilder);
        searchRequest.scroll(keepAlive);
        SearchResponse searchRs = client.search(searchRequest, RequestOptions.DEFAULT);
        Object[] hits = searchRs.getHits().getHits();
        if (ArrayUtils.isEmpty((Object[])hits)) {
            return new ArrayList();
        }
        ArrayList<Object> resultHits = new ArrayList<Object>();
        String scrollId = searchRs.getScrollId();
        while (ArrayUtils.isNotEmpty((Object[])hits)) {
            resultHits.addAll(Arrays.asList(hits));
            SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollId);
            searchScrollRequest.scroll(keepAlive);
            SearchResponse scrollRs = client.scroll(searchScrollRequest, RequestOptions.DEFAULT);
            scrollId = scrollRs.getScrollId();
            hits = scrollRs.getHits().getHits();
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        return resultHits.stream().map(it -> GsonUtils.fromJson((String)it.getSourceAsString(), (Class)clazz)).collect(Collectors.toList());
    }

    public static <T> PageResult<T> searchPage(RestHighLevelClient client, PageQuery query, Class<T> clazz) throws Exception {
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        Sort sort = query.getSort();
        if (!Objects.isNull(sort) && !CollectionUtils.isEmpty((Collection)sort.getOrder())) {
            sort.getOrder().forEach(it -> searchSourceBuilder.sort(new FieldSortBuilder(it.getName()).order(Objects.equals(1, it.getAsc()) ? SortOrder.ASC : SortOrder.DESC)));
        }
        searchSourceBuilder.query(ElasticSearchUtil.convert(query.getQuery()));
        int pageIndex = query.getPageIndex() - 1;
        Integer pageSize = query.getPageSize();
        searchSourceBuilder.from(pageIndex * pageSize);
        searchSourceBuilder.size(pageSize.intValue());
        Document doc = clazz.getAnnotation(Document.class);
        if (!Objects.isNull(doc) && StringUtils.isNotBlank((CharSequence)doc.indexName())) {
            searchRequest.indices(new String[]{doc.indexName()});
        }
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchRs = client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits searchHits = searchRs.getHits();
        SearchHit[] hits = searchHits.getHits();
        long total = searchHits.getTotalHits().value;
        long pages = (long)Math.ceil((float)total / (float)pageSize.intValue());
        return new PageResult().setPageIndex(Integer.valueOf(pageIndex)).setPageSize(pageSize).setPages(Long.valueOf(Objects.equals(0L, pages) ? 1L : pages)).setTotal(Long.valueOf(total)).setRecords(Arrays.stream(hits).map(it -> GsonUtils.fromJson((String)it.getSourceAsString(), (Class)clazz)).collect(Collectors.toList()));
    }

    public static <T> PageResult<T> searchScrollPage(RestHighLevelClient client, PageQuery query, long scrollAliveTime, Class<T> clazz) throws Exception {
        SearchRequest searchRequest = new SearchRequest();
        TimeValue keepAlive = TimeValue.timeValueMillis((long)scrollAliveTime);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        Sort sort = query.getSort();
        if (!Objects.isNull(sort) && !CollectionUtils.isEmpty((Collection)sort.getOrder())) {
            sort.getOrder().forEach(it -> searchSourceBuilder.sort(new FieldSortBuilder(it.getName()).order(Objects.equals(1, it.getAsc()) ? SortOrder.ASC : SortOrder.DESC)));
        }
        searchSourceBuilder.query(ElasticSearchUtil.convert(query.getQuery()));
        int pageIndex = query.getPageIndex() - 1;
        Integer pageSize = query.getPageSize();
        String scrollId = query.getScrollId();
        if (StringUtils.isBlank((CharSequence)scrollId)) {
            searchSourceBuilder.from(pageIndex);
            searchSourceBuilder.size(pageSize.intValue());
            Document doc = clazz.getAnnotation(Document.class);
            if (!Objects.isNull(doc) && StringUtils.isNotBlank((CharSequence)doc.indexName())) {
                searchRequest.indices(new String[]{doc.indexName()});
            }
            searchRequest.source(searchSourceBuilder);
            searchRequest.scroll(keepAlive);
            SearchResponse searchRs = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits searchHits = searchRs.getHits();
            Object[] hits = searchHits.getHits();
            if (ArrayUtils.isEmpty((Object[])hits)) {
                return new PageResult().setPageIndex(Integer.valueOf(pageIndex)).setPageSize(pageSize).setPages(Long.valueOf(1L)).setTotal(Long.valueOf(0L)).setRecords(new ArrayList());
            }
            query.setScrollId(searchRs.getScrollId());
            long total = searchHits.getTotalHits().value;
            long pages = (long)Math.ceil((float)total / (float)pageSize.intValue());
            return new PageResult().setPageIndex(Integer.valueOf(pageIndex)).setPageSize(pageSize).setPages(Long.valueOf(Objects.equals(0L, pages) ? 1L : pages)).setTotal(Long.valueOf(total)).setRecords(Arrays.stream(hits).map(it -> {
                Map map = it.getSourceAsMap();
                map.put("scrollId", searchRs.getScrollId());
                return GsonUtils.fromJson((String)GsonUtils.toJson((Object)map), (Class)clazz);
            }).collect(Collectors.toList()));
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollId);
        searchScrollRequest.scroll(keepAlive);
        SearchResponse searchRs = client.scroll(searchScrollRequest, RequestOptions.DEFAULT);
        SearchHits searchHits = searchRs.getHits();
        Object[] hits = searchHits.getHits();
        if (ArrayUtils.isEmpty((Object[])hits)) {
            return new PageResult().setPageIndex(Integer.valueOf(pageIndex)).setPageSize(pageSize).setPages(Long.valueOf(1L)).setTotal(Long.valueOf(0L)).setRecords(new ArrayList());
        }
        query.setScrollId(searchRs.getScrollId());
        long total = searchHits.getTotalHits().value;
        long pages = (long)Math.ceil((float)total / (float)pageSize.intValue());
        return new PageResult().setPageIndex(Integer.valueOf(pageIndex)).setPageSize(pageSize).setPages(Long.valueOf(Objects.equals(0L, pages) ? 1L : pages)).setTotal(Long.valueOf(total)).setRecords(Arrays.stream(hits).map(it -> {
            Map map = it.getSourceAsMap();
            map.put("scrollId", searchRs.getScrollId());
            return GsonUtils.fromJson((String)GsonUtils.toJson((Object)map), (Class)clazz);
        }).collect(Collectors.toList()));
    }

    private ElasticSearchUtil() {
    }
}

