/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.dsl;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.WorkerPool;
import com.lmax.disruptor.dsl.ConsumerInfo;
import com.lmax.disruptor.dsl.ConsumerRepository;
import com.lmax.disruptor.dsl.EventHandlerGroup;
import com.lmax.disruptor.dsl.ExceptionHandlerSetting;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class Disruptor<T> {
    private final RingBuffer<T> ringBuffer;
    private final Executor executor;
    private final ConsumerRepository<T> consumerRepository = new ConsumerRepository();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ExceptionHandler exceptionHandler;

    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, Executor executor) {
        this(RingBuffer.createMultiProducer(eventFactory, ringBufferSize), executor);
    }

    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, Executor executor, ProducerType producerType, WaitStrategy waitStrategy) {
        this(RingBuffer.create(producerType, eventFactory, ringBufferSize, waitStrategy), executor);
    }

    private Disruptor(RingBuffer<T> ringBuffer, Executor executor) {
        this.ringBuffer = ringBuffer;
        this.executor = executor;
    }

    public EventHandlerGroup<T> handleEventsWith(EventHandler<T> ... handlers) {
        return this.createEventProcessors(new Sequence[0], handlers);
    }

    public EventHandlerGroup<T> handleEventsWith(EventProcessor ... processors) {
        for (EventProcessor processor : processors) {
            this.consumerRepository.add(processor);
        }
        return new EventHandlerGroup<T>(this, this.consumerRepository, Util.getSequencesFor(processors));
    }

    public EventHandlerGroup<T> handleEventsWithWorkerPool(WorkHandler<T> ... workHandlers) {
        return this.createWorkerPool(new Sequence[0], workHandlers);
    }

    public void handleExceptionsWith(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandlerSetting<?> handleExceptionsFor(EventHandler<T> eventHandler) {
        return new ExceptionHandlerSetting<T>(eventHandler, this.consumerRepository);
    }

    public EventHandlerGroup<T> after(EventHandler<T> ... handlers) {
        Sequence[] sequences = new Sequence[handlers.length];
        int handlersLength = handlers.length;
        for (int i = 0; i < handlersLength; ++i) {
            sequences[i] = this.consumerRepository.getSequenceFor(handlers[i]);
        }
        return new EventHandlerGroup<T>(this, this.consumerRepository, sequences);
    }

    public EventHandlerGroup<T> after(EventProcessor ... processors) {
        for (EventProcessor processor : processors) {
            this.consumerRepository.add(processor);
        }
        return new EventHandlerGroup<T>(this, this.consumerRepository, Util.getSequencesFor(processors));
    }

    public void publishEvent(EventTranslator<T> eventTranslator) {
        this.ringBuffer.publishEvent(eventTranslator);
    }

    public RingBuffer<T> start() {
        Sequence[] gatingSequences = this.consumerRepository.getLastSequenceInChain();
        this.ringBuffer.addGatingSequences(gatingSequences);
        this.checkOnlyStartedOnce();
        for (ConsumerInfo consumerInfo : this.consumerRepository) {
            consumerInfo.start(this.executor);
        }
        return this.ringBuffer;
    }

    public void halt() {
        for (ConsumerInfo consumerInfo : this.consumerRepository) {
            consumerInfo.halt();
        }
    }

    public void shutdown() {
        while (this.hasBacklog()) {
        }
        this.halt();
    }

    public RingBuffer<T> getRingBuffer() {
        return this.ringBuffer;
    }

    public long getCursor() {
        return this.ringBuffer.getCursor();
    }

    public long getBufferSize() {
        return this.ringBuffer.getBufferSize();
    }

    public T get(long sequence) {
        return this.ringBuffer.getPublished(sequence);
    }

    public SequenceBarrier getBarrierFor(EventHandler<T> handler) {
        return this.consumerRepository.getBarrierFor(handler);
    }

    private boolean hasBacklog() {
        long cursor = this.ringBuffer.getCursor();
        for (Sequence consumer : this.consumerRepository.getLastSequenceInChain()) {
            if (cursor <= consumer.get()) continue;
            return true;
        }
        return false;
    }

    EventHandlerGroup<T> createEventProcessors(Sequence[] barrierSequences, EventHandler<T>[] eventHandlers) {
        this.checkNotStarted();
        Sequence[] processorSequences = new Sequence[eventHandlers.length];
        SequenceBarrier barrier = this.ringBuffer.newBarrier(barrierSequences);
        for (EventHandler<T> eventHandler : eventHandlers) {
            BatchEventProcessor<T> batchEventProcessor = new BatchEventProcessor<T>(this.ringBuffer, barrier, eventHandler);
            if (this.exceptionHandler != null) {
                batchEventProcessor.setExceptionHandler(this.exceptionHandler);
            }
            this.consumerRepository.add(batchEventProcessor, eventHandler, barrier);
            processorSequences[i] = batchEventProcessor.getSequence();
        }
        if (processorSequences.length > 0) {
            this.consumerRepository.unMarkEventProcessorsAsEndOfChain(barrierSequences);
        }
        return new EventHandlerGroup<T>(this, this.consumerRepository, processorSequences);
    }

    EventHandlerGroup<T> createWorkerPool(Sequence[] barrierSequences, WorkHandler<T>[] workHandlers) {
        SequenceBarrier sequenceBarrier = this.ringBuffer.newBarrier(barrierSequences);
        WorkerPool<T> workerPool = new WorkerPool<T>(this.ringBuffer, sequenceBarrier, this.exceptionHandler, workHandlers);
        this.consumerRepository.add(workerPool, sequenceBarrier);
        return new EventHandlerGroup<T>(this, this.consumerRepository, workerPool.getWorkerSequences());
    }

    private void checkNotStarted() {
        if (this.started.get()) {
            throw new IllegalStateException("All event handlers must be added before calling starts.");
        }
    }

    private void checkOnlyStartedOnce() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Disruptor.start() must only be called once.");
        }
    }
}

