/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.Sequencer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.locks.LockSupport;

class MultiProducerSequencer
implements Sequencer {
    private final int bufferSize;
    private final WaitStrategy waitStrategy;
    private final Sequence cursor = new Sequence(-1L);
    private final Sequence gatingSequenceCache = new Sequence(-1L);

    public MultiProducerSequencer(int bufferSize, WaitStrategy waitStrategy) {
        this.bufferSize = bufferSize;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    Sequence getCursorSequence() {
        return this.cursor;
    }

    @Override
    public boolean hasAvailableCapacity(Sequence[] gatingSequences, int requiredCapacity) {
        return this.hasAvailableCapacity(gatingSequences, requiredCapacity, this.cursor.get());
    }

    private boolean hasAvailableCapacity(Sequence[] gatingSequences, int requiredCapacity, long cursorValue) {
        long wrapPoint = cursorValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.gatingSequenceCache.get();
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > cursorValue) {
            long minSequence = Util.getMinimumSequence(gatingSequences, cursorValue);
            this.gatingSequenceCache.set(minSequence);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void claim(long sequence) {
        this.cursor.set(sequence);
    }

    @Override
    public long next(Sequence[] gatingSequences) {
        long next;
        while (true) {
            long cachedGatingSequence;
            long current;
            long wrapPoint;
            if ((wrapPoint = (next = (current = this.cursor.get()) + 1L) - (long)this.bufferSize) > (cachedGatingSequence = this.gatingSequenceCache.get()) || cachedGatingSequence > current) {
                long gatingSequence = Util.getMinimumSequence(gatingSequences, current);
                if (wrapPoint > gatingSequence) {
                    LockSupport.parkNanos(1L);
                    continue;
                }
                this.gatingSequenceCache.set(gatingSequence);
                continue;
            }
            if (this.cursor.compareAndSet(current, next)) break;
        }
        return next;
    }

    @Override
    public long tryNext(Sequence[] gatingSequences) throws InsufficientCapacityException {
        long next;
        long current;
        do {
            current = this.cursor.get();
            next = current + 1L;
            if (this.hasAvailableCapacity(gatingSequences, 1, current)) continue;
            throw InsufficientCapacityException.INSTANCE;
        } while (!this.cursor.compareAndSet(current, next));
        return next;
    }

    @Override
    public long remainingCapacity(Sequence[] gatingSequences) {
        long consumed = Util.getMinimumSequence(gatingSequences, this.cursor.get());
        long produced = this.cursor.get();
        return (long)this.getBufferSize() - (produced - consumed);
    }
}

