/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.Publisher;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;
import sun.misc.Unsafe;

class MultiProducerPublisher
implements Publisher {
    private static final Unsafe UNSAFE = Util.getUnsafe();
    private static final long base = UNSAFE.arrayBaseOffset(int[].class);
    private static final long scale = UNSAFE.arrayIndexScale(int[].class);
    private final WaitStrategy waitStrategy;
    private final int[] availableBuffer;
    private final int indexMask;
    private final int indexShift;

    public MultiProducerPublisher(int bufferSize, WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
        this.availableBuffer = new int[bufferSize];
        this.indexMask = bufferSize - 1;
        this.indexShift = Util.log2(bufferSize);
        this.initialiseAvailableBuffer();
    }

    private void initialiseAvailableBuffer() {
        for (int i = this.availableBuffer.length - 1; i != 0; --i) {
            this.setAvailableBufferValue(i, -1);
        }
        this.setAvailableBufferValue(0, -1);
    }

    @Override
    public void publish(long sequence) {
        this.setAvailable(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    private void setAvailable(long sequence) {
        this.setAvailableBufferValue(this.calculateIndex(sequence), this.calculateAvailabilityFlag(sequence));
    }

    private void setAvailableBufferValue(int index, int flag) {
        long bufferAddress = (long)index * scale + base;
        UNSAFE.putOrderedInt(this.availableBuffer, bufferAddress, flag);
    }

    @Override
    public void ensureAvailable(long sequence) {
        int index = this.calculateIndex(sequence);
        int flag = this.calculateAvailabilityFlag(sequence);
        long bufferAddress = (long)index * scale + base;
        while (UNSAFE.getIntVolatile(this.availableBuffer, bufferAddress) != flag) {
            assert (UNSAFE.getIntVolatile(this.availableBuffer, bufferAddress) <= flag);
        }
    }

    @Override
    public boolean isAvailable(long sequence) {
        int index = this.calculateIndex(sequence);
        int flag = this.calculateAvailabilityFlag(sequence);
        long bufferAddress = (long)index * scale + base;
        return UNSAFE.getIntVolatile(this.availableBuffer, bufferAddress) == flag;
    }

    private int calculateAvailabilityFlag(long sequence) {
        return (int)(sequence >>> this.indexShift);
    }

    private int calculateIndex(long sequence) {
        return (int)sequence & this.indexMask;
    }
}

