/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.util;

import com.ljy.devring.DevRing;
import com.ljy.devring.base.activity.ActivityLife;
import com.ljy.devring.base.activity.IBaseActivity;
import com.ljy.devring.base.fragment.FragmentLife;
import com.ljy.devring.base.fragment.IBaseFragment;
import com.ljy.devring.util.Preconditions;
import com.trello.rxlifecycle3.LifecycleTransformer;
import com.trello.rxlifecycle3.RxLifecycle;
import com.trello.rxlifecycle3.android.ActivityEvent;
import com.trello.rxlifecycle3.android.FragmentEvent;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.subjects.PublishSubject;

public class RxLifecycleUtil {
    public static <T> LifecycleTransformer<T> bindUntilEvent(@NonNull Object lifecycleEmitter, ActivityEvent event) {
        Preconditions.checkNotNull(lifecycleEmitter, "lifecycleEmitter\u4e0d\u80fd\u4e3a\u7a7a");
        if (lifecycleEmitter instanceof IBaseActivity) {
            return RxLifecycleUtil.RxBindUntilEvent(RxLifecycleUtil.getActivityLifeSubject(lifecycleEmitter.toString()), event);
        }
        throw new IllegalArgumentException("lifecycleEmitter\u9700\u4e3a\u5b9e\u73b0IBaseActivity\u7684Object");
    }

    public static <T> LifecycleTransformer<T> bindUntilEvent(@NonNull Object lifecycleEmitter, FragmentEvent event) {
        Preconditions.checkNotNull(lifecycleEmitter, "lifecycleEmitter\u4e0d\u80fd\u4e3a\u7a7a");
        if (lifecycleEmitter instanceof IBaseFragment) {
            return RxLifecycleUtil.RxBindUntilEvent(RxLifecycleUtil.getFragmentLifeSubject(lifecycleEmitter.toString()), event);
        }
        throw new IllegalArgumentException("lifecycleEmitter\u9700\u4e3a\u5b9e\u73b0IBaseFragment\u7684Object");
    }

    public static <T> LifecycleTransformer<T> bindUntilDestroy(@NonNull Object lifecycleEmitter) {
        Preconditions.checkNotNull(lifecycleEmitter, "lifecycleEmitter\u4e0d\u80fd\u4e3a\u7a7a");
        if (lifecycleEmitter instanceof IBaseActivity) {
            return RxLifecycleUtil.RxBindUntilEvent(RxLifecycleUtil.getActivityLifeSubject(lifecycleEmitter.toString()), ActivityEvent.DESTROY);
        }
        if (lifecycleEmitter instanceof IBaseFragment) {
            return RxLifecycleUtil.RxBindUntilEvent(RxLifecycleUtil.getFragmentLifeSubject(lifecycleEmitter.toString()), FragmentEvent.DESTROY);
        }
        throw new IllegalArgumentException("\u5982\u679c\u8bf7\u6c42\u5728Activity\u4e2d\u53d1\u8d77\uff0c\u5219lifecycleEmitter\u9700\u4e3a\u5b9e\u73b0IBaseActivity\u7684Object\uff0c\u5982\u679c\u5728Fragment\u4e2d\u53d1\u8d77\uff0c\u5219lifecycleEmitter\u9700\u4e3a\u5b9e\u73b0IBaseFragment\u7684Object");
    }

    public static <T, R> LifecycleTransformer<T> RxBindUntilEvent(@NonNull Observable<R> lifecycleEmitter, R event) {
        Preconditions.checkNotNull(lifecycleEmitter, "lifecycleEmitter == null");
        return RxLifecycle.bindUntilEvent(lifecycleEmitter, event);
    }

    private static PublishSubject<ActivityEvent> getActivityLifeSubject(String key) {
        ActivityLife activityLife = DevRing.ringComponent().activityLifeCallback().getActivityLife(key);
        if (activityLife == null) {
            throw new IllegalArgumentException("\u8bf7\u786e\u4fdd\u8be5Activity\u5b9e\u73b0\u4e86IBaseActivity\u63a5\u53e3");
        }
        return activityLife.getLifecycleSubject();
    }

    private static PublishSubject<FragmentEvent> getFragmentLifeSubject(String key) {
        FragmentLife fragmentLife = DevRing.ringComponent().fragmentLifeCallback().getFragmentLife(key);
        if (fragmentLife == null) {
            throw new IllegalArgumentException("\u8bf7\u786e\u4fddFragment\u6240\u5728\u7684Activity\u7684isUseFragment()\u65b9\u6cd5\u8fd4\u56de\u4e3atrue");
        }
        return fragmentLife.getLifecycleSubject();
    }
}

