/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import java.lang.reflect.Field;

public class FontTypeUtil {
    public static void replaceFont(@NonNull Activity context, String fontPath) {
        FontTypeUtil.replaceFont(FontTypeUtil.getRootView(context), fontPath);
    }

    public static void replaceFont(@NonNull View root, String fontPath) {
        if (root == null || TextUtils.isEmpty((CharSequence)fontPath)) {
            return;
        }
        if (root instanceof TextView) {
            TextView textView = (TextView)root;
            int style = 0;
            if (textView.getTypeface() != null) {
                style = textView.getTypeface().getStyle();
            }
            textView.setTypeface(FontTypeUtil.createTypeface(root.getContext(), fontPath), style);
        } else if (root instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)root;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                FontTypeUtil.replaceFont(viewGroup.getChildAt(i), fontPath);
            }
        }
    }

    public static Typeface createTypeface(Context context, String fontPath) {
        return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontPath);
    }

    public static View getRootView(Activity context) {
        return ((ViewGroup)context.findViewById(0x1020002)).getChildAt(0);
    }

    public static void replaceSystemDefaultFont(@NonNull Context context, @NonNull String fontPath) {
        FontTypeUtil.replaceTypefaceField("MONOSPACE", FontTypeUtil.createTypeface(context, fontPath));
    }

    private static void replaceTypefaceField(String fieldName, Object value) {
        try {
            Field defaultField = Typeface.class.getDeclaredField(fieldName);
            defaultField.setAccessible(true);
            defaultField.set(null, value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

