/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.drawerlayout.widget.DrawerLayout;
import com.ljy.devring.util.ConfigUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BarUtil {
    private static final int TYPE_COLOR = 1;
    private static final int TYPE_TRANSPARENT = 2;
    private static final int TYPE_IMMERSION = 3;
    private static final int TYPE_DRAWER = 4;
    private static final int TYPE_HIDE = 5;
    private Activity activity;
    private int type;
    private ColorBuilder colorBuilder;
    private TransparentBuilder transparentBuilder;
    private ImmersionBuilder immersionBuilder;
    private DrawerBuilder drawerBuilder;
    private HideBuilder hideBuilder;

    public BarUtil(Activity activity) {
        this.activity = activity;
    }

    private BarUtil(Activity activity, ColorBuilder builder) {
        this.activity = activity;
        this.type = 1;
        this.colorBuilder = builder;
    }

    private BarUtil(Activity activity, TransparentBuilder builder) {
        this.activity = activity;
        this.type = 2;
        this.transparentBuilder = builder;
    }

    private BarUtil(Activity activity, ImmersionBuilder builder) {
        this.activity = activity;
        this.type = 3;
        this.immersionBuilder = builder;
    }

    private BarUtil(Activity activity, DrawerBuilder builder) {
        this.activity = activity;
        this.type = 4;
        this.drawerBuilder = builder;
    }

    private BarUtil(Activity activity, HideBuilder builder) {
        this.activity = activity;
        this.type = 5;
        this.hideBuilder = builder;
    }

    public static ColorBuilder newColorBuilder() {
        return new ColorBuilder();
    }

    public static TransparentBuilder newTransparentBuilder() {
        return new TransparentBuilder();
    }

    public static ImmersionBuilder newImmersionBuilder() {
        return new ImmersionBuilder();
    }

    public static DrawerBuilder newDrawerBuilder() {
        return new DrawerBuilder();
    }

    public static HideBuilder newHideBuilder() {
        return new HideBuilder();
    }

    public void apply() {
        if (this.type == 1) {
            this.setColorBar(this.colorBuilder.statusColor, this.colorBuilder.statusAlpha, this.colorBuilder.applyNav, this.colorBuilder.navColor, this.colorBuilder.navAlpha);
        } else if (this.type == 2) {
            this.setTransparentBar(this.transparentBuilder.statusColor, this.transparentBuilder.statusAlpha, this.transparentBuilder.applyNav, this.transparentBuilder.navColor, this.transparentBuilder.navAlpha);
        } else if (this.type == 3) {
            this.setTransparentBar(0, 0, this.immersionBuilder.applyNav, 0, 0);
        } else if (this.type == 4) {
            this.setColorBarForDrawer(this.drawerBuilder.statusColor, this.drawerBuilder.statusAlpha, this.drawerBuilder.applyNav, this.drawerBuilder.navColor, this.drawerBuilder.navAlpha);
        } else if (this.type == 5) {
            this.setHideBar(this.hideBuilder.applyNav);
        }
    }

    @TargetApi(value=19)
    public void setColorBar(@ColorInt int statusColor, int statusDepth, @ColorInt int navColor, int navDepth) {
        this.setColorBar(statusColor, statusDepth, true, navColor, navDepth);
    }

    @TargetApi(value=19)
    public void setColorBar(@ColorInt int statusColor, @ColorInt int navColor) {
        this.setColorBar(statusColor, 0, navColor, 0);
    }

    @TargetApi(value=19)
    private void setHideBar(boolean applyNav) {
        if (Build.VERSION.SDK_INT >= 19) {
            View decorView = this.activity.getWindow().getDecorView();
            int option = 5380;
            if (applyNav) {
                option = option | 0x200 | 2;
            }
            decorView.setSystemUiVisibility(option);
        }
    }

    @TargetApi(value=19)
    private void setColorBar(@ColorInt int statusColor, int statusDepth, boolean applyNav, @ColorInt int navColor, int navDepth) {
        int realStatusAlpha = this.limitDepthOrAlpha(statusDepth);
        int realNavDepth = this.limitDepthOrAlpha(navDepth);
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            int finalStatusColor = Color.argb((int)realStatusAlpha, (int)Color.red((int)statusColor), (int)Color.green((int)statusColor), (int)Color.blue((int)statusColor));
            window.setStatusBarColor(finalStatusColor);
            if (applyNav) {
                int finalNavColor = Color.argb((int)realNavDepth, (int)Color.red((int)navColor), (int)Color.green((int)navColor), (int)Color.blue((int)navColor));
                window.clearFlags(0x8000000);
                window.setNavigationBarColor(finalNavColor);
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = this.activity.getWindow();
            window.addFlags(0x4000000);
            int finalStatusColor = Color.argb((int)realStatusAlpha, (int)Color.red((int)statusColor), (int)Color.green((int)statusColor), (int)Color.blue((int)statusColor));
            ViewGroup decorView = (ViewGroup)window.getDecorView();
            decorView.addView(this.createStatusBarView((Context)this.activity, finalStatusColor));
            if (applyNav && this.navigationBarExist(this.activity)) {
                int finalNavColor = Color.argb((int)realNavDepth, (int)Color.red((int)navColor), (int)Color.green((int)navColor), (int)Color.blue((int)navColor));
                window.addFlags(0x8000000);
                decorView.addView(this.createNavBarView((Context)this.activity, finalNavColor));
            }
            this.setRootView(this.activity, true);
        }
    }

    @TargetApi(value=19)
    private void setTransparentBar(@ColorInt int statusColor, int statusAlpha, boolean applyNav, @ColorInt int navColor, int navAlpha) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.activity.getWindow();
            View decorView = window.getDecorView();
            int option = 1280;
            int finalStatusColor = statusColor == 0 ? 0 : Color.argb((int)this.limitDepthOrAlpha(statusAlpha), (int)Color.red((int)statusColor), (int)Color.green((int)statusColor), (int)Color.blue((int)statusColor));
            window.setStatusBarColor(finalStatusColor);
            if (applyNav) {
                option |= 0x200;
                int finalNavColor = navColor == 0 ? 0 : Color.argb((int)this.limitDepthOrAlpha(navAlpha), (int)Color.red((int)navColor), (int)Color.green((int)navColor), (int)Color.blue((int)navColor));
                window.setNavigationBarColor(finalNavColor);
            }
            decorView.setSystemUiVisibility(option);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = this.activity.getWindow();
            window.addFlags(0x4000000);
            ViewGroup decorView = (ViewGroup)window.getDecorView();
            int finalStatusColor = statusColor == 0 ? 0 : Color.argb((int)this.limitDepthOrAlpha(statusAlpha), (int)Color.red((int)statusColor), (int)Color.green((int)statusColor), (int)Color.blue((int)statusColor));
            decorView.addView(this.createStatusBarView((Context)this.activity, finalStatusColor));
            if (applyNav && this.navigationBarExist(this.activity)) {
                window.addFlags(0x8000000);
                int finalNavColor = navColor == 0 ? 0 : Color.argb((int)this.limitDepthOrAlpha(navAlpha), (int)Color.red((int)navColor), (int)Color.green((int)navColor), (int)Color.blue((int)navColor));
                decorView.addView(this.createNavBarView((Context)this.activity, finalNavColor));
            }
        }
    }

    @TargetApi(value=19)
    private void setColorBarForDrawer(@ColorInt int statusColor, int statusDepth, boolean applyNav, @ColorInt int navColor, int navDepth) {
        int realStatusDepth = this.limitDepthOrAlpha(statusDepth);
        int realNavDepth = this.limitDepthOrAlpha(navDepth);
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            int finalStatusColor = Color.argb((int)realStatusDepth, (int)Color.red((int)statusColor), (int)Color.green((int)statusColor), (int)Color.blue((int)statusColor));
            window.setStatusBarColor(finalStatusColor);
            if (applyNav) {
                int finalNavColor = Color.argb((int)realNavDepth, (int)Color.red((int)navColor), (int)Color.green((int)navColor), (int)Color.blue((int)navColor));
                window.clearFlags(0x8000000);
                window.setNavigationBarColor(finalNavColor);
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = this.activity.getWindow();
            window.addFlags(0x4000000);
            ViewGroup decorView = (ViewGroup)window.getDecorView();
            int finalStatusColor = Color.argb((int)realStatusDepth, (int)Color.red((int)statusColor), (int)Color.green((int)statusColor), (int)Color.blue((int)statusColor));
            decorView.addView(this.createStatusBarView((Context)this.activity, finalStatusColor));
            if (applyNav && this.navigationBarExist(this.activity)) {
                window.addFlags(0x8000000);
                int finalNavColor = Color.argb((int)realNavDepth, (int)Color.red((int)navColor), (int)Color.green((int)navColor), (int)Color.blue((int)navColor));
                decorView.addView(this.createNavBarView((Context)this.activity, finalNavColor));
            }
            this.handleFitWindowForDrawer(this.activity, true);
        }
    }

    private void handleFitWindowForDrawer(Activity activity, boolean fit) {
        ViewGroup parent = (ViewGroup)activity.findViewById(0x1020002);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View childView = parent.getChildAt(i);
            if (!(childView instanceof DrawerLayout)) continue;
            childView.setFitsSystemWindows(!fit);
            ((ViewGroup)childView).setClipToPadding(!fit);
            View childViewOfDrawer = ((DrawerLayout)childView).getChildAt(0);
            if (!(childViewOfDrawer instanceof ViewGroup)) continue;
            childViewOfDrawer.setFitsSystemWindows(fit);
            ((ViewGroup)childViewOfDrawer).setClipToPadding(fit);
        }
    }

    private int limitDepthOrAlpha(int depthOrAlpha) {
        if (depthOrAlpha < 0) {
            return 0;
        }
        if (depthOrAlpha > 255) {
            return 255;
        }
        return depthOrAlpha;
    }

    private View createStatusBarView(Context context, @ColorInt int color) {
        View statusBarView = new View(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, ConfigUtil.getStatusBarHeight(context));
        params.gravity = 48;
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(color);
        return statusBarView;
    }

    private View createNavBarView(Context context, @ColorInt int color) {
        View navBarView = new View(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, ConfigUtil.getNavigationBarHeight(context));
        params.gravity = 80;
        navBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        navBarView.setBackgroundColor(color);
        return navBarView;
    }

    private boolean navigationBarExist(Activity activity) {
        WindowManager windowManager = activity.getWindowManager();
        Display d = windowManager.getDefaultDisplay();
        DisplayMetrics realDisplayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            d.getRealMetrics(realDisplayMetrics);
        }
        int realHeight = realDisplayMetrics.heightPixels;
        int realWidth = realDisplayMetrics.widthPixels;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        d.getMetrics(displayMetrics);
        int displayHeight = displayMetrics.heightPixels;
        int displayWidth = displayMetrics.widthPixels;
        return realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
    }

    @ColorInt
    private int calculateColor(@ColorInt int color, int alpha) {
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private void setRootView(Activity activity, boolean fit) {
        ViewGroup parent = (ViewGroup)activity.findViewById(0x1020002);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View childView = parent.getChildAt(i);
            if (!(childView instanceof ViewGroup)) continue;
            childView.setFitsSystemWindows(fit);
            ((ViewGroup)childView).setClipToPadding(fit);
        }
    }

    public static boolean setStatusBarLightMode(Activity activity, boolean isDark) {
        boolean result = false;
        if (Build.VERSION.SDK_INT >= 19) {
            if (BarUtil.setMiuiStatusBarLightMode(activity.getWindow(), isDark)) {
                result = true;
            } else if (BarUtil.setFlymeStatusBarLightMode(activity.getWindow(), isDark)) {
                result = true;
            } else if (Build.VERSION.SDK_INT >= 23) {
                BarUtil.setAndroid6StatusBarLightMode(activity.getWindow(), isDark);
                result = true;
            }
        }
        return result;
    }

    private static boolean setFlymeStatusBarLightMode(Window window, boolean isDark) {
        boolean result = false;
        if (window != null) {
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = isDark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    private static boolean setMiuiStatusBarLightMode(Window window, boolean isDark) {
        boolean result = false;
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (isDark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
                if (Build.VERSION.SDK_INT >= 23) {
                    BarUtil.setAndroid6StatusBarLightMode(window, isDark);
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    private static void setAndroid6StatusBarLightMode(Window window, boolean isDark) {
        if (isDark) {
            window.getDecorView().setSystemUiVisibility(8192);
        } else {
            window.getDecorView().setSystemUiVisibility(0);
        }
    }

    public static class HideBuilder {
        private boolean applyNav;

        public HideBuilder applyNav(boolean applyNav) {
            this.applyNav = applyNav;
            return this;
        }

        public BarUtil build(Activity activity) {
            return new BarUtil(activity, this);
        }
    }

    public static class DrawerBuilder {
        @ColorInt
        private int statusColor;
        private int statusAlpha = 255;
        private boolean applyNav;
        @ColorInt
        private int navColor;
        private int navAlpha = 255;

        public DrawerBuilder statusColor(@ColorInt int statusColor) {
            this.statusColor = statusColor;
            return this;
        }

        public DrawerBuilder statusAlpha(int statusAlpha) {
            this.statusAlpha = statusAlpha;
            return this;
        }

        public DrawerBuilder applyNav(boolean applyNav) {
            this.applyNav = applyNav;
            return this;
        }

        public DrawerBuilder navColor(@ColorInt int navColor) {
            this.navColor = navColor;
            return this;
        }

        public DrawerBuilder navAlpha(int navAlpha) {
            this.navAlpha = navAlpha;
            return this;
        }

        public BarUtil build(Activity activity) {
            return new BarUtil(activity, this);
        }
    }

    public static class ImmersionBuilder {
        private boolean applyNav;

        public ImmersionBuilder applyNav(boolean applyNav) {
            this.applyNav = applyNav;
            return this;
        }

        public BarUtil build(Activity activity) {
            return new BarUtil(activity, this);
        }
    }

    public static class TransparentBuilder {
        @ColorInt
        private int statusColor;
        private int statusAlpha;
        private boolean applyNav;
        @ColorInt
        private int navColor;
        private int navAlpha;

        public TransparentBuilder statusColor(@ColorInt int statusColor) {
            this.statusColor = statusColor;
            return this;
        }

        public TransparentBuilder statusAlpha(int statusAlpha) {
            this.statusAlpha = statusAlpha;
            return this;
        }

        public TransparentBuilder applyNav(boolean applyNav) {
            this.applyNav = applyNav;
            return this;
        }

        public TransparentBuilder navColor(@ColorInt int navColor) {
            this.navColor = navColor;
            return this;
        }

        public TransparentBuilder navAlpha(int navAlpha) {
            this.navAlpha = navAlpha;
            return this;
        }

        public BarUtil build(Activity activity) {
            return new BarUtil(activity, this);
        }
    }

    public static class ColorBuilder {
        @ColorInt
        private int statusColor;
        private int statusAlpha = 255;
        private boolean applyNav;
        @ColorInt
        private int navColor;
        private int navAlpha = 255;

        public ColorBuilder statusColor(@ColorInt int statusColor) {
            this.statusColor = statusColor;
            return this;
        }

        public ColorBuilder statusAlpha(int statusAlpha) {
            this.statusAlpha = statusAlpha;
            return this;
        }

        public ColorBuilder applyNav(boolean applyNav) {
            this.applyNav = applyNav;
            return this;
        }

        public ColorBuilder navColor(@ColorInt int navColor) {
            this.navColor = navColor;
            return this;
        }

        public ColorBuilder navAlpha(int navAlpha) {
            this.navAlpha = navAlpha;
            return this;
        }

        public BarUtil build(Activity activity) {
            return new BarUtil(activity, this);
        }
    }
}

