/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.other.toast;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.ljy.devring.logger.RingLog;
import com.ljy.devring.other.toast.IToastStyle;
import com.ljy.devring.other.toast.XToast;
import com.ljy.devring.util.DensityUtil;

public class RingToast {
    private static IToastStyle mToastStyle;
    private static Toast mToast;
    private static Context mContext;

    public static void init(Context context) {
        if (context != context.getApplicationContext()) {
            context = context.getApplicationContext();
        }
        mContext = context;
        if (mToastStyle != null) {
            TextView textView;
            mToast = new XToast(context);
            mToast.setGravity(mToastStyle.getGravity(), mToastStyle.getXOffset(), mToastStyle.getYOffset());
            View customView = mToastStyle.getCustomToastView();
            if (customView != null) {
                mToast.setView(customView);
                textView = ((XToast)mToast).getTextView();
            } else {
                textView = new TextView(context);
            }
            textView.setTextColor(mToastStyle.getTextColor());
            textView.setTextSize(0, (float)DensityUtil.sp2px(context, mToastStyle.getTextSize()));
            textView.setPadding(DensityUtil.dp2px(context, mToastStyle.getPaddingLeft()), DensityUtil.dp2px(context, mToastStyle.getPaddingTop()), DensityUtil.dp2px(context, mToastStyle.getPaddingRight()), DensityUtil.dp2px(context, mToastStyle.getPaddingBottom()));
            GradientDrawable drawable = new GradientDrawable();
            drawable.setColor(mToastStyle.getBackgroundColor());
            drawable.setCornerRadius((float)DensityUtil.dp2px(context, mToastStyle.getCornerRadius()));
            if (Build.VERSION.SDK_INT >= 16) {
                textView.setBackground((Drawable)drawable);
            } else {
                textView.setBackgroundDrawable((Drawable)drawable);
            }
            if (mToastStyle.getMaxLines() > 0) {
                textView.setMaxLines(mToastStyle.getMaxLines());
                textView.setEllipsize(TextUtils.TruncateAt.END);
            }
            if (customView == null) {
                textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
                mToast.setView((View)textView);
            }
        } else {
            mToast = Toast.makeText((Context)context, (CharSequence)"", (int)0);
        }
    }

    public static void show(Object object) {
        RingToast.show(object != null ? object.toString() : "null");
    }

    public static void show(int id) {
        if (mToast == null) {
            throw new IllegalStateException("ToastUtils has not been initialized");
        }
        try {
            RingToast.show(mToast.getView().getContext().getResources().getText(id));
        }
        catch (Resources.NotFoundException ignored) {
            RingToast.show(String.valueOf(id));
        }
    }

    public static void show(CharSequence text) {
        RingLog.d(text);
        if (mToast == null) {
            throw new IllegalStateException("ToastUtils has not been initialized");
        }
        if (text == null || text.equals("")) {
            return;
        }
        if (text.length() > 20) {
            mToast.setDuration(1);
        } else {
            mToast.setDuration(0);
        }
        try {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                mToast.setText(text);
                mToast.show();
            } else {
                Looper.prepare();
                mToast.setText(text);
                mToast.show();
                Looper.loop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Toast getToast() {
        return mToast;
    }

    public static void setView(View view) {
        if (view == null) {
            throw new IllegalArgumentException("Views cannot be empty");
        }
        mToast.setView(view);
    }

    public static void initStyle(IToastStyle style) {
        if (style != null) {
            mToastStyle = style;
            if (mToast != null) {
                mToast.cancel();
                RingToast.init(mContext);
            }
        }
    }
}

