/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.other;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import com.ljy.devring.logger.RingLog;
import com.ljy.devring.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CrashDiary
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = CrashDiary.class.getSimpleName();
    private Context mContext;
    private File mDiaryFolder;
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private DateFormat mFormatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.getDefault());
    private Map<String, String> mInformation = new HashMap<String, String>();

    public void init(Context context, File diaryFolder) {
        this.mContext = context;
        this.mDiaryFolder = diaryFolder;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (this.mDefaultHandler != null && !this.handleException(ex)) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                RingLog.t(TAG).e(e, "error : ", new Object[0]);
            }
            System.exit(0);
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        this.collectDeviceInfo(this.mContext);
        this.saveCrashInfo2File(ex);
        return true;
    }

    private void collectDeviceInfo(Context ctx) {
        Field[] fields;
        try {
            PackageManager pm = ctx.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(ctx.getPackageName(), 1);
            if (pi != null) {
                String versionName = pi.versionName == null ? "null" : pi.versionName;
                String versionCode = pi.versionCode + "";
                this.mInformation.put("versionName", versionName);
                this.mInformation.put("versionCode", versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            RingLog.t(TAG).e(e, "an error occured when collect package info", new Object[0]);
        }
        for (Field field : fields = Build.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                this.mInformation.put(field.getName(), field.get(null).toString());
                RingLog.t(TAG).e(field.getName() + " : " + field.get(null), new Object[0]);
            }
            catch (Exception e) {
                RingLog.t(TAG).e(e, "an error occured when collect crash info", new Object[0]);
            }
        }
    }

    private String saveCrashInfo2File(Throwable ex) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.mInformation.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key + "=" + value + "\n");
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String result = ((Object)writer).toString();
        sb.append(result);
        RingLog.t(TAG).e(sb.toString(), new Object[0]);
        try {
            String time = this.mFormatter.format(new Date());
            String fileName = time + ".txt";
            if (Environment.getExternalStorageState().equals("mounted")) {
                File fileOutput;
                if (this.mDiaryFolder != null && this.mDiaryFolder.isDirectory()) {
                    fileOutput = FileUtil.getFile(this.mDiaryFolder, fileName);
                } else {
                    File dirTemp = FileUtil.getDirectory(FileUtil.getExternalCacheDir(this.mContext), "crash_log");
                    fileOutput = FileUtil.getFile(dirTemp, fileName);
                }
                if (fileOutput == null) {
                    RingLog.t(TAG).e("\u6587\u4ef6\u521b\u5efa\u5931\u8d25!", new Object[0]);
                    return null;
                }
                FileOutputStream fos = new FileOutputStream(fileOutput);
                fos.write(sb.toString().getBytes());
                fos.close();
            }
            return fileName;
        }
        catch (Exception e) {
            RingLog.t(TAG).e(e, "an error occured while writing file...", new Object[0]);
            return null;
        }
    }
}

