/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.other;

import android.app.Activity;
import android.os.Process;
import com.ljy.devring.logger.RingLog;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ActivityListManager {
    public static final String IS_NOT_ADD_ACTIVITY_LIST = "is_not_add_activity_list";
    private List<Activity> mActivityList;
    private Activity mCurrentActivity;

    public void setCurrentActivity(Activity currentActivity) {
        this.mCurrentActivity = currentActivity;
    }

    public Activity getCurrentActivity() {
        return this.mCurrentActivity != null ? this.mCurrentActivity : null;
    }

    public Activity getTopActivity() {
        if (this.mActivityList == null) {
            RingLog.w("mActivityList == null when getTopActivity()", new Object[0]);
            return null;
        }
        return this.mActivityList.size() > 0 ? this.mActivityList.get(this.mActivityList.size() - 1) : null;
    }

    public List<Activity> getActivityList() {
        if (this.mActivityList == null) {
            this.mActivityList = new LinkedList<Activity>();
        }
        return this.mActivityList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivity(Activity activity) {
        Class<ActivityListManager> clazz = ActivityListManager.class;
        synchronized (ActivityListManager.class) {
            List<Activity> activities = this.getActivityList();
            if (!activities.contains(activity)) {
                activities.add(activity);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivity(Activity activity) {
        if (this.mActivityList == null) {
            RingLog.w("mActivityList == null when removeActivity(Activity)", new Object[0]);
            return;
        }
        Class<ActivityListManager> clazz = ActivityListManager.class;
        synchronized (ActivityListManager.class) {
            if (this.mActivityList.contains(activity)) {
                this.mActivityList.remove(activity);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity removeActivity(int location) {
        if (this.mActivityList == null) {
            RingLog.w("mActivityList == null when removeActivity(int)", new Object[0]);
            return null;
        }
        Class<ActivityListManager> clazz = ActivityListManager.class;
        synchronized (ActivityListManager.class) {
            if (location > 0 && location < this.mActivityList.size()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mActivityList.remove(location);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killActivity(Class<?> activityClass) {
        if (this.mActivityList == null) {
            RingLog.w("mActivityList == null when killActivity(Class)", new Object[0]);
            return;
        }
        Class<ActivityListManager> clazz = ActivityListManager.class;
        synchronized (ActivityListManager.class) {
            Iterator<Activity> iterator = this.getActivityList().iterator();
            while (iterator.hasNext()) {
                Activity next = iterator.next();
                if (!next.getClass().equals(activityClass)) continue;
                iterator.remove();
                next.finish();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean activityInstanceIsLive(Activity activity) {
        if (this.mActivityList == null) {
            RingLog.w("mActivityList == null when activityInstanceIsLive(Activity)", new Object[0]);
            return false;
        }
        return this.mActivityList.contains(activity);
    }

    public boolean activityClassIsLive(Class<?> activityClass) {
        if (this.mActivityList == null) {
            RingLog.w("mActivityList == null when activityClassIsLive(Class)", new Object[0]);
            return false;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            return true;
        }
        return false;
    }

    public Activity findActivity(Class<?> activityClass) {
        if (this.mActivityList == null) {
            RingLog.w("mActivityList == null when findActivity(Class)", new Object[0]);
            return null;
        }
        for (Activity activity : this.mActivityList) {
            if (!activity.getClass().equals(activityClass)) continue;
            return activity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        Class<ActivityListManager> clazz = ActivityListManager.class;
        synchronized (ActivityListManager.class) {
            Iterator<Activity> iterator = this.getActivityList().iterator();
            while (iterator.hasNext()) {
                Activity next = iterator.next();
                iterator.remove();
                next.finish();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllExclude(Class<?> ... excludeActivityClasses) {
        List<Class<?>> excludeList = Arrays.asList(excludeActivityClasses);
        Class<ActivityListManager> clazz = ActivityListManager.class;
        synchronized (ActivityListManager.class) {
            Iterator<Activity> iterator = this.getActivityList().iterator();
            while (iterator.hasNext()) {
                Activity next = iterator.next();
                if (excludeList.contains(next.getClass())) continue;
                iterator.remove();
                next.finish();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAllExclude(String ... excludeActivityName) {
        List<String> excludeList = Arrays.asList(excludeActivityName);
        Class<ActivityListManager> clazz = ActivityListManager.class;
        synchronized (ActivityListManager.class) {
            Iterator<Activity> iterator = this.getActivityList().iterator();
            while (iterator.hasNext()) {
                Activity next = iterator.next();
                if (excludeList.contains(next.getClass().getName())) continue;
                iterator.remove();
                next.finish();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void exitApp() {
        try {
            this.killAll();
            Process.killProcess((int)Process.myPid());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

