/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.logger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ljy.devring.logger.LogAdapter;
import com.ljy.devring.logger.LoggerPrinter;
import com.ljy.devring.logger.Printer;
import com.ljy.devring.logger.Utils;

public final class RingLog {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    @NonNull
    private static Printer printer = new LoggerPrinter();

    private RingLog() {
    }

    public static void printer(@NonNull Printer printer) {
        RingLog.printer = Utils.checkNotNull(printer);
    }

    public static void addLogAdapter(@NonNull LogAdapter adapter) {
        printer.addAdapter(Utils.checkNotNull(adapter));
    }

    public static void clearLogAdapters() {
        printer.clearLogAdapters();
    }

    public static Printer t(@Nullable String tag) {
        return printer.t(tag);
    }

    public static void log(int priority, @Nullable String tag, @Nullable String message, @Nullable Throwable throwable) {
        printer.log(priority, tag, message, throwable);
    }

    public static void d(@NonNull String message, Object ... args) {
        printer.d(message, args);
    }

    public static void d(@Nullable Object object) {
        printer.d(object);
    }

    public static void e(@NonNull String message, Object ... args) {
        printer.e(null, message, args);
    }

    public static void e(@Nullable Throwable throwable, @NonNull String message, Object ... args) {
        printer.e(throwable, message, args);
    }

    public static void i(@NonNull String message, Object ... args) {
        printer.i(message, args);
    }

    public static void v(@NonNull String message, Object ... args) {
        printer.v(message, args);
    }

    public static void w(@NonNull String message, Object ... args) {
        printer.w(message, args);
    }

    public static void wtf(@NonNull String message, Object ... args) {
        printer.wtf(message, args);
    }

    public static void json(@Nullable String json) {
        printer.json(json);
    }

    public static void xml(@Nullable String xml) {
        printer.xml(xml);
    }
}

