/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.logger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ljy.devring.logger.LogAdapter;
import com.ljy.devring.logger.Printer;
import com.ljy.devring.logger.Utils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class LoggerPrinter
implements Printer {
    private static final int JSON_INDENT = 2;
    private final ThreadLocal<String> localTag = new ThreadLocal();
    private final List<LogAdapter> logAdapters = new ArrayList<LogAdapter>();

    LoggerPrinter() {
    }

    @Override
    public Printer t(String tag) {
        if (tag != null) {
            this.localTag.set(tag);
        }
        return this;
    }

    @Override
    public void d(@NonNull String message, Object ... args) {
        this.log(3, null, message, args);
    }

    @Override
    public void d(@Nullable Object object) {
        this.log(3, null, Utils.toString(object), new Object[0]);
    }

    @Override
    public void e(@NonNull String message, Object ... args) {
        this.e(null, message, args);
    }

    @Override
    public void e(@Nullable Throwable throwable, @NonNull String message, Object ... args) {
        this.log(6, throwable, message, args);
    }

    @Override
    public void w(@NonNull String message, Object ... args) {
        this.log(5, null, message, args);
    }

    @Override
    public void i(@NonNull String message, Object ... args) {
        this.log(4, null, message, args);
    }

    @Override
    public void v(@NonNull String message, Object ... args) {
        this.log(2, null, message, args);
    }

    @Override
    public void wtf(@NonNull String message, Object ... args) {
        this.log(7, null, message, args);
    }

    @Override
    public void json(@Nullable String json) {
        if (Utils.isEmpty(json)) {
            this.d("Empty/Null json content");
            return;
        }
        try {
            json = json.trim();
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(2);
                this.d(message);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(2);
                this.d(message);
                return;
            }
            this.e("Invalid Json", new Object[0]);
        }
        catch (JSONException e) {
            this.e("Invalid Json", new Object[0]);
        }
    }

    @Override
    public void xml(@Nullable String xml) {
        if (Utils.isEmpty(xml)) {
            this.d("Empty/Null xml content");
            return;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            this.d(xmlOutput.getWriter().toString().replaceFirst(">", ">\n"));
        }
        catch (TransformerException e) {
            this.e("Invalid xml", new Object[0]);
        }
    }

    @Override
    public synchronized void log(int priority, @Nullable String tag, @Nullable String message, @Nullable Throwable throwable) {
        if (throwable != null && message != null) {
            message = message + " : " + Utils.getStackTraceString(throwable);
        }
        if (throwable != null && message == null) {
            message = Utils.getStackTraceString(throwable);
        }
        if (Utils.isEmpty(message)) {
            message = "Empty/NULL log message";
        }
        for (LogAdapter adapter : this.logAdapters) {
            if (!adapter.isLoggable(priority, tag)) continue;
            adapter.log(priority, tag, message);
        }
    }

    @Override
    public void clearLogAdapters() {
        this.logAdapters.clear();
    }

    @Override
    public void addAdapter(@NonNull LogAdapter adapter) {
        this.logAdapters.add(Utils.checkNotNull(adapter));
    }

    private synchronized void log(int priority, @Nullable Throwable throwable, @NonNull String msg, Object ... args) {
        Utils.checkNotNull(msg);
        String tag = this.getTag();
        String message = this.createMessage(msg, args);
        this.log(priority, tag, message, throwable);
    }

    @Nullable
    private String getTag() {
        String tag = this.localTag.get();
        if (tag != null) {
            this.localTag.remove();
            return tag;
        }
        return null;
    }

    @NonNull
    private String createMessage(@NonNull String message, Object ... args) {
        return args == null || args.length == 0 ? message : String.format(message, args);
    }
}

