/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.logger;

import androidx.annotation.Nullable;
import com.ljy.devring.logger.AndroidLogAdapter;
import com.ljy.devring.logger.CsvFormatStrategy;
import com.ljy.devring.logger.LogStrategy;
import com.ljy.devring.logger.LoggerConfig;
import com.ljy.devring.logger.PrettyFormatStrategy;
import com.ljy.devring.logger.RingLog;
import javax.inject.Inject;

public final class LoggerManager {
    @Inject
    LoggerConfig loggerConfig;

    public void initAndroidLogAdapter(final boolean isShowRingLog, boolean showThreadInfo, int methodCount, int methodOffset, LogStrategy logStrategy, String tag) {
        PrettyFormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder().showThreadInfo(showThreadInfo).methodCount(methodCount).methodOffset(methodOffset).logStrategy(logStrategy).tag(tag).build();
        RingLog.addLogAdapter(new AndroidLogAdapter(formatStrategy){

            @Override
            public boolean isLoggable(int priority, @Nullable String tag) {
                return isShowRingLog;
            }
        });
    }

    public void initDiskLogAdapter(final boolean isRingLogFolder, LogStrategy logStrategy, String tag) {
        CsvFormatStrategy formatStrategy = CsvFormatStrategy.newBuilder().logStrategy(logStrategy).tag(tag).build();
        RingLog.addLogAdapter(new AndroidLogAdapter(formatStrategy){

            @Override
            public boolean isLoggable(int priority, @Nullable String tag) {
                return isRingLogFolder;
            }
        });
    }
}

