/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.image.support;

import android.content.Context;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.Registry;
import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskLruCacheFactory;
import com.bumptech.glide.load.engine.cache.ExternalCacheDiskCacheFactory;
import com.bumptech.glide.load.engine.cache.LruResourceCache;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.module.AppGlideModule;
import com.ljy.devring.DevRing;
import com.ljy.devring.image.support.ImageConfig;
import com.ljy.devring.image.support.OkHttpUrlLoader;
import java.io.File;
import java.io.InputStream;

@GlideModule
public class GlideConfigModule
extends AppGlideModule {
    private ImageConfig mImageConfig = DevRing.configureImage();

    public void applyOptions(@NonNull Context context, @NonNull GlideBuilder builder) {
        if (this.mImageConfig.getDiskCacheFile() != null) {
            builder.setDiskCache((DiskCache.Factory)new DiskLruCacheFactory(new DiskLruCacheFactory.CacheDirectoryGetter(){

                public File getCacheDirectory() {
                    return GlideConfigModule.this.mImageConfig.getDiskCacheFile();
                }
            }, this.mImageConfig.getDiskCacheSize() > 0 ? (long)this.mImageConfig.getDiskCacheSize() : 0xFA00000L));
        } else if (this.mImageConfig.isDiskCacheExternal()) {
            builder.setDiskCache((DiskCache.Factory)new ExternalCacheDiskCacheFactory(context, this.mImageConfig.getDiskCacheSize() > 0 ? this.mImageConfig.getDiskCacheSize() : 0xFA00000));
        }
        if (this.mImageConfig.getMemoryCacheSize() > 0) {
            builder.setMemoryCache((MemoryCache)new LruResourceCache((long)this.mImageConfig.getMemoryCacheSize()));
        }
        if (this.mImageConfig.getBitmapPoolSize() > 0) {
            builder.setBitmapPool((BitmapPool)new LruBitmapPool((long)this.mImageConfig.getBitmapPoolSize()));
        }
    }

    public void registerComponents(@NonNull Context context, @NonNull Glide glide, @NonNull Registry registry) {
        if (this.mImageConfig.isUseOkhttp()) {
            registry.replace(GlideUrl.class, InputStream.class, (ModelLoaderFactory)new OkHttpUrlLoader.Factory());
        }
    }

    public boolean isManifestParsingEnabled() {
        return false;
    }
}

