/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.ljy.devring.DevRing;
import com.ljy.devring.image.support.CircleBorderTransformation;
import com.ljy.devring.image.support.IImageManager;
import com.ljy.devring.image.support.ImageConfig;
import com.ljy.devring.image.support.ImageListener;
import com.ljy.devring.image.support.LoadOption;
import com.ljy.devring.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.wasabeef.glide.transformations.BlurTransformation;
import jp.wasabeef.glide.transformations.GrayscaleTransformation;
import jp.wasabeef.glide.transformations.RoundedCornersTransformation;

public class GlideManager
implements IImageManager {
    private Context mContext;
    private ImageConfig mImageConfig;
    private ExecutorService cacheThreadPool;

    @Override
    public void init(Context context, ImageConfig imageConfig) {
        this.mContext = context;
        this.mImageConfig = imageConfig;
    }

    @Override
    public void loadNet(String url, ImageView imageView) {
        this.load(Glide.with((Context)imageView.getContext()).load(url), null).into(imageView);
    }

    @Override
    public void loadNet(String url, ImageView imageView, LoadOption loadOption) {
        this.load(Glide.with((Context)imageView.getContext()).load(url), loadOption).into(imageView);
    }

    @Override
    public void loadRes(int resId, ImageView imageView) {
        this.load(Glide.with((Context)imageView.getContext()).load(Integer.valueOf(resId)), null).into(imageView);
    }

    @Override
    public void loadRes(int resId, ImageView imageView, LoadOption loadOption) {
        this.load(Glide.with((Context)imageView.getContext()).load(Integer.valueOf(resId)), loadOption).into(imageView);
    }

    @Override
    public void loadAsset(String assetName, ImageView imageView) {
        this.load(Glide.with((Context)imageView.getContext()).load("file:///android_asset/" + assetName), null).into(imageView);
    }

    @Override
    public void loadAsset(String assetName, ImageView imageView, LoadOption loadOption) {
        this.load(Glide.with((Context)imageView.getContext()).load("file:///android_asset/" + assetName), loadOption).into(imageView);
    }

    @Override
    public void loadFile(File file, ImageView imageView) {
        this.load(Glide.with((Context)imageView.getContext()).load(file), null).into(imageView);
    }

    @Override
    public void loadFile(File file, ImageView imageView, LoadOption loadOption) {
        this.load(Glide.with((Context)imageView.getContext()).load(file), loadOption).into(imageView);
    }

    @Override
    public void preLoad(String url) {
        Glide.with((Context)this.mContext).load(url).preload();
    }

    @Override
    public void getBitmap(Context context, String url, final ImageListener<Bitmap> imageListener) {
        Glide.with((Context)context).asBitmap().load(url).listener((RequestListener)new RequestListener<Bitmap>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                if (imageListener != null) {
                    imageListener.onFail((Throwable)e);
                }
                return false;
            }

            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource) {
                if (imageListener != null) {
                    imageListener.onSuccess(resource);
                }
                return false;
            }
        }).submit(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public void downLoadImage(final Context context, final String url, final File targetFile, final ImageListener<File> imageListener) {
        if (this.cacheThreadPool == null) {
            this.cacheThreadPool = Executors.newCachedThreadPool();
        }
        this.cacheThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        File sourceFile = (File)Glide.with((Context)context).asFile().load(url).submit().get();
                        if (FileUtil.copyFile(sourceFile, targetFile) && imageListener != null) {
                            imageListener.onSuccess(targetFile);
                        }
                    }
                    catch (Exception exception) {
                        if (imageListener == null) break block3;
                        imageListener.onFail(exception);
                    }
                }
            }
        });
    }

    @Override
    public void clearMemoryCache() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Glide.get((Context)this.mContext).clearMemory();
        } else {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Glide.get((Context)GlideManager.this.mContext).clearMemory();
                }
            });
        }
    }

    @Override
    public void clearDiskCache() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Glide.get((Context)GlideManager.this.mContext).clearDiskCache();
                }
            }).start();
        } else {
            Glide.get((Context)this.mContext).clearDiskCache();
        }
    }

    private RequestBuilder load(RequestBuilder requestBuilder, LoadOption loadOption) {
        RequestOptions requestOptions = new RequestOptions();
        this.mImageConfig = DevRing.ringComponent().imageConfig();
        if (loadOption == null) {
            if (this.mImageConfig.isShowTransition()) {
                requestBuilder.transition((TransitionOptions)DrawableTransitionOptions.withCrossFade((int)600));
            }
            if (this.mImageConfig.getLoadingResId() > 0) {
                requestOptions.placeholder(this.mImageConfig.getLoadingResId());
            }
            if (this.mImageConfig.getErrorResId() > 0) {
                requestOptions.error(this.mImageConfig.getErrorResId());
            }
            requestOptions.skipMemoryCache(!this.mImageConfig.isUseMemoryCache());
            if (this.mImageConfig.isUseDiskCache()) {
                requestOptions.diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
            } else {
                requestOptions.diskCacheStrategy(DiskCacheStrategy.NONE);
            }
        } else {
            MultiTransformation multiTransformation;
            if (loadOption.isShowTransition()) {
                requestBuilder.transition((TransitionOptions)DrawableTransitionOptions.withCrossFade((int)600));
            }
            if (loadOption.getLoadingResId() > 0) {
                requestOptions.placeholder(loadOption.getLoadingResId());
            }
            if (loadOption.getErrorResId() > 0) {
                requestOptions.error(loadOption.getErrorResId());
            }
            requestOptions.skipMemoryCache(!loadOption.isUseMemoryCache());
            if (loadOption.isUseDiskCache()) {
                requestOptions.diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
            } else {
                requestOptions.diskCacheStrategy(DiskCacheStrategy.NONE);
            }
            CircleBorderTransformation circleTransformation = null;
            RoundedCornersTransformation roundedCornersTransformation = null;
            BlurTransformation blurTransformation = null;
            GrayscaleTransformation grayscaleTransformation = null;
            if (loadOption.isCircle()) {
                int borderWidth = loadOption.getBorderWidth();
                int borderColor = loadOption.getBorderColor();
                circleTransformation = borderWidth > 0 && borderColor != 0 ? new CircleBorderTransformation(borderWidth, borderColor) : new CircleBorderTransformation();
            } else if (loadOption.getRoundRadius() > 0) {
                roundedCornersTransformation = new RoundedCornersTransformation(loadOption.getRoundRadius(), 0);
            }
            if (loadOption.getBlurRadius() > 0) {
                blurTransformation = new BlurTransformation(loadOption.getBlurRadius());
            }
            if (loadOption.isGray()) {
                grayscaleTransformation = new GrayscaleTransformation();
            }
            if ((multiTransformation = this.getMultiTransformation(new Transformation[]{circleTransformation, roundedCornersTransformation, blurTransformation, grayscaleTransformation})) != null) {
                requestOptions.transform((Transformation)multiTransformation);
            }
        }
        return requestBuilder.apply((BaseRequestOptions)requestOptions);
    }

    private MultiTransformation getMultiTransformation(Transformation ... transformations) {
        ArrayList<Transformation> list = new ArrayList<Transformation>();
        for (int i = 0; i < transformations.length; ++i) {
            if (transformations[i] == null) continue;
            list.add(transformations[i]);
        }
        if (list.isEmpty()) {
            return null;
        }
        return new MultiTransformation(list);
    }
}

