/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.db;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteException;
import com.ljy.devring.db.support.ITableManger;
import com.ljy.devring.logger.RingLog;
import java.lang.reflect.Method;
import java.util.List;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.query.Query;
import org.greenrobot.greendao.query.QueryBuilder;

public abstract class GreenTableManager<M, K>
implements ITableManger<M, K> {
    public abstract AbstractDao<M, K> getDao();

    @Override
    public boolean insertOne(M m) {
        try {
            this.getDao().insert(m);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean insertOrReplaceOne(M m) {
        try {
            this.getDao().insertOrReplace(m);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean insertSome(List<M> list) {
        try {
            this.getDao().insertInTx(list);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean insertOrReplaceSome(List<M> list) {
        try {
            this.getDao().insertOrReplaceInTx(list);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteOne(M m) {
        try {
            this.getDao().delete(m);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteOneByKey(K key) {
        try {
            this.getDao().deleteByKey(key);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteSome(List<M> list) {
        try {
            this.getDao().deleteInTx(list);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public final boolean deleteSomeByKeys(List<K> list) {
        try {
            this.getDao().deleteByKeyInTx(list);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteAll() {
        try {
            this.getDao().deleteAll();
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateOne(M m) {
        try {
            this.getDao().update(m);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateSome(List<M> list) {
        try {
            this.getDao().updateInTx(list);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public M loadOne(K key) {
        try {
            return (M)this.getDao().load(key);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return null;
        }
    }

    @Override
    public List<M> loadAll() {
        return this.getDao().loadAll();
    }

    @Override
    public long count() {
        return this.getDao().count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<M> queryBySQL(String sql, String[] selectionArgs) {
        List list = null;
        try (Cursor cursor = null;){
            cursor = this.getDao().getSession().getDatabase().rawQuery(sql, selectionArgs);
            Method method = AbstractDao.class.getDeclaredMethod("loadAllAndCloseCursor", Cursor.class);
            method.setAccessible(true);
            list = (List)method.invoke(this.getDao(), cursor);
        }
        return list;
    }

    @Override
    public boolean execSQL(String sql) {
        try {
            this.getDao().getSession().getDatabase().execSQL(sql);
        }
        catch (SQLException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    public boolean refresh(M m) {
        try {
            this.getDao().refresh(m);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
            return false;
        }
        return true;
    }

    public void runInTx(Runnable runnable) {
        try {
            this.getDao().getSession().runInTx(runnable);
        }
        catch (SQLiteException e) {
            RingLog.e(e, "message", new Object[0]);
        }
    }

    public QueryBuilder<M> queryBuilder() {
        return this.getDao().queryBuilder();
    }

    public Query<M> queryRawCreate(String where, Object ... selectionArg) {
        return this.getDao().queryRawCreate(where, selectionArg);
    }

    public void clearCache() {
        this.getDao().detachAll();
    }
}

