/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.cache.support;

import android.text.TextUtils;
import android.util.LruCache;
import com.ljy.devring.logger.RingLog;

public class MemoryCache {
    private LruCache<String, Object> cache;

    public MemoryCache() {
        int maxMemory = (int)Runtime.getRuntime().maxMemory();
        int cacheSize = maxMemory / 8;
        this.cache = new LruCache(cacheSize);
    }

    public synchronized void put(String key, Object value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (this.cache.get((Object)key) != null) {
            this.cache.remove((Object)key);
        }
        this.cache.put((Object)key, value);
    }

    public Object get(String key) {
        return this.cache.get((Object)key);
    }

    public synchronized <T> T get(String key, Class<T> clazz) {
        try {
            return (T)this.cache.get((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            RingLog.e(e, "message", new Object[0]);
            return null;
        }
    }

    public void remove(String key) {
        if (this.cache.get((Object)key) != null) {
            this.cache.remove((Object)key);
        }
    }

    public boolean contains(String key) {
        return this.cache.get((Object)key) != null;
    }

    public void clear() {
        this.cache.evictAll();
    }
}

