/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.base.fragment;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import com.ljy.devring.DevRing;
import com.ljy.devring.base.fragment.IBaseFragment;
import com.ljy.devring.base.fragment.IFragmentLife;
import com.trello.rxlifecycle3.android.FragmentEvent;
import io.reactivex.subjects.PublishSubject;

public class FragmentLife
implements IFragmentLife {
    private static final String SAVED_STATE = "saved_state";
    private final PublishSubject<FragmentEvent> mLifecycleSubject = PublishSubject.create();
    private Fragment mFragment;
    private View mContentView;
    private Bundle mSavedState;

    @Override
    public void onAttach(Fragment fragment, Context context) {
        this.mFragment = fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.mLifecycleSubject.onNext((Object)FragmentEvent.CREATE);
        if (((IBaseFragment)this.mFragment).isUseEventBus()) {
            DevRing.busManager().register(this.mFragment);
        }
    }

    @Override
    public void onCreateView(View view, Bundle savedInstanceState) {
        this.mLifecycleSubject.onNext((Object)FragmentEvent.CREATE_VIEW);
        this.mContentView = view;
    }

    @Override
    public void onActivityCreate(Bundle savedInstanceState) {
        this.restoreStateFromArguments();
    }

    @Override
    public void onStart() {
        this.mLifecycleSubject.onNext((Object)FragmentEvent.START);
    }

    @Override
    public void onResume() {
        this.mLifecycleSubject.onNext((Object)FragmentEvent.RESUME);
    }

    @Override
    public void onPause() {
        this.mLifecycleSubject.onNext((Object)FragmentEvent.PAUSE);
    }

    @Override
    public void onStop() {
        this.mLifecycleSubject.onNext((Object)FragmentEvent.STOP);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        this.saveStateToArguments();
    }

    @Override
    public void onDestroyView() {
        ViewGroup parent;
        this.mLifecycleSubject.onNext((Object)FragmentEvent.DESTROY_VIEW);
        if (this.mContentView != null && (parent = (ViewGroup)this.mContentView.getParent()) != null) {
            parent.removeView(this.mContentView);
        }
        this.saveStateToArguments();
    }

    @Override
    public void onDestroy() {
        this.mLifecycleSubject.onNext((Object)FragmentEvent.DESTROY);
        if (((IBaseFragment)this.mFragment).isUseEventBus()) {
            DevRing.busManager().unregister(this.mFragment);
        }
        this.mContentView = null;
        this.mFragment = null;
    }

    @Override
    public void onDetach() {
        this.mLifecycleSubject.onNext((Object)FragmentEvent.DETACH);
    }

    @Override
    public boolean isAdded() {
        return this.mFragment != null && this.mFragment.isAdded();
    }

    private void saveStateToArguments() {
        Bundle b;
        if (this.mFragment.getView() != null) {
            Bundle state = new Bundle();
            ((IBaseFragment)this.mFragment).onSaveState(state);
            this.mSavedState = state;
        }
        if (this.mSavedState != null && (b = this.mFragment.getArguments()) != null) {
            b.putBundle(SAVED_STATE, this.mSavedState);
        }
    }

    private void restoreStateFromArguments() {
        Bundle b = this.mFragment.getArguments();
        if (b != null) {
            this.mSavedState = b.getBundle(SAVED_STATE);
            if (this.mSavedState != null) {
                ((IBaseFragment)this.mFragment).onRestoreState(this.mSavedState);
            }
        }
    }

    public PublishSubject<FragmentEvent> getLifecycleSubject() {
        return this.mLifecycleSubject;
    }
}

