/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.base.activity;

import android.app.Activity;
import android.os.Bundle;
import com.ljy.devring.DevRing;
import com.ljy.devring.base.activity.IActivityLife;
import com.ljy.devring.base.activity.IBaseActivity;
import com.trello.rxlifecycle3.android.ActivityEvent;
import io.reactivex.subjects.PublishSubject;

public class ActivityLife
implements IActivityLife {
    private Activity mActivity;
    private final PublishSubject<ActivityEvent> mLifecycleSubject = PublishSubject.create();

    @Override
    public void onCreate(Activity activity, Bundle savedInstanceState) {
        this.mActivity = activity;
        this.mLifecycleSubject.onNext((Object)ActivityEvent.CREATE);
        boolean isNotAdd = false;
        if (activity.getIntent() != null) {
            isNotAdd = activity.getIntent().getBooleanExtra("is_not_add_activity_list", false);
        }
        if (!isNotAdd) {
            DevRing.activityListManager().addActivity(activity);
        }
    }

    @Override
    public void onStart() {
        this.mLifecycleSubject.onNext((Object)ActivityEvent.START);
        if (((IBaseActivity)this.mActivity).isUseEventBus()) {
            DevRing.busManager().register(this.mActivity);
        }
    }

    @Override
    public void onResume() {
        DevRing.activityListManager().setCurrentActivity(this.mActivity);
        this.mLifecycleSubject.onNext((Object)ActivityEvent.RESUME);
    }

    @Override
    public void onPause() {
        this.mLifecycleSubject.onNext((Object)ActivityEvent.PAUSE);
    }

    @Override
    public void onStop() {
        if (DevRing.activityListManager().getCurrentActivity() == this.mActivity) {
            DevRing.activityListManager().setCurrentActivity(null);
        }
        this.mLifecycleSubject.onNext((Object)ActivityEvent.STOP);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    }

    @Override
    public void onDestroy() {
        this.mLifecycleSubject.onNext((Object)ActivityEvent.DESTROY);
        DevRing.activityListManager().removeActivity(this.mActivity);
        if (((IBaseActivity)this.mActivity).isUseEventBus()) {
            DevRing.busManager().unregister(this.mActivity);
        }
        this.mActivity = null;
    }

    public PublishSubject<ActivityEvent> getLifecycleSubject() {
        return this.mLifecycleSubject;
    }
}

