/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring;

import android.app.Application;
import android.content.Context;
import com.ljy.devring.bus.BusConfig;
import com.ljy.devring.bus.EventBusManager;
import com.ljy.devring.bus.support.IBusManager;
import com.ljy.devring.cache.CacheConfig;
import com.ljy.devring.cache.CacheManager;
import com.ljy.devring.db.support.IDBManager;
import com.ljy.devring.db.support.ITableManger;
import com.ljy.devring.di.component.DaggerRingComponent;
import com.ljy.devring.di.component.RingComponent;
import com.ljy.devring.http.HttpConfig;
import com.ljy.devring.http.HttpManager;
import com.ljy.devring.image.support.IImageManager;
import com.ljy.devring.image.support.ImageConfig;
import com.ljy.devring.logger.LoggerConfig;
import com.ljy.devring.logger.LoggerManager;
import com.ljy.devring.other.ActivityListManager;
import com.ljy.devring.other.OtherConfig;
import com.ljy.devring.other.PermissionManager;
import com.ljy.devring.other.toast.RingToast;
import com.ljy.devring.util.Preconditions;

public class DevRing {
    private static RingComponent mRingComponent;
    private static IDBManager mDBManager;
    private static IBusManager mBusManager;
    private static IImageManager mImageManager;

    public static void init(Application application) {
        mRingComponent = DaggerRingComponent.builder().application(application).build();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)mRingComponent.activityLifeCallback());
    }

    public static void create() {
        if (mDBManager != null) {
            mDBManager.init();
            mDBManager.putTableManager(mRingComponent.mapTableManager());
        }
        if (DevRing.busManager() instanceof EventBusManager) {
            ((EventBusManager)DevRing.busManager()).openIndex();
        }
        DevRing.imageManager().init((Context)mRingComponent.application(), mRingComponent.imageConfig());
        if (mRingComponent.otherConfig().isUseCrashDiary()) {
            mRingComponent.crashDiary().init((Context)mRingComponent.application(), mRingComponent.otherConfig().getCrashDiaryFolder());
        }
        DevRing.loggerManager().initAndroidLogAdapter(mRingComponent.loggerConfig().isShowRingLog(), mRingComponent.loggerConfig().isShowThreadInfo(), mRingComponent.loggerConfig().getMethodCount(), mRingComponent.loggerConfig().getMethodOffset(), mRingComponent.loggerConfig().getLogStrategy(), mRingComponent.loggerConfig().getTag());
        DevRing.loggerManager().initDiskLogAdapter(mRingComponent.loggerConfig().isRingLogFolder(), mRingComponent.loggerConfig().getLogStrategy(), mRingComponent.loggerConfig().getTag());
        RingToast.init((Context)mRingComponent.application());
        RingToast.initStyle(mRingComponent.otherConfig().getIToastStyle());
    }

    public static RingComponent ringComponent() {
        return Preconditions.checkNotNull(mRingComponent, "RingComponent\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5728Application\u4e2d\u8c03\u7528DevRing.init(Application)\u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
    }

    public static void configureDB(IDBManager dbManager) {
        mDBManager = dbManager;
    }

    public static <T extends IDBManager> T dbManager() {
        return (T)Preconditions.checkNotNull(mDBManager, "\u8bf7\u5148\u5728Application\u4e2d\u8c03\u7528DevRing.configureDB(IDBManager)\u65b9\u6cd5\u8bbe\u7f6e\u6570\u636e\u5e93\u7ba1\u7406\u7c7b");
    }

    public static <T extends ITableManger> T tableManager(Object key) {
        return (T)((ITableManger)Preconditions.checkNotNull(mRingComponent.mapTableManager().get(key), "\u6ca1\u627e\u5230\u8be5Key\u503c\u5bf9\u5e94\u7684\u6570\u636e\u8868\u7ba1\u7406\u8005\uff0c\u8bf7\u68c0\u67e5IDBManager\u5b9e\u73b0\u7c7b\u4e2d\u7684putTableManager(Map<Object,ITableManager>)\u65b9\u6cd5"));
    }

    public static BusConfig configureBus() {
        return mRingComponent.busConfig();
    }

    public static void configureBus(IBusManager busManager) {
        mBusManager = busManager;
    }

    public static <T extends IBusManager> T busManager() {
        if (mBusManager != null) {
            return (T)mBusManager;
        }
        return (T)mRingComponent.busManager();
    }

    public static ImageConfig configureImage() {
        return mRingComponent.imageConfig();
    }

    public static ImageConfig configureImage(IImageManager imageManager) {
        mImageManager = imageManager;
        return mRingComponent.imageConfig();
    }

    public static <T extends IImageManager> T imageManager() {
        if (mImageManager != null) {
            return (T)mImageManager;
        }
        return (T)mRingComponent.imageManager();
    }

    public static CacheConfig configureCache() {
        return mRingComponent.cacheConfig();
    }

    public static CacheManager cacheManager() {
        return mRingComponent.cacheManager();
    }

    public static HttpConfig configureHttp() {
        return mRingComponent.httpConfig();
    }

    public static HttpManager httpManager() {
        return mRingComponent.httpManager();
    }

    public static LoggerManager loggerManager() {
        return mRingComponent.loggerManager();
    }

    public static LoggerConfig loggerConfig() {
        return mRingComponent.loggerConfig();
    }

    public static OtherConfig configureOther() {
        return mRingComponent.otherConfig();
    }

    public static ActivityListManager activityListManager() {
        return mRingComponent.activityListManager();
    }

    public static PermissionManager permissionManager() {
        return mRingComponent.permissionManager();
    }

    public static Application application() {
        return mRingComponent.application();
    }
}

