/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;

public class SystemTypeUtil {
    public static final int REQ_CODE_PERMISSION = 123;
    private static final String KEY_EMUI_API_LEVEL = "ro.build.hw_emui_api_level";
    private static final String KEY_EMUI_CONFIG_HW_SYS_VERSION = "ro.confg.hw_systemversion";
    private static final String KEY_EMUI_VERSION = "ro.build.version.emui";
    private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_MIUI_INTERNAL_STORAGE = "ro.miui.internal.storage";

    public static boolean isEMUI() {
        try {
            return SystemTypeUtil.getProperty(KEY_EMUI_API_LEVEL, null) != null || SystemTypeUtil.getProperty(KEY_EMUI_CONFIG_HW_SYS_VERSION, null) != null || SystemTypeUtil.getProperty(KEY_EMUI_VERSION, null) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isMIUI() {
        try {
            return SystemTypeUtil.getProperty(KEY_MIUI_VERSION_CODE, null) != null || SystemTypeUtil.getProperty(KEY_MIUI_VERSION_NAME, null) != null || SystemTypeUtil.getProperty(KEY_MIUI_INTERNAL_STORAGE, null) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isFlyme() {
        try {
            Method method = Build.class.getMethod("hasSmartBar", new Class[0]);
            return method != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getProperty(String name, String defaultValue) throws IOException {
        if (Build.VERSION.SDK_INT < 26) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
            return properties.getProperty(name, defaultValue);
        }
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method get = clz.getMethod("get", String.class, String.class);
            String property = (String)get.invoke(clz, name, defaultValue);
            if (TextUtils.isEmpty((CharSequence)property)) {
                return null;
            }
            return property;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static void goPermissionPage(Activity context) {
        if (SystemTypeUtil.isFlyme()) {
            Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.putExtra("packageName", context.getPackageName());
            try {
                context.startActivityForResult(intent, 123);
            }
            catch (Exception e) {
                e.printStackTrace();
                context.startActivityForResult(SystemTypeUtil.getAppDetailSettingIntent((Context)context), 123);
            }
        } else if (SystemTypeUtil.isMIUI()) {
            try {
                Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
                ComponentName componentName = new ComponentName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
                intent.setComponent(componentName);
                intent.putExtra("extra_pkgname", context.getPackageName());
                context.startActivityForResult(intent, 123);
            }
            catch (Exception e) {
                try {
                    Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
                    ComponentName componentName = new ComponentName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
                    intent.setComponent(componentName);
                    intent.putExtra("extra_pkgname", context.getPackageName());
                    context.startActivityForResult(intent, 123);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    context.startActivityForResult(SystemTypeUtil.getAppDetailSettingIntent((Context)context), 123);
                }
            }
        } else if (SystemTypeUtil.isEMUI()) {
            Intent intent = new Intent();
            ComponentName comp = new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
            intent.setComponent(comp);
            try {
                context.startActivityForResult(intent, 123);
            }
            catch (Exception e) {
                e.printStackTrace();
                context.startActivityForResult(SystemTypeUtil.getAppDetailSettingIntent((Context)context), 123);
            }
        } else {
            context.startActivityForResult(SystemTypeUtil.getAppDetailSettingIntent((Context)context), 123);
        }
    }

    public static Intent getAppDetailSettingIntent(Context context) {
        Intent localIntent = new Intent();
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.setAction("android.intent.action.VIEW");
            localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName());
        }
        return localIntent;
    }
}

